
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <conio.h>

FILE *fp;
char filename[80];
unsigned short iobase;
unsigned short ra;
unsigned short rb;
unsigned long la;
unsigned long lb;
unsigned short swapmon;
volatile unsigned short swapcount;
unsigned long physical;
unsigned char irq;
unsigned char dma;
unsigned char *byteptr;
unsigned char *data;

//------------------------------------------------------------------------------
void dspwrite ( unsigned char c )
{
    while(inp(iobase+0xC)&0x80);
    outp(iobase+0xC,c);
}
//------------------------------------------------------------------------------
unsigned char dspread ( void )
{
    while(!(inp(iobase+0xE)&0x80)) continue;
    return(inp(iobase+0xA));
}
//-----------------------------------------------------------------------------
void interrupt sbisr()
{
    swapcount++;
    outp(iobase+0x4,0x82); if(inp(iobase+0x5)&1) inp(iobase+0xE);
    outp(iobase+0x4,0x82); if(inp(iobase+0x5)&2) inp(iobase+0xF);
    if((irq==10)||(irq==2)) outp(0xA0,0xA0);
    outp(0x20,0x20);
}
//------------------------------------------------------------------------------
void main ( int argc, char *argv[] )
{
    if(argc==1)
    {
        printf(".WAV file not specified\n");
        exit(1);
    }
    //Look for Sound Blaster 16
    for(iobase=0x220;iobase<=0x280;iobase+=0x20)
    {
        if(inp(iobase)==0xFF) continue;
        outp(iobase+0x6,0x01);  // Reset Sound Blaster
        for(ra=0;ra<65000;ra++) continue; //At least 3ms delay
        outp(iobase+0x6,0x00);
        for(ra=0;ra<65000;ra++) if(dspread()==0xAA) break;
        if(ra<65000) break;
    }
    if(iobase>0x280)
    {
        printf("Sound Blaster not detected\n");
        exit(1);
    }
    dspwrite(0xE1);   // Get DSP Version Number
    ra=dspread();
    rb=dspread();
    printf("Sound Blaster Detected, DSP Version %u.%02u\n",ra,rb);
    if(ra!=4)
    {
        printf("Only Sound Blaster DSP Versions 4.xx (SB16) supported.\n");
        exit(1);
    }
    outp(iobase+0x4,0x80);
    switch(inp(iobase+0x5)&0xF)
    {
        case 0x00:
            printf("IRQ Line not set\n");
            exit(1);
        case 0x01: irq=2; break;
        case 0x02: irq=5; break;
        case 0x04: irq=7; break;
        case 0x08: irq=10; break;
    }
    printf("IRQ %u  ",irq);
    outp(iobase+0x4,0x81);
    switch(inp(iobase+0x5)&0xE0)
    {
        case 0x00:
            switch(inp(iobase+0x5)&0x0B)
            {
                case 0x00:
                    printf("DMA Channel not set\n");
                    exit(1);
                case 0x01: dma=0; break;
                case 0x02: dma=1; break;
                case 0x08: dma=3; break;
            }
            break;
        case 0x20: dma=5; break;
        case 0x40: dma=6; break;
        case 0x80: dma=7; break;
    }
    printf("DMA %u  ",dma);
    printf("\n");

    //Allocate  the memory
    data=malloc(32768);
    if(data==NULL)
    {
        printf("\nError Allocating Memory\n");
        exit(1);
    }
    physical=((unsigned long)FP_SEG(data)<<4)+FP_OFF(data);
    if((physical&0xFF0000)!=((physical+16383)&0xFF0000))
    {
        printf("\nPage Boundary crossing! %06lXh %06lXh\n",physical,physical+16383);
    }
    // Create the file
    strcpy(filename,argv[1]);
    if(strlen(filename)<5)
    {
        strcat(filename,".WAV");
    }
    else
    {
        ra=1;
        rb=strlen(filename);
        if(filename[rb-4]=='.')
        if((filename[rb-3]=='W')||(filename[rb-3]=='w'))
        if((filename[rb-2]=='A')||(filename[rb-2]=='a'))
        if((filename[rb-1]=='V')||(filename[rb-1]=='v')) ra=0;
        if(ra)
        {
            strcat(filename,".WAV");
        }
    }
    if((fp=fopen(filename,"rb"))!=NULL)
    {
        printf("File [%s] already exists, ESC to abort now, any other key to continue\n",filename);
        while(kbhit()) getch();
        if(getch()==0x1B) exit(1);
        fclose(fp);
    }
    if((fp=fopen(filename,"wb+"))==NULL)
    {
        printf("Error creating file [%s]\n",filename);
        exit(1);
    }
    la=0x46464952; fwrite(&la,1,4,fp); // RIFF file

    la=0; fwrite(&la,1,4,fp);          // Filesize
    la=0x45564157; fwrite(&la,1,4,fp); // WAVE file

    la=0x20746D66; fwrite(&la,1,4,fp); // Format Chunk
    la=16; fwrite(&la,1,4,fp);      // Format Chunk size
    ra=0x0001; fwrite(&ra,1,2,fp);  // Format Tag
    ra=0x0001; fwrite(&ra,1,2,fp);  // Channels
//    la=11025; fwrite(&la,1,4,fp);   // Sample Rate
    la=44100; fwrite(&la,1,4,fp);   // Sample Rate
    byteptr=(void *)&la;
    dspwrite(0x42);
    dspwrite(byteptr[1]);
    dspwrite(byteptr[0]);

    la=11025; fwrite(&la,1,4,fp);   // Average Bytes Per Second
    ra=1; fwrite(&ra,1,2,fp);       // Data Block size
    ra=16; fwrite(&ra,1,2,fp);      // Bits Per Sample

    la=0x61746164; fwrite(&la,1,4,fp); //Data Chunk
    la=0; fwrite(&la,1,4,fp);       // Data Chunk size

    switch(irq) // Disable Interrupt
    {
        case  2: outp(0xA1,inp(0xA1)|0x02); break;
        case  5: outp(0x21,inp(0x21)|0x20); break;
        case  7: outp(0x21,inp(0x21)|0x80); break;
        case 10: outp(0xA1,inp(0xA1)|0x04); break;
    }
    switch(irq) // Set Interrupt Vector
    {
        case 2:         setvect(0x68+9,sbisr); break;
        case 5: case 7: setvect(0x08+irq,sbisr); break;
        case 10:        setvect(0x68+irq,sbisr); break;
    }
    inp(iobase+0xF); // Clear Interrupt on Sound Blaster
    switch(irq) // Enable Interrupt
    {
        case  2: outp(0xA1,inp(0xA1)&0xFD); break;
        case  5: outp(0x21,inp(0x21)&0xDF); break;
        case  7: outp(0x21,inp(0x21)&0x7F); break;
        case 10: outp(0xA1,inp(0xA1)&0xFB); break;
    }
    switch(dma)
    {
        case 0:
        case 1:
        case 3:
            outp(0x0A,0x04|dma);
            outp(0x0C,0x00);
            outp(0x0B,0x54|dma); //Write is record
            physical=((unsigned long)FP_SEG(data)<<4)+FP_OFF(data);
            byteptr=(void *)&physical;
            outp(dma<<1,byteptr[0]);
            outp(dma<<1,byteptr[1]);
            switch(dma)
            {
                case 0:
                    outp(0x87,byteptr[2]);
                    break;
                case 1:
                    outp(0x83,byteptr[2]);
                    break;
                case 3:
                    outp(0x82,byteptr[2]);
                    break;
            }
            outp((dma<<1)|1,0xFF); //low byte of length-1
            outp((dma<<1)|1,0x3F); //high byte of length-1
            outp(0x0A,dma);
            break;
        case 5:
        case 6:
        case 7:
            outp(0xD4,0x04|(dma&3));
            outp(0xD8,0x00);
            outp(0xD6,0x54|(dma&3)); ///Write is record
            physical=((unsigned long)FP_SEG(data)<<4)+FP_OFF(data);
            ra=physical>>=1;
            byteptr=(void *)&ra;
            outp(0xC0|((dma&3)<<2),byteptr[0]);
            outp(0xC0|((dma&3)<<2),byteptr[1]);
            physical=((unsigned long)FP_SEG(data)<<4)+FP_OFF(data);
            byteptr=(void *)&physical;
            switch(dma)
            {
                case 5:
                    outp(0x8B,byteptr[2]);
                    break;
                case 6:
                    outp(0x89,byteptr[2]);
                    break;
                case 7:
                    outp(0x8A,byteptr[2]);
                    break;
            }
            outp(0xC2|((dma&3)<<2),0xFF); //low byte of length-1
            outp(0xC2|((dma&3)<<2),0x1F); //high byte of length-1
            outp(0xD4,dma&3);
            break;
    }
    swapmon=0; swapcount=1;
    dspwrite(0xBE);
    dspwrite(0x10);
    dspwrite(0xFF); //length-1 low byte
    dspwrite(0x0F); //length-1 high byte

    while(kbhit()) getch();
    printf("0 bytes");
    while(1)
    {
        if(kbhit()) if(getch()==0x1B)
        {
            printf("\nESCape\n");
            break;
        }
        if(swapmon!=swapcount)
        {
            swapmon=swapcount;
            switch(swapmon&1)
            {
                case 0: fwrite(data,1,8192,fp); break;
                case 1: fwrite(&data[8192],1,8192,fp); break;
            }
            printf("\r%lu bytes",(ftell(fp)-0x2C)>>1);
        }
    }
    dspwrite(0xD9); //stop after this block
    while(swapmon==swapcount) continue; //wait for this block to finish
    switch(dma) //Disable DMA
    {
        case 0:
        case 1:
        case 3:
            outp(0x0A,0x04|dma);
            break;
        case 5:
        case 6:
        case 7:
            outp(0xD4,0x04|(dma&3));
            break;
    }
    switch(irq) // Disable Interrupt
    {
        case  2: outp(0xA1,inp(0xA1)|0x02); break;
        case  5: outp(0x21,inp(0x21)|0x20); break;
        case  7: outp(0x21,inp(0x21)|0x80); break;
        case 10: outp(0xA1,inp(0xA1)|0x04); break;
    }
    la=ftell(fp);
    fseek(fp,0x04UL,0); lb=la-0x08; fwrite(&lb,1,4,fp);
    fseek(fp,0x28UL,0); lb=la-0x2C; fwrite(&lb,1,4,fp);
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------

