/*
 * handles.c: Adds the ability to use more handles under Turbo C 2.0
 * Requires my patched version of Turbo C 2.0, where the _openfd and
 * close thingies from the FILES2 and CLOSE modules have been altered to
 * work with 40 files maximum instead of 20.
 * Urgh this is so ugly. Neatness requires assembly.
 * Idea based on routines by W. Metzenthen
 *
 * Author: Andrew Scott
 *
 * Date: 10/2/1994 ver 0.1
 */

#include <dos.h>
#include <mem.h>

/**
 ** MAX_HAND must be greater than 20. Note than greater than 127 may
 ** cause some networks to do very odd things. Turbo C has an upper
 ** maximum of 257. Borland C++ 3.0 has a maximum of 255 I think.
 ** The patched version of Turbo C 2.0 can handle (pun) MAX_HAND upto
 ** 40. Further patching is required for larger values.
 **/
#define MAX_HAND 40

typedef unsigned char far *blocktype;
typedef unsigned short far *psptype;

/**
 ** file_table is the storage space for the new file handle table. It is
 ** given an extra 15 bytes of size to ensure that when the start of it
 ** is decided (ie. shifted to a segment boundary) the end doesn't
 ** overflow the size of the array.
 **/
static unsigned char file_table[MAX_HAND + 15];

/*
 * increase_handles: When called, sets up the file table for MAX_HAND
 * handles to be used by Turbo C.
 *
 * date: 10/2/1994
 */
void increase_handles() {
  unsigned char junk[MAX_HAND - 20];
	unsigned short newpsp[3], psp = _psp;
  unsigned blockoff, blockseg;

	/** Put blockseg:0000 to be start of file_table **/
	blockseg = FP_SEG((blocktype) file_table);
	if ((blockoff = FP_OFF((blocktype) file_table)) & 0xF)
		blockseg++;
	blockseg += blockoff >> 4;

  memset(junk, 0xFF, MAX_HAND - 20); /** Set up junk for invalid files **/
  newpsp[0] = MAX_HAND; /** Set up new PSP information **/
  newpsp[1] = 0;
  newpsp[2] = blockseg;

  /** Move all the information into position **/
  movedata(psp, 0x0018, blockseg, 0, 20);
  movedata(FP_SEG((blocktype) junk), FP_OFF((blocktype) junk),
    blockseg, 0x0014, MAX_HAND - 20);
  movedata(FP_SEG((psptype) newpsp), FP_OFF((psptype) newpsp), psp, 0x32, 6);
}
