{ pascal implementation of mouse demo, adapted from
  the GAP Power Basic Library - Stew Benedict 9/7/93
  Turbo Pascal 6.0 version - needs EGAVGA.BGI }

program MouseDemo;

uses Graph, Crt;

var

driver, mode: Integer;
hotrow, hotcol: Integer;
xloc, yloc, button: Integer;
inkey, mousestatus: Integer;
cursloc: Integer;
string1: string[17];
cursor: array[0..31] of Word;
row, column, attribute: Byte;

procedure GraphicsText( outstring: string; row: Byte; column: Byte;
                        attribute: Byte );

          var

          I: Integer;                   { loop counter }
          singchar: char;               { single character to pass
                                          to assembly routine }

          begin

            { due to PASCAL's poor video performance, I used assembly
            to write the text to the screen here, otherwise the refresh
            rate was so slow you couldn't read the mouse status clearly }

          asm
                 mov ah,2           { service 2 - set cursor pos }
                 mov dh,row
                 mov dl,column
                 mov bh,0           { primary text page }
                 int 10H
          end;

          for I := 1 to Length(outstring) do      { loop through string
                                                    1 character at a time }
           begin

           singchar := outstring[I];

             asm

                 mov ah,0EH         { service 0E - output char and attr, TTY }
                 mov al,singchar    { character }
                 mov bh,0           { primary text page }
                 mov bl,attribute
                 mov cx,1           { # of characters }
                 int 10H

             end;

           end;

          end;

procedure MouseExists( mousestatus: Integer );

          begin

               asm
                    mov ax,0                   { service to check mouse }
                    int 33H
                    mov mousestatus,ax
               end;

          if ( mousestatus <> -1 ) then WriteLn( ' NO MOUSE PRESENT ');

          end;

procedure Mouse ( cursloc: Integer; hotrow: Integer; hotcol: Integer );

          begin

               asm
                    mov ax,9                 { initialize cursor with }
                    mov bx,hotcol            { hotspot and starting   }
                    mov cx,hotrow            { address of cursor data }
                    mov dx,cursloc
                    push ds                  { set extra segment to data }
                    pop es                   { segment }
                    int 33H
                    mov ax,7                 { service to set mouse horz range }
                    mov cx,0                 { minimum value }
                    mov dx,640               { maximum value }
                    int 33H
                    mov ax,8                 { service to set mouse vert range }
                    mov cx,0                 { minimum value }
                    mov dx,480               { maximum value }
                    int 33H
                    mov ax,1                 { show mouse cursor }
                    int 33H
               end;
          end;

procedure MouseHide;

          begin

               asm
                    mov ax,2                 { hide mouse cursor }
                    int 33H
               end;
          end;

procedure MouseShow;

          begin

               asm
                   mov ax,1                  { show mouse cursor }
                   int 33H
               end;
          end;

procedure MouseButton ( xloc: Integer; yloc: Integer; button: Integer );

          var

          xstring: string[3];               { string for x data }
          ystring: string[3];               { string for y data }
          buttonstring: string[1];          { string for button status }
          passtring: string[30];            { combined string }
          row, column, attribute:  Byte;

          begin

               asm
                    mov ax,3                { poll mouse for x,y, button }
                    mov bx,0
                    int 33H
                    mov button,bx
                    mov xloc,cx
                    mov yloc,dx
               end;

          str( xloc, xstring);              { convert values to strings and pad }
          str( 480 - yloc, ystring);

          if Length(ystring) = 1 then ystring := ystring + '  ';
          if Length(ystring) = 2 then ystring := ystring + ' ';
          if Length(xstring) = 1 then xstring := xstring + '  ';
          if Length(xstring) = 2 then xstring := xstring + ' ';

          str( button, buttonstring );

          { combine strings into one }

          passtring := ' X: '+ xstring + ' Y: ' + ystring +
                        ' BUTTON: ' + buttonstring + ' ';
          row := 14;
          column := 3;
          attribute := 15;

          GraphicsText( passtring, row, column, attribute );

          end;

begin                  { main program loop }

     driver := 9;             { VGA driver }
     mode := 2;               { 640 x 480 }
     hotrow :=  0;            { hotspot row for cursor }
     hotcol :=  0;            { hotspot col for cursor }
     inkey := 1;              { initialize inkey for keyboard scan }
     mousestatus := 0;
     string1 := 'HIT <ESC> TO EXIT';

     cursor[0] := $9FFF;      { screen mask for cursor }
     cursor[1] := $8FFF;
     cursor[2] := $87FF;
     cursor[3] := $83FF;
     cursor[4] := $81FF;
     cursor[5] := $80FF;
     cursor[6] := $807F;
     cursor[7] := $803F;
     cursor[8] := $801F;
     cursor[9] := $800F;
     cursor[10] := $80FF;
     cursor[11] := $887F;
     cursor[12] := $BC7F;
     cursor[13] := $FC3F;
     cursor[14] := $FE1F;
     cursor[15] := $FE0F;

     cursor[16] := $0000;     { cursor mask for cursor }
     cursor[17] := $2000;
     cursor[18] := $3000;
     cursor[19] := $3800;
     cursor[20] := $3C00;
     cursor[21] := $3E00;
     cursor[22] := $3F00;
     cursor[23] := $3F80;
     cursor[24] := $3FC0;
     cursor[25] := $3E00;
     cursor[26] := $3600;
     cursor[27] := $2300;
     cursor[28] := $0100;
     cursor[29] := $0180;
     cursor[30] := $00C0;
     cursor[31] := $0000;

     { check for mouse }

     MouseExists( mousestatus );

     { getstarting address of cursor data }

     cursloc := Ofs(cursor[0]);

     { initialize VGA graphics mode }

     InitGraph( driver, mode, 'c:\tp\BGI' );

     {set fill color to light red }

     SetFillStyle( SolidFill, EGALightRed );

     { fill screen }

     Bar( 0, 0, 639, 479 );

     { set color to white }

     SetColor( EGAWhite );

     { draw a border }

     Rectangle ( 0, 0, 639, 479 );

     row := 2;
     column := 32;
     attribute := 15;

     GraphicsText ( string1, row, column, attribute );   { display message }

     Mouse( cursloc, hotrow, hotcol );
     while (inkey <> 27) do                   { loop until ESC }
       begin
         if (Keypressed) then inkey := ord(ReadKey);
         MouseButton( xloc, yloc, button );
         if ( inkey = 49 ) then               { on "1" hide cursor }
         begin
           mousehide;
           inkey := 0;                        { reset inkey }
         end;
         if ( inkey = 50 ) then               { on "2" show cursor }
         begin
           mouseshow;
           inkey := 0;                        { reset inkey }
         end;
       end;
       RestoreCrtMode;
end.



