/* c implementation of mouse demo, adapted from    */
/* GAP Power Basic Library - Stew Benedict  9/4/93 */
/* Turbo C/C++ version 3 - small memory model      */
/* include graphics.lib - requires VGA adapter     */

#include <graphics.h>
#include <stdio.h>

int driver = 9;       /* VGA mode */
int mode = 2;         /* 640x480  */
int hotrow = 0;       /* cursor hotspot row */
int hotcol = 0;       /* cursor hotspot column */
int xloc;             /* x location of mouse */
int yloc;             /* y location of mouse */
int button;           /* mouse button status */
int inkey=1;          /* for keyboard scan */
int mousestatus;      /* to see if mouse exists */

/* arrow shaped cursor */

int cursor[32] = {

		   0x9fff,0x8fff,0x87ff,0x83ff,0x81ff,0x80ff,0x807f,0x803f,
		   0x801f,0x800f,0x80ff,0x887f,0xbc7f,0xfc3f,0xfe1f,0xfe0f,
		   0x0000,0x2000,0x3000,0x3800,0x3c00,0x3e00,0x3f00,0x3f80,
		   0x3fc0,0x3e00,0x3600,0x2300,0x0100,0x0180,0x00c0,0x0000

		   };      /* screen, cursor mask for mouse cursor */

int *cursloc = cursor;     /* pointer to first byte of cursor data */

/* function prototypes */

int mouse_exists(int mousestatus);
void mouseshow(void);
void mousehide(void);
int mousebutton( int xloc, int yloc, int button );
void mouse( int *cursloc, int hotrow, int hotcol );

main()
{
   /* see if there is a mouse first */
   mousestatus = mouse_exists( mousestatus );
   if ( mousestatus != -1 ) abort();

   /* initialize graphics mode */
   initgraph(&driver, &mode, "..\\bgi");

   /* set fill color to light red */
   setfillstyle( SOLID_FILL, EGA_LIGHTRED);

   /* fill screen */
   bar(0, 0, 639, 479);

   /* set color to white */
   setcolor( EGA_WHITE );

   /* draw a border */
   rectangle( 0, 0, 639, 479 );
   gotoxy (32,2);
   printf("HIT <ESC> TO EXIT");

   /* setup mouse cursor */

   mouse( cursloc, hotrow, hotcol );

   /* main loop - check mouse status */

   while (inkey != 27)
   {
	if ( kbhit()) inkey = getch();
	mousebutton ( xloc, yloc, button );
	if ( inkey == 49 ){         /* "1" key  */
	      mousehide();
	      inkey = 0;
	      }
	if ( inkey == 50 ){         /* "2" key  */
	      mouseshow();
	      inkey = 0;
	      }
   }

   /* clean up */
   closegraph();
   return 0;
}


mousebutton( int xloc, int yloc, int button )

{

	gotoxy( 3, 14 );

	asm{
		mov ax,3       /* read cursor location and button status */
		mov bx,0
		int 33H        /* interrupt to mousedriver */
		mov button,bx  /* retireve x,y and button status */
		mov xloc,cx
		mov yloc,dx
	}

	yloc = 480 - yloc;
	printf ( " X: %3d  Y: %3d  BUTTON: %d  ", xloc, yloc, button);
	return ( xloc, yloc, button );
}

void mousehide(void)

{
	asm{
		mov ax,2         /* turn off cursor */
		int 33H
	}
}

void mouseshow(void)

{
	asm{
		mov ax,1         /* turn on cursor */
		int 33H
	}
}

void mouse( int *cursloc, int hotrow, int hotcol )

{
	asm{
		mov ax,9              /* service to setup mouse cursor */
		mov bx,hotcol         /* cursor hotspot column */
		mov cx,hotrow         /* cursor hotspot row */
		mov dx,cursloc        /* first byte of cursor data */
		push ds               /* set extra segment to data segment */
		pop es                /* (to get cursor data ) */
		int 33H
		mov ax,7              /* service to set horizontal range */
		mov cx,0              /* minimum horizontal */
		mov dx,640            /* maximum horizontal */
		int 33H
		mov ax,8              /* service to set vertical range */
		mov cx,0              /* minimum vertical */
		mov dx,480            /* maximum vertical */
		int 33H
		mov ax,1              /* turn on cursor */
		int 33H
	}
}

mouse_exists( int mousestatus )

{
	asm{
		mov ax,0
		int 33H
		mov mousestatus,ax
	}
	printf("%d", mousestatus );
	if( mousestatus != -1 ){
	     printf("\n\n NO MOUSE PRESENT!!! ");
	}
	return (mousestatus);
}
