; 1854339PC360:DOSX:CTOH.IPSN.ASM.9.33113. */
          PAGE    60,132
; convert character string to apl hex for printing
; this routine is called using the dosx call function
; the data to be converted is catenated to end of code
; the result is
;   the dosx result code 00 00;
;   registers ax,bx,cx,dx,cs,ds,es,ss,si,di,sp,bp,flags,
;   the data between ds:si and ds:di
; for example an argument of quadav produces a result of
; '00 00;',ax,bx,...sp,flags,     32 bytes rc and registers
; '00010203...feff'               512 bytes apl hex data
; if the argument and result don't fit in the buffer
; the result is the result code and registers
ctoh     proc  far
ctseg  segment byte public ;all segment registers point here
         assume cs:ctseg,ds:ctseg,ss:ctseg,es:ctseg
; linkeditor will complain about no stack segment, let it
axval    dw    string   ;ax is address of string
; si and di point to end+1 of string
bxval    dw    0
cxval    dw    0
dxval    dw    0
entpt:                  ;entry point is always address 8
         push  si       ;save source index
         mov   si,ax    ;start of data string
         mov   cx,di    ;end of string
         sub   cx,ax    ;length of string
         jz    done     ;no string
         mov   ax,cx
         add   ax,ax    ;length of result (twice arg length)
         add   ax,di    ;end of result
         add   ax,200   ;room for stack
         cmp   ax,sp
         jae   done     ;no room, return empty result
         xor   ax,ax
next:
         lodsb          ;get source byte into al
         push  ax       ;save byte
         mov   bx,ax
         shr   bx,1     ;shift top half byte down
         shr   bx,1
         shr   bx,1
         shr   bx,1
         mov   al,table[bx] ; get apl char for first half
         stosb          ;store value in result
         pop   bx       ;get data byte
         and   bx,0fh   ;remove top half byte
         mov   al,table[bx] ; get apl char for second half
         stosb          ;store value in result
         loop  next     ;decrement cx and jump if not zero
done:                   ;conversion complete
;di now points to end of result
         pop   si
;si points at start of result
         ret            ;return to dosx
table    db    8ch,8dh,8eh,8fh,90h,91h,92h,93h ;apl 0-7
         db    94h,95h,56h,57h,58h,59h,5ah,5bh ;apl 8,9,a-f
string:                 ;data starts here
ctseg    ends           ;end segment
ctoh     endp           ;end procedure
         end            ;start address 0  for exe2bin
