/* A Prolog solution to Family Trees by Virginia McCarthy.
            Tom Sullivan
            5415 Grand Ave.
            Western Springs, IL 60558  -  October 30,1985.
*/

northside (larch).
northside (catalpa)    :- northside ('Grandes').
northside ('Grandes')  :- have ('Grandes', larch).
have ('Grandes',larch) :- not_own ('Crewes',larch),
                          not_own ('Dews',larch),
                          not_own ('Lands',larch).

southside ('Crewes').
southside ('Dews').
southside (dogwood) :- northside (larch), northside (catalpa).
southside (ginko)   :- northside (larch), northside (catalpa).

here ('Grandes').
there (catalpa).

/* belongs_to provides a recursive definition of membership in a list
   see Clocksin & Mellish p. 53.  */

belongs_to (X,[X|_]).
belongs_to (X,[Y|Z]) :- belongs_to (X,Z).

same_first_letter (['Dews', dogwood]).
same_first_letter (['Grandes',ginko]).
same_first_letter (['Lands',larch]).
same_first_letter (['Crewes',catalpa]).

human (['Grandes','Crewes','Dews','Lands']).
plant ([catalpa,ginko,dogwood,larch]).

person (X) :- human (Y), belongs_to (X,Y).
tree (X)   :- plant (Y), belongs_to (X,Y).

not_own (X,Y) :- same_first_letter (Z),
                 belongs_to (X,Z), belongs_to (Y,Z).
not_own (X,Y) :- here (X), there (Y).
not_own (X,Y) :- (person (X), person (Y));
                 (tree (X), tree (Y)).
not_own (X,Y) :- (northside (X),southside (Y));
                 (southside (X),northside (Y)).
not_own ('Crewes', X) :- owns ('Dews', X).
not_own ('Lands', X)  :- owns ('Crewes', X).
not_own ('Lands', X)  :- owns ('Dews',X).


owns (X,Y) :- person (X), tree (Y), not (not_own (X,Y)).
hello :- owns(Person,Tree),print (Person,' owns the ',Tree).

/* query with "owns (Person,Tree), write (Person,Tree)."
   or just say "hello."  */


/* The puzzle - "Family Trees" by Virginia McCarthy as found in
   Dell Champion Variety Puzzles, November, 1985

   The Crewes, Dews, Grandes, and Lands of Bower Street each have 
   a front-yard tree -- a catalpa, dogwood, gingko, and larch.  The
   Grandes' tree and the catalpa are on the same side of the street.
   The Crewes live across the street from the larch, which is across
   the street from the Dews' house.  If no tree starts with the same 
   letter as its owner's name, who owns which tree?     
*/
