/*    John M. Linebarger
      25 October 1985

      Thi progra act a  robo tha will whe give  to 
leve predicat o 'place(X,Y).' plac bloc  o to o 
bloc  i th block world Th strateg i a follows:

      1 Tak everythin of o th receivin bloc an 
  plac i o th table.
      
  2 Tak everythin of o th sendin bloc an plac 
 i o th table.

      3 Place sendin bloc ont receivin block.

       majo assumptio here o course i tha ther i 
unlimite room o th table.

       featur o thi progra i th front-en editin o 
th top-level plac predicate.

*/
  
on( [], a ). 
on( a, b ).
on( b, c ).
on( c, d ).
on( d, table ).
on( [], e ).
on( e, f ).
on( f, g ).
on( g, table ).
   
place( table, _ ) :- print( 'Table cannot be moved.' ), nl.
place( A, A ) :- print( 'Cannot place block on top of itself.' ), nl.
place(A,_) :- (not(on(A,_)); not(on(_,A))), print( 'Block ' ),
         print(A), print( ' does not exist.' ), nl.
place(A,B) :- on(A,B), print(A), print( ' is already on ' ), 
              print(B), print( '.' ), nl.
place(A,table) :- on(A,B), clear_top(B).
place(_,B) :- (not(on(B,_)); not(on(_,B))), print( 'Block ' ),
         print(B), print( ' does not exist.' ), nl.
place( A, B ) :- clear_top( B ), clear_top( A ), on( A, C ),
            below( A, C ),
                 retract( on( [], B ) ), asserta( on( A, B ) ),
                 print( 'Put ' ), print( A ), print( ' on ' ), 
           print( B ), print( '.' ), nl.
  
clear_top( X ) :- on( Y, X ), (on( [], X ); (remove( Y, X ), 
            clear_top( X ) ) ).

remove( [], X ) :- on( X, Y ), move( X, Y ).
remove( Y, X )  :- on( Z, Y ), remove( Z, Y ).

below( A, table ) :- retract( on( A, table ) ).
below( A, C )     :- retract( on( A, C ) ), asserta( on ( [], C ) ).

move( X, table ).
move( X, Y ) :- retract( on( X, Y ) ), asserta( on( X, table ) ), 
                    asserta( on( [], Y ) ), print( 'Put ' ), 
              print( X ), print( ' on table.' ), nl.

show :- on (X, Y ), print ( X ), print ( ' is currently on ' ), 
        print ( Y ), print ( '.' ), nl, fail.  
show.

help :- print( 'This program acts like a robot in the blocks world' ),nl, 
        print( 'that will place one block on top of another with a' ),nl,
        write( 'place(X,Y)' ), print( ' predicate. To see the current '),
        nl, print( 'block configuration, type '), print( '\'show\'' ),
        print( '.' ),nl, nl, 
        print('Written by John M. Linebarger as part of a course in'),nl,
        print( 'Artificial Intelligence in the MBA program of New York'), 
        nl, print( 'University. The author\'s address is:'),
        nl, print( '360 Davidson Street, Apt. 6, Bridgeport, CT 06605.'),
        nl, print( 'Home phone is 203/333-5779.' ).
