/* A ProLog program to handle syllogisms of the type
                       All X are Y
                       Z is X
          Therefore -  Z is Y

   Tom Sullivan - 5415 Grand Ave. Western Springs, IL 60558
                     November, 1985
   Type go.<CR> to run the program.  Enjoy.
*/

go :- nl,nl,nl,nl,nl,nl,nl,nl,nl,
      nl,nl,nl,nl,nl,nl,nl,nl,nl,
      print ('                     <<<<<   Theorem Prover   >>>>>'),
      nl,nl,
      print ('         Enter the name of a Greek,animal,plant,fish,insect,or bird.'),
      go1.

go1 :- nl,nl,nl,nl,nl,print ('Name  >> '),
       read (N),
       onlist (N),!.  /* see Clocksin & Mellish pp. 88-90  for use of cut */

listof (men,    ([socrates,plato,aristotle,homer])).
listof (animals,([dog,cat,horse,cow,pig,bear,lion])).
listof (plants, ([rose,petunia,daisy,oak,elm,corn])).
listof (fish,   ([waleye,pike,muski,bass,trout])).
listof (insects,([ant,beetle,spider,fly,mantis])).
listof (birds,  ([wren,robin,heron,eagle,hawk,crow])).

mortals ([men,animals,plants,fish,insects,birds]).

member (X,[X|_]).
member (X,[_|Y]) :- member (X,Y).      /* see C&M p.53  */

onlist (N) :- listof (Y,(Z)), member (N,Z),
              nl,nl,print ('Searching ... ',Y),
              nl,nl,print ('        1. ',N,' is in ',Y,'  ... and '),
              mortal (Y,N);stop.

mortal (Y,N) :- mortals (Z), member (Y,Z),
                nl,nl,print ('Searching .... mortals'),
                nl,nl,print ('        2. ',Y,' are mortal.'),
                nl,nl,print ('        Therefore ',N,' is mortal.'), go1.

stop :- nl,print ('   That\'s not in the data!'),
        nl,nl,print ('                           Type <go.> for more.').
