/* 
Except for the PD version, A.D.A. supports the grammar rule syntax. 
If the syntax is supported, one could ask the question:
sentence( X, [every, man, loves, a, woman], [] ).
and see the result translated into a formula of the predicate calculus.
If you want to compile this under the PD version, add the declaration:
  op( 150, xfy, '-->' ). However, the program won't run under type PD
unless you write a grammar rule expander (definitely feasible). 
*/


?-op( 100, xfx, '$' ).
?-op( 150, xfy, '->' ).

sentence( P ) --> noun_phrase(X,P1,P), verb_phrase(X,P1).

noun_phrase(X, P1, P ) -->
   determiner(X,P2,P1,P), noun( X, P3 ),
   rel_clause( X, P3, P2 ).
noun_phrase( X, P, P ) --> proper_noun( X ).

verb_phrase( X, P ) --> trans_verb(X,Y, P1), noun_phrase(Y, P1, P ).
verb_phrase( X, P ) --> intrans_verb(X, P ).

rel_clause(X,P1,(P1$P2)) --> [that], verb_phrase(X, P2).
rel_clause(_, P, P) --> [].

determiner(X, P1, P2, all(X, (P1->P2))) --> [every].
determiner(X, P1, P2, exists(X,(P1$P2))) --> [a].

noun(X, man(X) ) --> [man].
noun(X, woman(X)) --> [woman].

proper_noun(john) --> [john].

trans_verb(X, Y, loves(X,Y)) --> [loves].

intrans_verb(X, lives(X) ) --> [lives].
