/* This little program is the "consult" predicate rewritten in Prolog. 
More precisely, it is the "conscl" predicate, since it does none of the
fancy stuff that the "consult" allows in types FS and higher. The filename
to be consulted is not automatically given the ".pro" extension like the 
built-in consult, so you must remember that the name of the consulted file
is taken to be exactly what you give.

When end-of-file is reached, "read" fails, so that X in the following
clause is left a variable, Thus "asertfile succeeds only when end of
file is reached. */

cons( Filename ) :-
               	see( Filename ),
                repeat,
		doread( X ),
                assertclause( X ),
                var( X ),
                seen( Filename ),
                see( user ),
		!.	 

    
doread( X ) :- read( X ), !.
doread( _ ).

assertclause(X) :- assertz(X), !.
assertclause(_).


/* The below method may be used with types FS and greater. It opens a file
in the random access mode, rather than using the "see" predicate. */

consf( Filename ) :-
               	open( Filename, r ),
                repeat,
		doreadf( X, Filename ),
                assertclause( X ),
                var( X ),
               	close( Filename ), 
		!.	 


    
doreadf( X, Filename ) :- read( X, Filename ), !.
doreadf( _, _ ).



