/* A deduction problem from Dell Official Puzzles December, 1985.
   ProLog program by Tom Sullivan  -  November, 1985

   Abby, Barb, & Cora have clothes in  blue, green, purple, red & yellow.
   None wears yellow with red.  Each has a two-piece outfit in two colors.
   Abby is wearing blue.  Barb is wearing yellow but not green.  Cora wears
   green but not blue or purple.  One has on red.  One color is worn by both
   Barb and Cora, while Abby & Barb, between them, have on four different
   colors.  Name the colors each woman is wearing.
*/

human ([abby,barb,cora]).
hue ([blue,green,purple,red,yellow]).

member (X,[X|_]).
member (X,[_|Y]) :- member (X,Y).

person (X) :- human (Y), member (X,Y).
color (X) :- hue (Y), member (X,Y).

hason (abby,blue).
hason (barb,yellow).
hason (cora,green).

notwear (barb,green).
notwear (cora,blue).
notwear (cora,purple).
notwear (X,Y) :- not (X = cora),hason (Z,Y).
notwear (abby,X) :- wears (barb,Z),member (X,Z).
notwear (cora,X) :- wears (abby,Z),member (X,Z).

wears (X,([Color1,Color2])) :- person (X), color (Color1), color (Color2),
                               hason (X,Color1),
                               not (notwear (X,Color2)),
                               not (Color1 = Color2),
                               not ((Color1 = red),(Color2 =yellow);
                                (Color1 = yellow), (Color2 = red)).

go :- wears (X,Y),print (X,' wears ',Y).

/* to query type >> go.<CR>  */




