/*                 Augmented Transition Network Program

                                ATNREV.PRO

                                 11/24/85
*/


/*  Standard routines for append & membership checking       */


append([],L,L).
append([Z|L1],L2,[Z|L3]) :- append(L1,L2,L3).

printstring([]).
printstring([H|T]) :- put(H), printstring(T).

member(X,[X|_]).
member(X,[_|Y]) :- member(X,Y).


/*  The start module accepts a set of words, enclosed in brackets and
separated by commas.  It calls wordck to verify that each of the words is
in the vocuabulary set.   */



start :- batch,nl,print('INPUT'),nl,print('-----'),nl,
         nl,print('Input sentence: '),read(S),nl,
         print('The working set is ',S),wordck(S),!,
         nl,nl,print('TRANSFERS'),nl,nl,print('---------'),nl,nl,
         Parse=[],
         trans(q0,Nq,Parse,S,S1).


/*  Wordck checks for the end of the set, [], then if the word is in the
vocabulary.  If not, it asks for the catagory, and adds it to the file
WORD.TEM which is joined with the program after it has run.*/





wordck([])   :-   !,true.

wordck([H|T]) :- word(H,_,_),wordck(T).


wordck([H|T]) :-  nl,print(H,' is not a recognized word '),
                  nl,print(' enter verb,aux, .. '),read(Z),
                  wordnew(H,Z),wordck(T).

wordnew(W,Z) :- assertz(word(W,Z,s)),open('word.tem',ar),
                nlf('word.tem'),
                printf('word.tem', 'word(', W, ',', Z, ').'),
                close('word.tem').




/*  The arcs are defined in terms of from node, to node, condition.
Terminal nodes are identified with the empty list.  Words are defined by
type word name, type, and a character to be used in later examples with the
number (plural or singular).  */


arc(q0,q1,np).
arc(q1,q2,verb).
arc(q2,q2,np).
arc(q2,q3,pp).
arc(q0,q4,aux).
arc(q4,q5,np).
arc(q1,q5,aux).
arc(q5,q2,verb).

term(q2,[]).
term(q3,[]).


word(boy,noun,s).
word(boys,noun,pl).
word(run,verb,pl).
word(runs,verb,s).
word(the,det,s).

arc(qnp,qnp1,det).
arc(qnp,qnp1,_).
arc(qnp1,qnp1,adj).
arc(qnp1,qnp2,noun).
arc(qpp,qnp,prep).


/*  Trans recursively checks the conditions for transistion from the last
node (Lq) to the next node (Nq).  Phrases are specifically treated as pp or
np in order to allow the type of phrase to be identified in the parsed
sentence.  */




trans(Lq,_,Parse,S1,_) :- term(Lq,S1),nl,
                          print('Completed ',Lq),
                          nl,print(Parse).


trans(Lq,Nq,Parse,[S0|S1],S1) :-  word(S0,Type,Nbr),
                                  arc(Lq,Nq,Type),
                                  nl,
                                  print('Transition ',Lq,' ',Nq,' ',S0,
                                            ' ',Type),
                                  append(Parse,[[Type],S0],P1),
                                  !,
                                  trans(Nq,Z,P1,S1,S2).


trans(Lq,Nq,Parse,S0,S1) :-  arc(Lq,Nq,np),
                             ptrans(qnp,Nq,Lq,S0,[np],Parse).


trans(Lq,Nq,Parse,S0,S1) :-  arc(Lq,Nq,pp),
                             ptrans(qpp,Nq,Lq,S0,[pp],Parse).



trans(Lq,Nq,Parse,S0,S1) :- !,nl,
                            print('The sentence failed at ',Lq),
                            nl,print('Parsed ',Parse),
                            nl,print('Left ',S0).

/*  Ptrans checks the transistion of the phrase network.  The first clause
calls itself recursively until node qnp2 has been reached, which concludes
the transistion.  Success results in trans being called  with the new node.
Failure returns the trans with conditions unchanged.  */



ptrans(Bq,Nq,Lq,[S0|S1],Pr,Parse) :-  word(S0,Type,Nbr),
                                arc(Bq,Zq,Type),
                                append(Pr,[[Type],S0],P1),
                                !,
                                ptrans(Zq,Nq,Lq,S1,P1,Parse).

ptrans(qnp2,Nq,Lq,S0,Pr,Parse) :-  nl,
                                   print('Transisiton ',Lq,' ',Nq),
                                   nl,
                                   print(Pr),
                                   append(Parse,Pr,P1),
                                   !,
                                   trans(Nq,Rq,P1,S0,S1).
