/*              FINAL AUGMENTED TRANSISTION NETWORK PROGRAM

                                ATNNEW1.PRO

                                 11/24/85
*/


/*  Start is the entry into the program.  It requires that a set of
standard routines has already been consulted (append in particular).  It
allows the user to specify the network program, which can be build using
ATNBLD.  Words is a file with the vocabulary set.  The sentences is a list
of words separated by commas and enclosed in brackets.  Wordck verifies
that the words are in the vocabulary set, and if not requests required
data. Parse is the sentence as it is parsed.  Trans controls the flow from
node to node.  */


start :- nl,print('ATN network file? '),read(Fn),
         consult(Fn),nl,
         asserta(file(Fn)),
         consult(words),nl,
         batch,nl,print('INPUT'),nl,print('-----'),nl,
         nl,print('Input sentence: '),read(S),nl,
         print('The working set is ',S),wordck(S),
         nl,nl,print('TRANSFERS'),nl,nl,print('---------'),nl,nl,
         Parse=[],
         trans(q0,Nq,Parse,S,S1).



wordck([])   :-   true.

wordck([H|T]) :- H(_,_),wordck(T).


wordck([H|T]) :-  nl,print(H,' is not a recognized word '),
                  nl,print(' enter verb,aux, .. '),read(Z),
                  nl,print(' enter p or s or x  '),read(Z1),
                  wordnew(H,Z,Z1),wordck(T).

wordnew(W,Z,Z1) :- assertfz(words,W(Z,Z1)).


/*  Since the phrase transition network includes more specific procedures
than the primary network, it is included in this program rather than in the
network file consulted by start.  It could be more dynamic, but that was
considered beyond the scope of this project.  */


arc(qnp,qnp1,det).
arc(qnp,qnp1,[]).
arc(qnp1,qnp1,adj).
arc(qnp1,qnp2,noun).
arc(qpp,qnp,prep).


/*  Trans controls the flow along the network.  If a terminal node has been
reached and the entire sentence has been parsed, the agreement in number
(plural or singular) between the subject and predicate is checked.  If they
do not agree, this fact is displayed.  Update words creates a file
WORDS.$$$ which contains the new vocabulary.

If a conditions for termination has not been met, trans checks for a
transition word or a transistion phrase.  If none of these conditions are
met, the sentence will not parse.

When a verb is encountered the number (singular or plural) is 'filed'.
This procedure is unique for a specific network in which only one verb can
be encountered.  */


trans(Lq,_,Parse,S1,_) :- term(Lq,S1),nl,
                          print('Completed ',Lq),
                          nl,print(Parse),
                       (  ( subj(Nbr),pred(Nbr) );
                      (nl,print('The subject and predicate do not agree.')
                          ) ),
                          update(words),
                          exec('erase words.pro'),
                          exec('ren words.$$$ words.pro'),
                          forget(words),
                          file(Fn),
                          forget(Fn),
                          endclr.


endclr :-  (not(file(_));ret(file)),(not(subj(_));ret(subj)),
           (not(pred(_));ret(pred)).


trans(Lq,Nq,Parse,[S0|S1],S1) :-  S0(Type,Nbr),
                                  arc(Lq,Nq,Type),
                                 ((Type=verb,asserta(pred(Nbr)));
                                     not(type=verb)),
                                  nl,
                                  print('Transition ',Lq,' ',Nq,' ',S0,
                                            ' ',Type),
                                  append(Parse,[[Type],S0],P1),
                                  trans(Nq,Z,P1,S1,S2).


trans(Lq,Nq,Parse,S0,S1) :-  arc(Lq,Nq,np),
                             ptrans(qnp,Nq,Lq,S0,[' '+np],Parse).


trans(Lq,Nq,Parse,S0,S1) :-  arc(Lq,Nq,pp),
                             ptrans(qpp,Nq,Lq,S0,[' '+pp],Parse).



trans(Lq,Nq,Parse,S0,S1) :- nl,
                            print('The sentence failed at ',Lq),
                            nl,print('Parsed ',Parse),
                            nl,print('Left ',S0),
                            endclr.



/*  Ptrans checks the transition of the phrase network.  It calls itself
recursively until node qnp2 is reached.  Provisions are included to
establish the number (plural or singular) of the subject, which is designed
for a specific network in which the noun phrase in which the subject is
located will be encountered before any other noun phrase.

The upon reaching qnp2 a check is made for the word 'and'.  If encountered,
the number of the subject is changed to plural and a check for another noun
phrase is initiated.

The spacing of the parathesis is to faciltiate reading of the code.  */


ptrans(Bq,Nq,Lq,[S0|S1],Pr,Parse) :-  S0(Type,Nbr),
                                arc(Bq,Zq,Type),
                          (
                             (
                                 not(Type=noun);

                                 subj(_)
                                          );
                                 asserta(subj(Nbr))
                                                  ),
                                append(Pr,[[Type],S0],P1),
                                ptrans(Zq,Nq,Lq,S1,P1,Parse).

ptrans(Bq,Nq,Lq,S,Pr,Parse)   :-  arc(Bq,Zq,[]),
                                  ptrans(Zq,Nq,Lq,S,Pr,Parse).


ptrans(qnp2,Nq,Lq,[S0|S1],Pr,Parse) :-  S0=and,(Lq=q4;Lq=q0),
                                       ( ( subj(_),retract(subj(_)) );
                                         not(subj(_)) ),
                                         asserta(subj(p)),
                                          append(Pr,[and],P1),
                                          ptrans(qnp,Nq,Lq,S1,P1,Parse).


ptrans(qnp2,Nq,Lq,[S0|S1],Pr,Parse) :-  S0=and,
                                          append(Pr,[and],P1),
                                          ptrans(qnp,Nq,Lq,S1,P1,Parse).




ptrans(qnp2,Nq,Lq,S0,Pr,Parse) :-  nl,
                                   print('Transisiton ',Lq,' ',Nq),
                                   nl,
                                   print(Pr),
                                   append(Parse,Pr,P1),
                                   trans(Nq,Rq,P1,S0,S1).
