/*                 Augmented Transition Network Program

                                  ATN.PRO

                                 10/22/85
*/


/*  Standard routines for append & membership checking       */


append([],L,L).
append([Z|L1],L2,[Z|L3]) :- append(L1,L2,L3).

printstring([]).
printstring([H|T]) :- put(H), printstring(T).

member(X,[X|_]).
member(X,[_|Y]) :- member(X,Y).


/*  The start module accepts a set of words, enclosed in brackets and
separated by commas.  It calls wordck to verify that each of the words is
in the vocuabulary set.   */



start :- batch,nl,print('INPUT'),nl,print('-----'),nl,
         nl,print('Input sentence: '),read(S),nl,
         print('The working set is ',S),wordck(S),!,
         nl,nl,print('TRANSFERS'),nl,nl,print('---------'),nl,nl,q(0,S).



/*  Wordck checks for the end of the set, [], then if the word is in the
vocabulary.  If not, it asks for the catagory, and adds it to the file
WORD.TEM which is joined with the program after it has run.*/





wordck([])   :-   !,true.

wordck([H|T]) :- word(H,Y),wordck(T).


wordck([H|T]) :-  nl,print(H,' is not a recognized word '),
                  nl,print(' enter verb,aux, .. '),read(Z),
                  wordnew(H,Z),wordck(T).

wordnew(W,Z) :- assertz(word(W,Z)),open('word.tem',ar),
                nlf('word.tem'),
                printf('word.tem', 'word(', W, ',', Z, ').'),
                close('word.tem').




/*  Trans checks the catagory of the current word (H) versus the catagory
required to make a transistion (Z).  */




trans(H,Z)   :-  word(H,X), member(X,[Z]).


qfail(Nq,S,E)  :-  !, nl,nl,print('The sentence failed at ',Nq),nl,
                 print('The sentence form to this node is ',E),nl,
                 print('The rest of the sentence is ',S),qend1.


qend(Z,E)  :-  nl,nl,print('OUTPUT'),nl,print('------'),nl,nl,
               print('The sentence is:'),nl,nl,print(E),nl,nl,
               print('The sentence is completed at node ',Z),qend1.


qend1 :- open('word.tem',ar),nlf('word.tem'),
         close('word.tem'),exec('ren atn.pro atn.sav'),
         exec('copy atn.sav+word.tem atn.pro'),
         exec('erase atn.sav'),exec('erase word.tem').


/*    Print transfer from node to node */



qout(A,B,C,D,E,F) :- append(E,[C,'(',A,')'],F),
                     nl, print('Transfer from node ',B,' to node ',D,
                     ' by word ',A,' evaluated as a ',C).




/*   Main program to check the conditions for transfer from node to node.
     The first number is the number of the node, i.e. q(0.. is node 0.
     The module either checks for a word type and transfers control
     directly, or passes to np / pp the next node.                    */


/*  Node 0 - aux to 4 / np to 1 / or fail          */


q(0,[H|T])  :-  trans(H,[aux]),!,qout(H,0,[aux],4,E,F), q(4,T,F).

q(0,[H|T])  :-  np(H,T,1,[],0,[np]).

q(0,S)      :-  qfail(0,S,[]).




/*  Node 1 - verb to 2 / aux to 5 / or fail    */



q(1,[H|T],E)  :-  trans(H,[verb]),!,qout(H,1,[verb],2,E,F), q(2,T,F).

q(1,[H|T],E)  :-  trans(H,[aux]),!, qout(H,1,[aux],5,E,F), q(5,T,F).

q(1,S,E)      :-  qfail(1,S,E).




/*  Node 2 -  null to end / np to 2 / pp to 3 / or fail     */



q(2,H,E)      :- member(H,[[]]), !,
                   qend(2,E).

q(2,[H|T],E)  :-  np(H,T,2,E,2,[np]).


q(2,[H|T],E)  :-  pp(H,T,3,E,2,[pp]).

q(2,S,E)      :-  qfail(2,S,E).




/*  Node 3 - null to end / or fail         */


q(3,H,E)  :-
               trans(H,[]), !,
               qend(3,E).

q(3,S,E)      :-  qfail(3,S,E).





/*  Node 4 - np to 5 / or fail           */




q(4,[H|T],E)  :-  np(H,T,5,E,4,[np]).

q(4,S,E)      :-  qfail(4,S,E).



/*  Node 5 - verb to 2 / or fail         */


q(5,[H|T],E)  :-  trans(H,[verb]),!, qout(H,5,[verb],2,E,F), q(2,T,F).

q(5,S,E)      :-  qfail(5,S,E).




/*  Noun phrase -  (det) (adj) (adj) .. noun        */

/*  The np1 clause is required to allow recursive calls for adj   */



np(H,[S|T],Nq,E,Lq,G)  :-  trans(H,[det]), !,
                           append(G,['det(',H,')'],G1),
                           np1([S|T],Nq,E,Lq,G1).


np(H,Z,Nq,E,Lq,G)      :-  np1([H|Z],Nq,E,Lq,G).



np1([H|T],Nq,E,Lq,G)  :-  trans(H,[adj]),
                          append(G,['adj(',H,')'],G1),
                          np1(T,Nq,E,Lq,G1).


np1([H|T],Nq,E,Lq,G)  :-
                          trans(H,[noun]),!,nl,
                          append(G,['noun(',H,')'],G1),
                          append(E,G1,F),
                          print('Transfer from node ',Lq,' to ',Nq),
                          print(' by ',G1),q(Nq,T,F).




/*  Prep phrase requires a prep followed by a np   */




pp(H,[S|T],Nq,E,Lq,G)  :-  trans(H,[prep]),
                           append(['prep(',H,')'],G,G1),
                           np(S,T,Nq,E,Lq,G1).





/*   Word defines the vocabulary set                  */


word(the,[det]).
word(boy,[noun]).
word(runs,[verb]).
word(happy,[adj]).
word(john,[noun]).
word(can,[aux]).
word(run,[verb]).
word(a,[det]).
word(big,[adj]).
word(small,[adj]).
word(girl,[noun]).
word(dog,[noun]).
word(on,[prep]).
word(pretty,[adj]).
word(fast,[adj]).
word(barks,[verb]).
word(to,[prep]).
word([],[]).

word(giant, [noun]).
word(is, [verb]).

word(giant, [noun]).
word(is, [verb]).
word(sleeps, [verb]).

word(mary, [noun]).
word(likes, [verb]).




word(fly, [verb]).


word(rides, [verb]).
word(large, [adj]).
word(bike, [noun]).
word(store, [noun]).



word(gull, [noun]).
word(green, [adj]).

word(plane, [noun]).
word(silver, [adj]).