unit inform;
(* Name: inform
 * Description: Information unit
 * Notes:
 * Revision History:
 *		22/05/1996 - Placed under GNU General Public License
 *)

(*   LEAP - An extensible relational algebra processor/RDBMS (v0.10.1)
 *   Copyright (C) 1996 Richard Leyton
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *)
interface

procedure warranty_conditions;
procedure leap_start;
procedure leap_options;
function what_version:string;
procedure title;


implementation

uses utils,crt,dtypes;


function what_version:string;
begin
     what_version:=REVISION_TEXT+REVISION_NUMBER;
end;

procedure title;
(* Display the standard banner to standard output *)

(* Ref. Section x.1.2 *)

begin
     if colour then
        textcolor(yellow);
     writeln_stdout('LEAP - An Extensible Relational Algebra Processor. '+what_version);
     write_stdout('Copyright (c)');
     if colour then
     begin
        textcolor(green);
     end;
     write_stdout(' Richard Leyton');
     if colour then
        textcolor(yellow);
     writeln_stdout(' 1996. Ver.Date '+REVISION_DATE);
     if colour then
        textcolor(lightgray);
end;

procedure gnu_warranty;
begin
     writeln_stdout('LEAP comes with ABSOLUTELY NO WARRANTY; for details type "info".');
     writeln_stdout('This is free software, and you are welcome to redistribute it');
     writeln_stdout('under certain conditions; type "info" for details.');
end;

procedure warranty_conditions;
(* Display the warranty & condition information *)

(* No ref *)

var
   ch:char;

begin
     writeln_stdout('                           NO WARRANTY');
     writeln_stdout_nl;
     writeln_stdout('  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY');
     writeln_stdout('FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN');
     writeln_stdout('OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES');
     writeln_stdout('PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED');
     writeln_stdout('OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF');
     writeln_stdout('MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS');
     writeln_stdout('TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE');
     writeln_stdout('PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,');
     writeln_stdout('REPAIR OR CORRECTION.');
     writeln_stdout_nl;
     writeln_stdout('  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING');
     writeln_stdout('WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR');
     writeln_stdout('REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,');
     writeln_stdout('INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING');
     writeln_stdout('OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED');
     writeln_stdout('TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY');
     writeln_stdout('YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER');
     writeln_stdout('PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE');
     writeln_stdout('POSSIBILITY OF SUCH DAMAGES.');
     writeln_stdout_nl;
     writeln_stdout('You should have received a copy of the GNU General Public License');
     writeln_stdout('along with this program; if not, write to the Free Software');
     writeln_stdout('Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.');
     writeln_stdout_nl;
     writeln_stdout('Press any key to continue.');
     ch:=readkey;
     writeln_stdout_nl;
end;


procedure leap_start;
begin
     writeln_stdout('888               8888888888                 d8888          8888888b.');
     writeln_stdout('888               888                       d88888          888   Y88b');
     writeln_stdout('888               888                      d88P888          888    888');
     writeln_stdout('888               8888888                 d88P 888          888   d88P');
     writeln_stdout('888               888                    d88P  888          8888888P"');
     writeln_stdout('888               888                   d88P   888          888');
     writeln_stdout('888               888                  d8888888888          888');
     writeln_stdout('88888888          8888888888          d88P     888          888');
     writeln_stdout_nl;
     gnu_warranty;

end;


procedure leap_options;
var
   ch:char;
begin
     writeln_stdout_nl;
     writeln_stdout('LEAP [ [option1=value1] [option2=value2] ... [optionN=valueN] ]');
     writeln_stdout_nl;
     writeln_stdout('Options:');
     writeln_Stdout_nl;
     writeln_stdout('OPTION default  Description');
     writeln_stdout_nl;
     writeln_stdout('DIR    c:\leap  Specifies the directory in which the LEAP files are stored.');
     writeln_stdout('DEBUG     N     Specifies whether additional debug information should be');
     writeln_stdout('                written to the report file.');
     writeln_stdout('TIMING    N     Specifies whether operation timing information should be');
     writeln_stdout('                produced.');
     writeln_stdout('USTIME    N     Specifies whether time information should be displayed in');
     writeln_stdout('                US format (mm/dd/yyyy) or European (dd/mm/yyyy).');
     writeln_stdout('COPY      Y     Screen output should be duplicated in the temporary directory.');
     writeln_stdout('COLOUR    Y     Disable or enable colour output (COLOR can also be used)');
     writeln_stdout('INFO     n/a    Displays warranty and conditions of use.');
     writeln_stdout('CACHE     N     Enable LEAP''s internal cache.');
     writeln_stdout('IOON      N     Display extra info!');
     writeln_stdout('TRACE     N     Display program trace information (very noisy!)');
     writeln_stdout('ITERATIVE Y     Use the iterative (faster) or recursive (slower) parser');
     writeln_stdout('PARSE     N     If using the iterative parser, display the parse tree generated');
     writeln_stdout('INFIX     Y     Process infix expressions, as opposed to prefix. N=recursive psr');
     writeln_stdout('?        n/a    Displays this page.');
     writeln_stdout_nl;
     write_stdout('Press any key to continue');
     ch:=readkey;
     writeln_stdout_nl;
end;


end.
