unit dTypes;

(*
Unit: dTypes
Description: Defines all of the necessary data types for
             relations, fields and their records
Initial Date:4/10/1994
Revision History:
	Development 4/10/1994 - 31/10/1994
	Tidying Touches - 1/11/1994
	Dissertation Rewrite Started - 14/11/1994
	Infix operators now the default - 22/01/1996
	Placed under GNU General Public License - 22/06/1996
*)
(*   LEAP - An extensible relational algebra processor/RDBMS (v0.10.1)
 *   Copyright (C) 1996 Richard Leyton
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *)
interface

{$O+}

const
     (* Revision information *)
     REVISION_TEXT='Beta Version #0.';
     REVISION_NUMBER='10.1';
     REVISION_DATE='22nd May 1996';

     MASTER_DB_NAME='MASTER';   (* Name of the master database *)

     STARTUP_DB:string='USER';  (* Name of the default startup database *)

    (************************************)
    (* System data dictionary relations *)
    (************************************)

     LEAP_DATABASES='LEAPDATA';       (* Name of the main "sysdatabases"
                                   relation *)
     LEAP_STARTUP='LS';         (* Name of the relation with the
                                   startup options *)

     NOSYSTABLES=1;

     LEAP_SYSTABLES:array[1..NOSYSTABLES] of string=(
                                           LEAP_DATABASES
                                          );

    (**********************************)
    (* File name definitions          *)
    (**********************************)
     DIR_MASK:string='C:\LEAP';
     REL_NAME_SIZE=8;           (* Size of a relation's name *)

     FILENAME_SIZE=9;           (* Size of a filename (excl ext.) *)
                                (* Including \ *)
     FILENAME_EXT_SIZE=4;       (* Size of a filename extension *)
     FILENAME_EXT_SEPERATOR='.';(* filename extension seperator *)
     FILE_PATH_SIZE=127;        (* This is a DOS limit I think? *)

     ERROR_DIR='\ERRORS';
     ERROR_FILENAME='\ERRORS.TXT';

     REPORT_DIR='\REPORTS';
     REPORT_FILENAME='\REPORT.TXT';

     DATA_DIR='\RELATION';
     SCRIPT_DIR='\SOURCE';

     RELATION_DIR='\RELATION';
     RELATION_EXT='.REL';
     RELATION_TEMPORARY_IND='.TMP';
     RELATION_TEMPORARY_TXT='Temporary Indicator file. Do not Delete!';

     RELATION_MASK='\*'+RELATION_EXT;

     DATABASE_DIR='\DATABASE';
     DATABASE_MASTER_DIR='\MASTER';

     DB_DESCRIPTOR_FILE='\INFO.MSG';


     FIELD_EXT='.FLD';
     FIELD_TMP='.FTM';  (* Temporary field file for rename operation *)

     FIELD_MASK='\*'+FIELD_EXT;

     (* Hash file extension *)
     HASH_EXT='.HSH';

     HELP_DIR='\HELP';
     HELP_PAGE_FILE='\HELPPG.TXT';

     SOURCE_FILE_EXT='.SRC';
     SOURCE_FILE_MASK='\*'+SOURCE_FILE_EXT;
     SCRIPT_SHUTDOWN='\SHUTDOWN';
     SCRIPT_STARTUP='\STARTUP';

     SCRIPT_OPEN='OPEN';
     SCRIPT_CLOSE='CLOSE';

     stdoutcpy_file='\LEAP.TXT';

    (**********************************)
    (* File delimeter definition      *)
    (**********************************)

    DATA_DELIMITER='\';
    NULL_INDICATOR='-';

    (**********************************)
    (* Error message definitions      *)
    (**********************************)

     ERROR_FILE_NOT_FOUND=1;
     ERROR_FILE_OPENING=2;
     ERROR_UNKNOWN=3;
     ERROR_INSUFFICENT_MEM=4;
     ERROR_CANTFIND_FLD=5;
     ERROR_EOF=6;
     ERROR_DISPOSE_UNALLOCMEM=7;
     ERROR_DUPLICATE_ITEM=8;
     ERROR_UNION_COMPATIBILITY=9;
     ERROR_ERASE_FILE=10;
     ERROR_CANNOT_PROCESS=11;
     ERROR_DISPLAY_NONEX_REL=12;
     ERROR_ATTEMPT_RELOAD=13;
     ERROR_CANNOT_FIND_REL=14;
     ERROR_DELETE_NONEX_REL=15;
     ERROR_EXCEEDED_FIELD_LIMIT=16;
     ERROR_MISMATCHING_BRACKETS=17;
     ERROR_UNKNOWN_HELPPAGE=18;
     ERROR_NO_RELATION_CREATED=19;
     ERROR_INCORRECT_OPTION=20;
     ERROR_INTERNAL_STACK=21;
     ERROR_RECURSION_DEPTH=22;
     ERROR_UNEXPECTED_TERMINATION=23;
     ERROR_EVALUATING_EXPR=24;
     ERROR_EXPECTED_FILE_NOT_FOUND=25;
     ERROR_WILDCARD_IN_NAME=26;
     ERROR_NONAME=27;
     ERROR_INSUFFICENT_ATTRIBUTES=28;
     ERROR_UNKNOWN_DATABASE=29;
     ERROR_ALREADY_OPEN=30;
     ERROR_PANIC=31;
     ERROR_MASTER_ONLY=32;
     ERROR_CANNOT_CREATE_DB=33;
     ERROR_TYPE_INCOMPATIBLE=34;
     ERROR_TYPE_CONVERSION=35;
     ERROR_NO_TYPE=36;
     ERROR_CANNOT_CHDIR=37;
     ERROR_UNIMPLEMENTED=38;
     ERROR_UNDEFINED=999;

     REF_ERROR_CHECK_DIR=2;  {Check the DIR parameter for the cause of the
                              error. This should trigger a user help message
                              if errorno is <= }

     SEARCH_UNSUCCESSFUL=1;

     STRING_TXT='STRING';
     INTEGER_TXT='INTEGER';
     REAL_TXT='REAL';

     DOS_COMMAND_INTERPRETER='C:\COMMAND.COM';

     seperators=[',',' ','/','\',':','(',')'];

     MAX_NO_CONDITIONS=10;
     MAX_SIZE_DATUM_STRING=25;
     MAX_NO_ATTRIBUTES=55;
     MAX_DATA_SIZE=255;
     MAXKEYS=2;
     MAX_NO_BRACKETS=30;
     MAX_FILE_DATA_SIZE=MAX_DATA_SIZE*MAX_NO_ATTRIBUTES;
     MAX_RECURSION_DEPTH=07;

                        (* Index constants *)

     nodemax=4;         (* Maximum number of keys in a node; max = m-1 *)
     nodemin=2;         (* Minimum number of keys in a node; min = [1/2m]-1*)

     no_operators=6;

     quote=#39;         (* ' for constants in expressions *)
     dbl_quote='"';
     newline=#13+#10;


     PANIC_THRESHOLD=45000; (* Threshold at which to dispose of master
                               database scrap tables *)

     (**********************************)
     (* Cache table definitions        *)
     (**********************************)

     CACHE_SIZE=20;     (* No tuples to store in the cache *)

     (**********************************)
     (* Hash table definitions         *)
     (**********************************)

     TABLESIZE=53;    (* Should be a prime number *)
     TABLETOP=TABLESIZE-1;
     REQ_CALC=TABLESIZE+1; (* Value to require that hash key
                              is calculated and is not provided *)


     CMP_EQUAL=0;
     CMP_LESS=1;
     CMP_GREATER=2;
     CMP_UNKNOWN=255;

     FILE_COMMENT='#';
     FILE_PRINT='>';

type
    data_types=(string_t,int, undef);

    (**********************************)
    (* Hash table definitions         *)
    (**********************************)
    hash_keytype=string;        (* The type of hash key *)

    chain=^chain_def;

    chain_def=record            (* The definition of the chain nodes *)
                    elt:hash_keytype;
                    next:chain;
    end;

    bucket=record               (* The type of the nodes in the hash table *)
                 hd:chain;
    end;

                                 (* A hash table *)
    TableType=array[0..TABLETOP] of Bucket;

    HashTable=^TableType;


    (**********************************)
    (* Cache definitions              *)
    (**********************************)
     cache=^cache_t;
     cache_t=record
                   pos:byte;
                   cache:array[1..cache_size] of record
                                              p_rec_no:word;
                                              tuple:string;
                                              eof:boolean;
                   end;
     end;


    (**********************************)
    (* Field definitions              *)
    (**********************************)
    field=^field_def;
    field_def=record
                    name:string[25];    (* Field name *)
                    primary:boolean;    (* TRUE for primary Key *)
                    noRecs:word;        (* No. records held in field *)
                    data_type:data_types; (* String/Integer data *)
                    field_size:word;
                    next,previous:field; (* Next and Previous nodes *)
    end;

    field_q_node=^field_q_node_def;
    field_q_node_def=record             (* Queue data types for field queue*)
                          fld:field;    (* The field in the queue*)
                          next:field_q_node;
    end;

    field_queue=^field_queue_def;
    field_queue_def=record
                          name:string[25];
                          noNodes:word;
                          head,tail:field_q_node;
    end;

    (**********************************)
    (* Relation definitions           *)
    (**********************************)

    relation=^relation_def;

    relation_struct_store=record
                                next,previous:relation;
    end;

    relation_def=record
                       name:string[REL_NAME_SIZE]; (* Name of the relation *)
                       filepath:string[FILE_PATH_SIZE];
                       filename:string[FILENAME_SIZE+FILENAME_EXT_SIZE];
                       fieldname:string[FILENAME_SIZE+FILENAME_EXT_SIZE];

                       (* Removed to reduce the number of necessary
                          file handles in B0.10 *)
                       fileptr:text;
                       fieldptr:text;

                       storage:relation_struct_store;
                       nofields:word;
                       current_pos:word;

                       rcache:cache; (* Relations cache *)
                       temporary:boolean;

                       hash_table:HashTable;
    end;

    (**********************************)
    (* Database definitions           *)
    (**********************************)

    database=^database_def;
    database_def=record
                       firstRelation:relation; (* First relation in db *)
                       lastRelation:relation;  (* ! *)
                       name:string[25];        (* The name of the db *)
                                               (* Location of base dir. *)
                       base_dir:string[FILE_PATH_SIZE];
    end;

    loc_type=word;      (* Type used for the indexing of relations
                           on disk *)

    (**********************************)
    (* Index definitions              *)
    (**********************************)

    index_struct_ptr=^index_struct_def;

    index_struct_hdr_ptr=^index_struct_hdr_def;
    index_struct_hdr_Def=record
                           head:index_Struct_ptr;
                           no_nodes:word;
    end;

    (**********************************)
    (* Tuple definitions              *)
    (**********************************)


    tupleArray=array[1..MAXKEYS] of string; (* Stores the data forming
                                               the index *)
    keytype=record
{                  diskfile:file;}
                  diskAddr:loc_type;
                  primary,secondary:tupleArray;
    end;
    nodeptr=^nodedef;
    position=0..nodemax;
    nodedef=record
               count:0..nodemax;
               key:array[1..nodemax] of keytype;
               branch:array[position] of nodeptr;
{               parent:nodeptr; {So we can perform an ordered transversal}
    end;

    (**********************************)
    (* More Index definitions         *)
    (**********************************)


    keyarray=array[1..MAXKEYS] of string[25];

    index_ref=record
                    relation:string[REL_NAME_SIZE];
                                                   (* Relation Name *)
                    primary:keyarray;
                                                   (* Primary Keys *)
                    secondary:keyarray;
                                                   (* Secondary Keys *)
                    index_struct:nodeptr;
                                                   (* Index Structure *)
    end;

    index_struct_def=record
                           next,previous:index_struct_ptr;
                           index_data:index_ref;
                           fileptr:file;
    end;

    (* Stack for transversal of the btrees used in indexes *)
    np_stack_node=^np_stack_node_def;
    np_stack_node_def=record
                            data:nodeptr;
                            pos:word; {Location in node}
                            next:np_stack_node;
    end;

    np_stack=^np_stack_def;
    np_stack_def=record
                       head_node:np_stack_node;
                       no_items:word;
    end;


    (**********************************)
    (* Parser definitions             *)
    (**********************************)


    operators=(LESS,LESS_THAN_OR_EQUAL,EQUAL,GREATER_THAN_OR_EQUAL,GREATER,NOT_EQUAL);
    opstruct=record
                   s:string;
                   op:operators;
    end;

    condition_struct=array[1..MAX_NO_CONDITIONS] of record
                                     str:string;
                                     bool:byte;
                                     output:boolean;
   end;

    (* Define all possible command types *)
    command_type=(UNKNOWN,LEXIT,HELP,LOAD,DISPLAY_REL,PRINT,DISPLAY,LDELETE,
                  DISPLAY_INDEX,PROJECT,LDISPOSE,SRCFILE,DOSCOMMAND,
                  UNION,JOIN,MEMAVAILABLE,CHANGESTATUS,SPECINDEX,
                  IDXPRINT,IDXSTORE,INTERSECT,DIFFERENCE,PRODUCT,
                  SELECT,DESCRIBE,NORMAL,LHIGH,SM_JOIN,FLUSH,CREATE,ADD,
                  LISTSRCS,CLEAR,RMVTMP,PROMPT,WAR_CON_INFO,STATUS,CDEBUG,
                  CINFIX,VERSION,LIST,COMMENT,REPORTS,TIME,TIMEFORMAT,
                  LCOPY,WHAT,USE, DIR, IOON_S, LRENAME, DOPANIC, BREAK,
                  CASESENSE,DUPLICATE,LCACHE,LRELATION, LITERATE, DPTREE);
    (* LRELATION is used by the parser to mark a node as being a relation *)

    command_check=(commd,standalone,assignmt);
    comstr=record
                 text:string[25];
                 command:command_type;
    end;

    parse_tree=^parse_tree_def;
    parse_tree_def=record
                         expression:string;
                         left,right,parent:parse_tree;
                         ldone,rdone:boolean;
                         lresult,rresult:relation;
                         result:relation;
                         hand:byte;
                         s1,s2,s3,s4,s5,target:string;
                         operation:command_type;
    end;



const
     ops_x_ref:array[1..no_operators] of opstruct=(
                                      (s:'<';op:LESS),
                                      (s:'<=';op:LESS_THAN_OR_EQUAL),
                                      (s:'=';op:EQUAL),
                                      (s:'>=';op:GREATER_THAN_OR_EQUAL),
                                      (s:'>';op:GREATER),
                                      (s:'<>';op:NOT_EQUAL)
                                      );

const
     (* Define number of commands possible *)
     NOCMDS=64;

     (* Cross-reference of commands/internal type *)
     commands:array[1..NOCMDS] of comstr=(
                          (text:'EXIT';command:LEXIT),
                          (text:'QUIT';command:LEXIT),
                          (text:'STOP';command:LEXIT),
                          (text:'?';command:HELP),
                          (text:'HELP';command:HELP),
                          (text:'LOAD';command:LOAD),
                          (text:'LIST';command:DISPLAY_REL),
                          (text:'SP_HELP';command:DISPLAY_REL),
                          (text:'PRINT';command:PRINT),
                          (text:'DISPLAY';command:DISPLAY),
                          (text:'DELETE';command:LDELETE),
                          (text:'ERASE';command:LDELETE),
                          (text:'INDEXES';command:DISPLAY_INDEX),
                          (text:'PROJECT';command:PROJECT),
                          (text:'DISPOSE';command:LDISPOSE),
                          (text:'@';command:SRCFILE),
                          (text:'SOURCES';command:LISTSRCS),
                          (text:'!';command:DOSCOMMAND),
                          (text:'UNION';command:UNION),
                          (text:'JOIN';command:JOIN),
                          (text:'MEM';command:MEMAVAILABLE),
                          (text:'CHANGE';command:CHANGESTATUS),
                          (text:'SPECIDX';command:SPECINDEX),
                          (text:'IDXPRINT';command:IDXPRINT),
                          (text:'IDXSTORE';command:IDXSTORE),
                          (text:'INTERSECT';command:INTERSECT),
                          (text:'DIFFERENCE';command:DIFFERENCE),
                          (text:'MINUS';command:DIFFERENCE),
                          (text:'PRODUCT';command:PRODUCT),
                          (text:'SELECT';command:SELECT),
                          (text:'RESTRICT';command:SELECT), (* Combined *)
                          (text:'DESCRIBE';command:DESCRIBE),
                          (text:'NORMAL';command:NORMAL),
                          (text:'HIGH';command:LHIGH),
                          (text:'SMJOIN';command:SM_JOIN),
                          (text:'FLUSH';command:FLUSH),
                          (text:'CREATE';command:CREATE),
                          (text:'ADD';command:ADD),
                          (text:'CLEAR';command:CLEAR),
                          (text:'RMVTMP';command:rmvtmp),
                          (text:'PROMPT';command:prompt),
                          (text:'INFO';command:war_con_info),
                          (text:'STATUS';command:status),
                          (text:'DEBUG';command:cdebug),
                          (text:'INFIX';command:cinfix),
                          (text:'VER';command:version),
                          (text:'VERSION';command:version),
                          (text:'L';command:list),
                          (text:'#';command:comment),
                          (text:'REPORT';command:reports),
                          (text:'TIMING';command:time),
                          (text:'USTIME';command:timeformat),
                          (text:'WHAT';command:what),
                          (text:'USE';command:use),
                          (text:'DIR';command:dir),
                          (text:'IOON';command:ioon_s),
                          (text:'RENAME';command:lrename),
                          (text:'PANIC';command:dopanic),
                          (text:'BREAK';command:break),
                          (text:'CASE';command:casesense),
                          (text:'DUPLICATE';command:duplicate),
                          (text:'CACHE';command:lcache),
                          (text:'ITERATIVE';command:literate),
                          (text:'PARSE';command:dptree)
                          );

     ERROR_CLI_OK=0;
     ERROR_CLI_RECURSION=1;

var
   (* Master db is the master database
      Current db is the current database
      Active db is the database against which current op. is on.
             active_db will contain master_db OR current_db,
             not its own database! *)
   master_db,current_db:database;
   dberror:word;        (* Stores the last error code *)
   searchError:word;    (* Search errors *)
   tempdir:string;      (* Defined temporary directory *)
   stdinput,debug:boolean;
   idx_master:index_struct_hdr_ptr;     (* Master Index Structure
                                           Created by default. *)
   cpyfile_created:boolean;
   shutdown{,DESC},TRACE,COLOUR,NAG,CPYFILE,
   IOON,IOON_SETTING,USTIME,
   CASESENSITIVITY,TIMING,INFO,INFIX,CACHEENABLED,ITERATIVE,DISPPARSE:boolean;
   incount,outcount:integer;
   cli_error:word;


implementation

uses dos;

begin
     (* Specify the default values for parameters etc. *)

     shutdown:=false;
     INFO:=false;
     INFIX:=TRUE;
     NAG:=TRUE;
     cpyfile_created:=false;
     CPYFILE:=TRUE;
     stdinput:= TRUE;
     debug:=false;
     tempdir:=getenv('TEMP');
     timing:=FALSE;
     USTIME:=FALSE;
     COLOUR:=TRUE;
     TRACE:=FALSE;
     {DESC:=TRUE;}
     CASESENSITIVITY:=FALSE;
     IOON:=TRUE; (* Make sure output is made! *)
     IOON_SETTING:=FALSE; (* Default startup *)
     CACHEENABLED:=FALSE;
     ITERATIVE:=TRUE;
     DISPPARSE:=FALSE;
{     if paramcount>0 then
        DIR_MASK:=paramstr(1);}

     incount:=0;
     outcount:=0;
end.
