unit dcompare;

(*
Unit: dcompare
Initial Date: 09/02/1996
Description: Provides functionality to allow data types to be
             compared. If successful, will deal with comparison
             of different data types etc.
Notes: Used only by rtional in the evaluation of expressions
Revision History:
         09/02/1996 - Initial Development
	 22/05/1996 - Placed under GNU General Public License.
*)
(*   LEAP - An extensible relational algebra processor/RDBMS (v0.10.1)
 *   Copyright (C) 1996 Richard Leyton
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *)
interface

uses dtypes,tuples,utils;
function compare(    v1,v2:string;
                     t1,t2:data_types;
                     c:char):boolean;

implementation
{
function compare(       t1,t2:tuple_attributes;
                        i1,i2:byte):byte;
var
   type1,type2:data_types;
   int1,int2:integer;
   datum1,datum2:string;
   cerror:integer;
   rval:byte;

begin
     rval:=CMP_UNKNOWN;

     (* Get the information we need now rather than later *)
     type1:=t1^.tdatum[i1]^.fieldptr^.data_type;
     type2:=t2^.tdatum[i2]^.fieldptr^.data_type;
     datum1:=t1^.tdatum[i1]^.data;
     datum2:=t2^.tdatum[i2]^.data;

     if type1=type2 then
     begin
          case type1 of
               str:begin
                        if datum1=datum2 then
                           rval:=CMP_EQUAL
                        else
                        if datum1<datum2 then
                           rval:=CMP_LESS
                        else
                        if datum1>datum2 then
                           rval:=CMP_GREATER
                   end;
               int:begin
                        val(datum1,int1,cerror);
                        if cerror<>0 then
                           nonfatal_error(ERROR_TYPE_CONVERSION,'s2i: '+datum1)
                        else
                        begin
                             val(datum2,int2,cerror);
                             if cerror<>0 then
                                nonfatal_error(ERROR_TYPE_CONVERSION,'s2i: '+datum2)
                             else
                             begin
                                  if int1=int2 then
                                     rval:=CMP_EQUAL
                                  else
                                  if int1<int2 then
                                     rval:=CMP_LESS
                                  else
                                  if int1>int2 then
                                     rval:=CMP_GREATER
                             end
                        end

                   end;
          end;
     end
     else
         nonfatal_error(ERROR_TYPE_INCOMPATIBLE,'');


     compare:=rval;
end;

}


{
function compare_dtype(var t1,t2:tuple_attributes):data_types;
var
   type1,type2:data_types;
begin
     type1:=t1^.tdatum[i1]^.fieldptr^.data_type;
     type2:=t2^.tdatum[i2]^.fieldptr^.data_type;
end;

}
function compare(    v1,v2:string;
                     t1,t2:data_types;
                     c:char):boolean;
var
   r:boolean;
   t:data_types;
   i1,i2:real;
   cerror:integer;
begin
     (* Work out what data type to evaluate this as *)

     if (t1<>undef) or (t2<>undef) then
     begin
          if (t1=undef) and (t2<>undef) then
             t:=t2
          else
          if (t1<>undef) and (t2=undef) then
             t:=t1
          else
          if (t1=t2) then
             t:=t1;
     end
     else
         (* Default as string comparison *)
         t:=string_t;


     r:=false;

     case t of
          string_t: begin
                    case c of
                         '<':r:=(v1<v2);
                         '>':r:=(v1>v2);
                         '=':r:=(v1=v2);
                         'L':r:=(v1<=v2);
                         'G':r:=(v1>=v2);
                         'N':r:=(v1<>v2);
                    end
               end;
          int: begin
                    val(v1,i1,cerror);
                    if cerror<>0 then
                       nonfatal_error(ERROR_TYPE_CONVERSION,'s2i: '+v1)
                    else
                    begin
                         val(v2,i2,cerror);
                         if cerror<>0 then
                            nonfatal_error(ERROR_TYPE_CONVERSION,'s2i: '+v2)
                         else
                         begin
                              case c of
                                   '<':r:=(i1<i2);
                                   '>':r:=(i1>i2);
                                   '=':r:=(i1=i2);
                                   'L':r:=(i1<=i2);
                                   'G':r:=(i1>=i2);
                                   'N':r:=(i1<>i2);
                              end
                         end
                    end
               end;
{          real: begin
                end;}
          undef: nonfatal_error(ERROR_UNDEFINED,'undef dtype case hit');
     end;

     compare:=r;
end;


end.
