unit caching;

(* Unit: Caching
   Created: 12/12/1995
   References:
   Description: This unit will provide tuple cache facilites for use
                by the tuples unit.
   Revision History:
            12/12/1995 - First started.
	    22/05/1996 - Put under GNU General Public License.
*)
(*   LEAP - An extensible relational algebra processor/RDBMS (v0.10.1)
 *   Copyright (C) 1996 Richard Leyton
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *)
interface

uses dtypes;

function cache_create:cache;
function cache_read(    c:cache;
                    var p_rec_no:word):string;
procedure cache_insert(    c:cache;
                           tuple:string;
                           p_rec_no:word;
                           eof:boolean);
function cache_ateof(    c:cache;
                         p_rec_no:word):boolean;
procedure cache_destroy(var pcache:cache);


implementation

uses utils,tuples;

function cache_create:cache;
var
   tcache:cache;
   x:byte;
begin
     new(tcache);
     check_assign(tcache,'caching.cache_create');

     for x:=1 to cache_size do
     begin
         tcache^.cache[x].p_rec_no:=0;
         tcache^.cache[x].tuple:='';
     end;
     tcache^.pos:=1;
     cache_create:=tcache;
end;


procedure cache_destroy(var pcache:cache);
begin
     dispose(pcache);
     pcache:=nil;
end;


procedure add_pos(    c:cache);
begin
     if c^.pos<cache_size then
        inc(c^.pos)
     else
         c^.pos:=1;
end;

procedure cache_insert(    c:cache;
                           tuple:string;
                           p_rec_no:word;
                           eof:boolean);
(* Insert a tuple into the cache structure *)
var
   currentRel,previousRel:relation;

begin
     c^.cache[c^.pos].p_rec_no:=p_rec_no;
     c^.cache[c^.pos].tuple:=tuple;
     c^.cache[c^.pos].eof:=eof;
     add_pos(c);
end;


procedure dec_pos(    c:cache);
begin
     if c^.pos>1 then
        dec(c^.pos)
     else
         c^.pos:=cache_size;
end;

function cache_read(    c:cache;
                    var p_rec_no:word):string;
var
   x:byte;
   done:boolean;
begin
     tuple_count_inc(incount);
     if cacheenabled then
     begin
           x:=1;
     {     eof:=false;}
          while (x<=cache_size) and (p_rec_no<>c^.cache[x].p_rec_no) do inc(x);
          if (p_rec_no=c^.cache[x].p_rec_no) then
          begin
               cache_read:=c^.cache[x].tuple;
     {          eof:=c^.cache[x].eof;}
               inc(p_rec_no);
          end
          else
              cache_read:='';
     end
     else
         cache_read:='';
end;


function cache_ateof(    c:cache;
                         p_rec_no:word):boolean;
begin
     if cacheenabled then
        cache_ateof:=c^.cache[p_rec_no-1].eof
     else
         cache_ateof:=false;
end;

begin

end.