/**
 **
 **	LJ -- A printing utility for the HP LaserJet
 **
 **	Version 2.0
 **	Copyright (C) 1986 Chip Rabinowitz
 **	Released to the public domain for use without profit.
 **
 **	********************************************************
 **	*!!!! Commercial users must register this product. !!!!*
 **	********************************************************
 **
 **	This program prints a series of files on the LaserJet printer.  The
 **	files are printed in a "landscape" font at 17 characters to the inch.
 **	To take advantage of this density, two "pages" of information from
 **	the file are printed on each piece of paper (left and right halves).
 **
 **	Usage is:       LJ  file1 file2 file3 ...
 **
 **	Where file# is a valid MS-DOS filename, included on the command line.
 **
 **	Joe Barnhart	original version for Lattice C		May 5, 1985
 **	Ray Duncan	date and time stamping			May 22, 1985
 **	Joe Barnhart	revised date stamping			June 6, 1985
 **	Ray Duncan	modified for Microsoft C		Oct. 18, 1985
 **	Chip Rabinowitz modified for Aztec C86
 **			Vertical Line separation added
 **			Lines > 80 continued on next line
 **			Now allows 66 text lines per page	Sept. 11, 1986
 **
 **	Planned enhancements:
 **		Wildcard file entry
 **		Command Line Switches
 **
 **	Comments or suggestions??
 **		Chip Rabinowitz
 **		51 East Rogues Path
 **		Huntington Station, NY 11746
 **		1-516-427-5725
 **
 **		Registration entitles user to source code and LJ.COM file 
 **		on diskette, along with printed copy of source code.  A
 **		$15 registration fee is appreciated, and entitles the user
 **		to all future updates.
 **
 **/

#include "stdio.h"
#include "time.h"

#define MAXLINE 66		/* maximum lines per page on LaserJet */
#define PAGE	'\014'		/* form feed */
#define TAB	8		/* width of one tab stop */

FILE *lp;

main(argc, argv)
int argc;
char *argv[];
{
	int filenum;
	FILE *fp, *fopen();

	lp = fopen("prn","w");			/* open the printer file */

	fprintf( lp, "\033E\033&l1O\033(s17H\033&l5.14C\033&l70F\033&l7E" );	/* this is a test */
	/* initialize the LaserJet for landscape printing */

	for(filenum = 1; filenum < argc; filenum++ ){
		fp = fopen( argv[filenum] ,"r+" );
		if( fp == NULL )
			printf( "File %s doesn't exist.\n", argv[filenum] );
		else {
		printf( "Now printing %s\n", argv[filenum] );
		printfile( fp, argv[filenum] );
		fclose( fp );
		}
	}
	fprintf( lp, "\015\033E" );			/* clear LaserJet */
	fclose(lp);

}

printfile(fp,filename)
FILE *fp;
char *filename;
{
	int pagenum = 1;
	int retval = 0;

	while( (feof(fp)==0) && (retval==0) ) {
		fprintf(lp, "\033&a0r85m5L\015"); 	/* set LaserJet to left half */
		stamp(filename, pagenum++);		/* title top of page */
		retval = printpage( fp );		/* print one page */
		if(feof(fp)==0 && retval==0){			/* if more to print... */
			dovert();
			fprintf(lp, "\033&a0r171m91L\015");	/* LaserJet to right half */
			stamp(filename, pagenum++);		/* title top of page */
			retval = printpage( fp );		/* and print another page */
		}
		fputc(PAGE, lp);	 		/* kick out paper */
	}
}

dovert()
{
	int line = 1;
	fprintf(lp,"\033&a0r90m88L\015|");
	while(line++ < MAXLINE+2)
		fprintf(lp,"\n|");
}

printpage(fp)
FILE *fp;
{
	char c;
	int line,col;
	static int cont = 0;
	static char *cont1 = "---->";

	line = col = 0;
	if(cont){
		fprintf(lp,cont1);
		col = 5;
		cont = 0;
	}

	while( line < MAXLINE ){
		c = fgetc(fp);
		if(col>=80){
			line++;
			switch(c){
				case '\012':
				case '\015':
				case PAGE:
				case EOF:
				case '\377':
				case '\032':
					break;
				default:
					if(line >= MAXLINE){
						cont = 1;
						ungetc(c,fp);
						return(0);
					}
					fprintf(lp,"\n%s",cont1);
					col = 5;
					break;
			}
		}
		switch(c){
			case '\012':			/* newline found */
				col = 0;		/* zero column and */
				line++;			/* advance line count */
				if( line < MAXLINE )
					fprintf(lp,"\n");
				break;
			case '\015':			/* CR found */
				break;			/* discard it */
			case '\011':		/* TAB found */
				do
					fputc('\040',lp);
				while ( (++col % TAB) != 0 );
				break;
			case PAGE:			/* Page break or */
				line = MAXLINE;		/* force termination of loop */
				break;
			default:			/* no special case */
				fputc(c,lp);		/* print character */
				col++;
				break;
			case EOF:			/* EOF mark */
			case '\377':			/* EOF mark */
			case '\032':			/* EOF mark */
				return(-1);
		}
	}
	return(0);
}

stamp( filename, pagenum )
char *filename;
int pagenum;
{
	char datestr[10], timestr[10];

	timestamp(timestr);
	datestamp(datestr);
	fprintf(lp, "File: %-43s%s   %s  --  Page: %03d\n\n", filename,datestr,timestr,pagenum);
}

timestamp( timestr )
char	*timestr;
{
	struct tm buf;

	dostime(&buf);

	sprintf(timestr,"%02d:%02d",buf.tm_hour,buf.tm_min);
	return;
}

datestamp( datestr )
char  *datestr;
{
	struct tm buf;

	dostime(&buf);
	sprintf(datestr,"%02d/%02d/%02d",buf.tm_mon+1,buf.tm_mday,buf.tm_year);

	return;
}
