		page	78,122
		title	HPPS -- HP LaserJet+/SeriesII PrtSc Driver 7.6
;Revision history:
;06/02/89 Modified to read from all planes in EGA mode : 7.6
;05/14/89 Modified Text Screen printing for BBS's status lines : 7.5
;01/30/89 Translation table purged if /2 option (SeriesII) used : 7.4
;01/11/89 Added Margin Reset and released source code : 7.3
;01/04/89 Added Printer Reset to init strings : 7.2
;----------------------------------------------------------------------------

data		segment at 40h

		org	84h
rows		db	?

data		ends

;----------------------------------------------------------------------------

EGA_seg		segment at 0a000h
EGA_seg		ends

;----------------------------------------------------------------------------

MON_seg		segment at 0b000h
MON_seg		ends

;----------------------------------------------------------------------------

CGA_seg		segment at 0b800h
CGA_seg		ends

;----------------------------------------------------------------------------

code		segment para 'code' 
		assume	cs:code,ds:code,es:code

cseg_start	equ	$

		org	100h

start:		jmp	PrtSc

;---------------------------------------

hp_EGAinit	db	27,'E',27,'9',27,'&l0O',27,'&a1000h720V',27,'*t75R',27,'*r1A',0 
hp_EGAline 	db	27,'*b44W',0
hp_EGAlineE 	db	27,'*b50W',0
hp_CGAinit	db	27,'E',27,'9',27,'&l0O',27,'&a600h600V',27,'*t100R',27,'*r1A',0 
hp_CGAline 	db	27,'*b80W',0
hp_Text		db	27,'E',27,'9',27,'(8U',27,'(s0p10H',0
hp_Text2	db	27,'E',27,'9',27,'(10U',27,'(s0p10H',0
hp_CGAtext40	db	27,'&a0C',27,'&p40X',0
hp_CGAtext80	db	27,'&a0C',27,'&p80X',0
hp_end		db	27,'*rB',27,'&a0C',12,0 
hp_crlf		db	13,10,0 
hp_ff		db	12,0 

busy		db	0 
reverse		db	0
seriesII	db	0

mode		db	? 
width_		db	? 
vpage		db	?

vid_seg		dw	?
delta		dw	?

line_buffer	db	352 dup (0) 
 
;---------------------------------------
;		Screen snapshot routine 
 
snapshot:	cmp	cs:[busy],0	;Continue if not busy 
		jz	go_ahead	;
		iret			; 
 
go_ahead:	inc	cs:[busy]	;Set busy 
 
		sti			;let the dogs back in

		push	ax 		;save state
		push	bx 
		push	cx 
		push	dx 
		push	bp 
    		push	si 
		push	di 
		push	ds 
		push	es 
 
		mov	ax,cs		;setup ds,es
 		mov	ds,ax		;
		mov	es,ax		;

		cld			;set direction flag

		mov	ah,15		;Get video mode 
		int	10H		; 
		mov	[mode],al	; 
		mov	[width_],ah	; 
		mov	[vpage],bh	; 
 
		cmp	al,4		;See if 0-3 
		jb	CGA_Text	;Text modes use same routine 
 
		cmp	al,7		;see if mode 4-6
		je	CGA_Text	;mod 7 is text
		ja	try_EGAmD	;
		jmp	CGA_G6		;

try_EGAmD:	cmp	al,0dH		;CGA/EGA 320x200
		jne	try_EGAmE
		jmp	EGA_modeDE

try_EGAmE:	cmp	al,0eh		;CGA/EGA 640x200
		jne	try_MONmF	;
		jmp	EGA_modeDE	;

try_MONmF:	cmp	al,0fh		;MON 640x350
		jne	try_EGAm10	;
		jmp	MON_modeF	;

try_EGAm10:	cmp	al,10H		;EGA Hi-res modes 
		jne	cant_do
 		jmp	EGA_mode10

cant_do:	call	beep		;beep now and again
		jmp	exit		;none of the above 
 
;---------------------------------------

CGA_Text:	mov	ah,3		;get cursor position
		int	10h		;
		push	dx		;save it for later restore

		mov	bx,offset hp_Text	;Init Printer
		cmp	[seriesII],0		;for LaserJet+
		je	init_text		;
		mov	bx,offset hp_Text2	;for SeriesII
init_text:	call	print_msg		;

		xor	dx,dx		;set to start at top of screen

		mov	ax,1200h	;see if EGA here
		mov	bx,0ff10h	;set bh to illegal value
		int	10h		;

		mov	cl,[width_]
		mov	ch,25		;25 lines default for CGA adapter

		cmp	bh,0ffh		;see if bh changed
		je	T1		;no -- don't update ch

		assume	ds:data
		push	ds		;save ds
		mov	ax,data		;set for BIOS data area
		mov	ds,ax		;
		mov	ch,[rows]	;
		inc	ch		;
		pop	ds		;
		assume	ds:code

T1:		mov	bx,offset hp_CGAtext40
		cmp	cl,40
		je	T2
		mov	bx,offset hp_CGAtext80

T2:		push	bx
		push	dx
		call	print_msg
		pop	dx

T3:		push	dx		;save cursor position 

		mov	bh,[vpage]	;set new cursor position
		mov	ah,2		;
		int	10h		;

		mov	ah,8		;read char at cursor position
		int	10h		;

		cmp	[seriesII],0	;see if seriesII
		jnz	series2		;yes - skip xlate
		mov	bx,offset xlat_
		xlat			;translate char

series2:	xor	dx,dx		;set for lpt1:
		xor	ah,ah		;ah=0 print char
		int	17h		;print it
		
		pop	dx		;restore cursor position

		inc	dl		;bump column counter
		cmp	dl,cl		;EOL ?
		jnz	T3		;no -- same line, do next char

		xor	dl,dl		;reset column counter

		push	dx
		mov	bx,offset hp_crlf	;print crlf 
		call	print_msg		; 
		pop	dx

		pop	bx

		inc	dh		;bump row counter
		cmp	dh,ch		;end of screen ?
		jnz	T2		;no -- do next line

		pop	dx		;restore cursor position
		mov	ah,2		;
		mov	bh,[vpage]	;
		int	10h		;

		mov	bx,offset hp_ff	;eject page
		call	print_msg

		jmp	exit		;bye
		
;---------------------------------------

CGA_G6:		mov	ax,CGA_Seg
		mov	ds,ax

		mov	bx,offset hp_CGAinit
		call	print_msg

		mov	si,0H

		mov	cx,100
CGA_G6loop1:	push	cx
		push	si

		mov	cx,2		;print two lines per iteration
CGA_G6loop1a:	push	cx
		push	si

		mov	cx,2		;print each line twice for aspect ratio
CGA_G6loop2:	push	cx
		push	si		;save SI for second time printing

		mov	bx,offset hp_CGAline
		call	print_msg

		mov	cx,80
CGA_G6loop3:	lodsb    			
		xor	al,cs:[reverse]
		xor	ah,ah
		int	17H
		loop	CGA_g6loop3

		pop	si

		pop	cx
		loop	CGA_G6loop2

		pop	si
		add	si,8*1024	;odd scan lines are 8K further in buffer

		pop	cx
		loop	CGA_G6loop1a

		pop	si
		add	si,80		;next even line is 80 bytes in buffer

		pop	cx
		loop	CGA_G6loop1

		mov	bx,offset hp_end
		call	print_msg

		jmp	exit

;---------------------------------------

EGA_modeDE:	mov	bx,40
		mov	cx,8192/16

		cmp	al,0dh		;320x200 ?
		je	no_shift	;yes dont adjust

		shl	bx,1		;bx=80
		shl	cx,1		;cx=16384/16

no_shift:	mov	al,[vpage]	;index into correct page
		xor	ah,ah		;
		mul	cx		;
		add	ax,EGA_seg	;
		mov	[vid_seg],ax	;

		mov	cx,bx		;
		mov	[delta],bx	;
		
		mov	bx,offset hp_EGAinit
		call	print_msg

EGAmEloop1:	push	cx		;

		mov	si,cx
		dec	si

		mov	ax,[vid_seg]	;EGA RAM Buffer
		push	ds
		mov	ds,ax
		mov	di,offset line_buffer	;
		mov	cx,200		;read in one column for 200 rows
EGAmEloop2:  	call    get_byteEGA     ;(DS:SI) --> (ES:DI)
                inc     di
		add	si,es:[delta]	; move pointers
		loop	EGAmEloop2
		pop	ds

		mov	cx,8
EGAmEloop3:	push	cx

		mov	cx,1
		cmp	[mode],0dh	; 320x200 mode ?
		jne	dont_repeat	;no
		inc	cx		;print line twice

dont_repeat:	push	cx

		mov	bx,offset hp_EGAlineE
       		call	print_msg

		mov	si,offset line_buffer
		mov	cx,50		;50 bytes will be output
EGAmEloop4:	push	cx		;

		xor	al,al		;clear acc
		mov	cx,4		;
EGAmEloop5:	shl	al,1		;bump acc
		mov	ah,[si]		;get byte
		and	ah,1		;get lsb
		or	al,ah		;move into acc
		shl	al,1		;bump acc
		or	al,ah		;merge
		inc	si
		loop	EGAmEloop5	;

		xor	al,[reverse]
		xor	ah,ah		; Output Byte
		int	17h		;

		pop	cx		;
		loop	EGAmEloop4	;

		pop	cx		;do second line?
		loop	dont_repeat	;if cx=2 then yes

		mov	si,offset line_buffer
		mov	cx,200		;
EGAmEloop6:	shr	byte ptr [si],1	;shift byte for next time
		inc	si
		loop	EGAmEloop6

		pop	cx
		loop	EGAmEloop3

		pop	cx		;do next column
		loop	EGAmEloop1	;

		mov	bx,offset hp_end
		call	print_msg

		jmp	exit

;---------------------------------------

MON_modeF:	mov	ax,MON_seg
		jmp	short EGA_hires

EGA_mode10:	mov	ax,EGA_seg

EGA_hires:	mov	[vid_seg],ax

		mov	bx,offset hp_EGAinit
		call	print_msg

		mov	cx,80		;loop through 80 cols
EGAm10loop1:	push	cx		;

		mov	si,cx
		dec	si

		mov	ax,[vid_seg]	;MON/EGA RAM Buffer
		push	ds
		mov	ds,ax
		mov	di,offset line_buffer	;
		mov	cx,350		;read in one column for 350 rows

EGAm10loop2:    call    get_byteEGA     ;(DS:SI) --> (ES:DI)
                inc     di
		add	si,80           ; move pointers
		loop	EGAm10loop2
		pop	ds

		mov	cx,8
EGAm10loop3:	push	cx

		mov	bx,offset hp_EGAline
       		call	print_msg

		mov	si,offset line_buffer
		mov	cx,44		;44 bytes will be output
EGAm10loop4:	push	cx		;

		xor	al,al		;clear acc
		mov	cx,8		;build each 44 bit by bit
EGAm10loop5:	shl	al,1		;bump acc
		mov	ah,[si]		;get byte
		and	ah,1		;get lsb
		or	al,ah		;move into acc
		shr	byte ptr [si],1	;shift byte for next time
		inc	si
		loop	EGAm10loop5	;

		xor	al,[reverse]	;
		xor	ah,ah		; Output Byte
		int	17h		;

		pop	cx		;
		loop	EGAm10loop4	;	

		pop	cx
		loop	EGAm10loop3

		pop	cx		;do next column
		loop	EGAm10loop1	;

		mov	bx,offset hp_end
		call	print_msg	;fall through to exit:

exit:		call	beep		; signal done
                                        ;		
		pop	es		; Restore state
		pop	ds
		pop	di
		pop	si
		pop	bp
		pop	dx
		pop	cx
		pop	bx
		pop	ax
                                        ;
		cli
		dec	cs:[busy]	; Clear busy
		iret

;---------------------------------------
;
; get byte from DS:[SI] into ES:[DI] ( was movsb )
; but now modified to allow reading all planes
;
get_byteEGA:    push    dx
		xor	bl,bl		; clear ans
                                        ;
                mov     dx,3ceh         ; address 1 & 2 reg
                mov     al,4            ; read_map sel reg
                out     dx,al
                inc     dx              ; data reg
                                        ;
                mov     al,0
                out     dx,al           ; sel plane 0
		mov	ah,[si]		; get byte
		or	bl,ah		; move into bl
                                        ;
                mov     al,1
                out     dx,al           ; sel plane 1
		mov	ah,[si]		; get byte
		or	bl,ah		; move into bl
                                        ;
                mov     al,2
                out     dx,al           ; sel plane 2
		mov	ah,[si]		; get byte
		or	bl,ah		; move into bl
                                        ;
                mov     es:[di],bl      ; answer
                pop     dx
                ret

;---------------------------------------
;		print string at [bx]
print_msg:	mov	al,cs:[bx]	;print string at bx to printer
		or	al,al
		jnz	print_ok
		ret

print_ok:  	xor	ah,ah
		xor	dx,dx
		int	17h
		inc	bx
		jmp	print_msg

;---------------------------------------
;		beep when done

beep:		mov	bx,8080h
		xor	ch,ch
		in	al,61h
		push	ax
b1:		and	al,0fch
		out	61h,al
		mov	cl,bl
b2:		loop	b2
		or	al,2
		out	61h,al
		mov	cl,bl
b3:		loop	b3
		dec	bh
		jnz	b1
		pop	ax
		out	61h,al
		ret
                                        ;
cseg_end1	equ	$-cseg_start

;----------------------------------------------------------------------------
;	The translation table is located here so that it can be purged
;	if the /2 (Series II) option is selected.

xlat_		db	  0,  1,  2, 72, 68, 67, 83,  7,252,  9,252, 11, 12, 13, 14, 42
		db	 62, 60, 18, 19,240,189, 95, 23, 94,118,253,251, 28, 29, 30, 31
		db	 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47
		db	 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63
		db	 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79
		db	 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95
		db	 96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111
		db	112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127
		db	180,207,197,192,204,200,212,181,193,205,201,221,209,217,216,208
		db	220,215,211,194,206,202,195,203,239,218,219,191,187,188,000,190
		db	196,213,198,199,183,182,249,250,185,246,246,248,247,184,251,253
		db	127,127,127,124,124,124,124,246,246,124,124,246,246,246,246,246
		db	246,246,246,124,246, 43,124,124,246,246,246,246,124,246, 43,246
		db	246,246,246,246,246,246,246, 43, 43,246,246,252,252,252,252,252
		db	000,222,000,000,000,000,000,000,000,000,000,000,000,210,000,000
		db	000,254,000,000,000,000,000,000,179,000,000,000,000,000,252,000

cseg_end2	equ	$-cseg_start

;---------------------------------------
;
;	Init Code
;

PrtSc:		mov	dx,offset greeting
		mov	ah,09h		;print string
		int	21H		;

		mov	cl,ds:[80h]	;parse command line for -r or /r
		xor	ch,ch		;
		or	cl,cl		;
		jz	no_parm		;

		mov	si,81h		;command line buffer
parm_loop:	lodsb			;get byte
		cmp	al,' '
		jz	get_next
		cmp	al,09h		;tab
		jz	get_next
		cmp	al,'/'		;option switch?
		jz	get_option
		cmp	al,'-'		;option switch?
		jz	get_option	;

bad_parm:	mov	dx,offset bad_parm_msg
		mov	ah,09h		;print message
		int	21h		;

abort:		mov	ax,4c01h	;exit
		int	21h		;
		
get_next:	loop	parm_loop
		jmp	short no_parm

get_option:	lodsb			;get option
		dec	cx		;adjust command char count
		cmp	al,'R'		;reverse image option
		je	set_reverse	;
		cmp	al,'r'		;
		je	set_reverse	;
		cmp	al,'2'		;Series II option
		je	set_seriesII	;
		cmp	al,'?'		;Syntax
		je	disp_syntax	;
		jmp	bad_parm	;

set_reverse:	mov	[reverse],255	;set reverse flag
		jmp	get_next

set_seriesII:	mov	[seriesII],255	;set seriesII flag
		jmp	get_next

disp_syntax:	mov	dx,offset syntax	;display syntax
		mov	ah,09h			;write string
		int	21h
		
		jmp	abort

no_parm:	mov	dx,offset snapshot
		mov	ax,2505h	;Set PrtSc int vector
		int	21h

		mov	es,ds:[002cH]	;release environment segment
		mov	ah,49H		;
		int	21H		;

		mov	dx,cseg_end2/16+1	; remove translation table
		cmp	[seriesII],0		; if /2 (SeriesII) option
		je	not_II			; selected.

		mov	dx,cseg_end1/16+1
not_II:		mov	ax,3100h	;Terminate but stay resident
		int	21h		;bye!

greeting	db	'HP LaserJet+/SeriesII Print Screen Driver version 7.6'
		db	13,10,'$'
syntax		db	10,'Syntax:',13,10
		db	'   -r or /r = Reverse Image',13,10
		db	'   -2 or /2 = SeriesII',13,10,'$'
bad_parm_msg	db	07,10,'Illegal parameter',13,10,'$'

code		ends
		end	start

