/* Program to convert DEAR TEACHER to array initialization data in the       */
/* Microsoft C language                                                      */

/* Coded in Microsoft C 5.1 by Daniel Ross, starting 11/2/87                 */
/* Revised 10/13/88    11:15                                                 */

/* The input data to this program, DEAR TEACHER, was created by Daniel Ross  */
/* starting 3/20/88, and entered into the public domain by the author at     */
/* that time.                                                                */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define FALSE           0
#define TRUE            1
#define TorF            int

#define MaxColsPerChar  32
#define RowsPerChar     35              /* 27 rows above base line, + 8 rows */
                                        /* of descenders                     */

FILE   * InputFile, * OutputFile ;
char   InputFileName  []   =   "TEACHER.TXT" ;
char   OutputFileName []   =   "TEACHER.C" ;

char   Buf [MaxColsPerChar + 4] ;
char   InputChar ;

int    CharIndex, Row, Col, ActualColsThisChar ;
long   Acc ;
TorF   ActualColsKnown ;
char   * pFinalQuote ;

void   FormatErr (void)
  {
    printf
      ("\nFormat err, char %02x(hex), row %d up from bottom", CharIndex, Row) ;
    printf ("\nActual line read:  %s", Buf) ;
    exit (1) ;
  }

void   main (void)
  {
    if ( ! (InputFile = fopen (InputFileName, "rt")))
      {
        printf ("\nUnable to open input file %s", InputFileName) ;
        exit (1) ;
      } ;
    if ( ! (OutputFile = fopen (OutputFileName, "wt")))
      {
        printf ("\nUnable to open output file %s", OutputFileName) ;
        exit (1) ;
      } ;
    for (CharIndex = 0 ;   CharIndex != '!' ;   ++ CharIndex)
      {
        fprintf (OutputFile, "        {") ;
        for (Row = RowsPerChar - 1 ;   Row ;   -- Row)
          fprintf (OutputFile, "0,") ;
        fprintf (OutputFile, "0},\n") ;
      } ;
    for ( ;   CharIndex != 128 ;   ++ CharIndex)
      {
        if ( ! fgets (Buf, MaxColsPerChar + 4, InputFile))
          {
            printf
              ("\nRead err or early end, at separator before char %02x(hex)",
                CharIndex) ;
            exit (1) ;
          } ;
        if (strcmp (Buf, "-----------------------\n"))
          {
            printf
            ("\nExpecting separator before char %02x(hex), actually read:  %s",
                CharIndex, Buf) ;
            exit (1) ;
          } ;
        if ( ! fgets (Buf, MaxColsPerChar + 4, InputFile))
          {
            printf
              ("\nRead err or early end, at blank line before char %02x(hex)",
                CharIndex) ;
            exit (1) ;
          } ;
        fprintf (OutputFile, "        {") ;
        ActualColsKnown = FALSE ;
        for (Row = RowsPerChar - 1 ;   Row >= 0 ;   -- Row)
          {
            if ((Row % 6)   ==   5)     fprintf (OutputFile, "\n         ") ;
            if ( ! fgets (Buf, MaxColsPerChar + 4, InputFile))
              {
                printf
   ("\nRead err or early end, char %02x(hex), row %d up from bottom descender",
                    CharIndex, Row) ;
                exit (1) ;
              } ;
            if ( ! ActualColsKnown)
              {
                ActualColsKnown = TRUE ;
                if ( ! (pFinalQuote = strchr ( & Buf [1], '"')))   FormatErr();
                                        /* Assignment, not comparison        */
                ActualColsThisChar   =   (pFinalQuote - & Buf [1]) ;
                if (ActualColsThisChar   >   MaxColsPerChar)       FormatErr();
              } ;
            if
              (
                (Buf [0]   !=   '"')
                  ||
                (( * pFinalQuote)         !=   '"')
                  ||
                (( * (pFinalQuote + 1))   !=   '\n')
              )
              FormatErr () ;
            Acc = 0 ;
            for (Col = 1 ;   Col <= ActualColsThisChar ;   ++ Col)
              {
                InputChar   =   Buf [Col] ;
                if (InputChar   ==   '*')
                  Acc   |=   (long) (((long) 1) << (32 - Col)) ;
                else
                  {
                    if (InputChar   !=   ' ')     FormatErr () ;
                  } ;
              } ;
            fprintf (OutputFile, "0x%08lx", Acc) ;
            if (Row)   fprintf (OutputFile, ",") ;
            else
              {
                fprintf (OutputFile, "}") ;
                if (CharIndex != 127)   fprintf (OutputFile, ",") ;
                fprintf (OutputFile, "\n") ;
              } ;
          } ;
        if ( ! fgets (Buf, MaxColsPerChar + 4, InputFile))
          {
            printf
              ("\nRead err or early end, at blank line after char %02x(hex)",
                CharIndex) ;
            exit (1) ;
          } ;
      } ;
    if (fclose (OutputFile))
      {
        printf ("\nErr closing output file %s", OutputFileName) ;
        exit (1) ;
      } ;
    if (fclose (InputFile))
      {
        printf ("\nErr closing input file %s", InputFileName) ;
        exit (1) ;
      } ;
    exit (0) ;
  }

/* End of file                                                               */
