comment |

       Program name:  Setkey.asm

       Author:  Terry N. Bezue

       Date:  10/17/87

       Language:  Microsoft Macro Assembler 4.0

       Purpose:  Define function keys 1-40 by user input

       Requirements:  ANSI.SYS must be installed to work correctly

       Recompile insturctions:
               masm setkey;
               link setkey;
               exe2bin setkey setkey.com
               del setkey.exe

       |
;      Macro to print data at address
print  macro   address
       lea     dx,address
       mov     ah,9
       int     21h
       endm
code           segment byte
               assume  cs:code,ds:code,ss:code,es:code
               org     80h
nbytes         label   byte
               org     82h
input          label   byte
               org     100h            ; COM format
setkey:        jmp     short start
first          db      27,'[0;$'
key            db      0,0,0,';"$'
last           db      '";13p$'
errmsg         db      7,'Invalid parameters in input$'

start:         xor     dh,dh           ; zero dh
               mov     bx,10           ; convert to key code
               mov     cl,nbytes       ; Get # of bytes entered
               xor     ch,ch           ; zero ch
               dec     cx              ; skip first blank char
               cmp     cl,0            ; more chars entered
               jg      parse           ; yes, process line
               jmp     error           ; no, error
parse:         lea     di,input        ; get address of input
               mov     al,' '          ; find first
               repe    scasb           ;   non blank char
               jz      error           ; if all blank, error
               dec     di              ; adjust di
               inc     cx              ;  ... and cx
               xor     ax,ax           ; zero ax
get_key:       mov     dl,[di]         ; get char
               cmp     dl,' '          ; is it a blank
               jz      ck_key          ; if so, check for vadility
               cmp     dl,'0'          ; is it zero
               jb      error           ; if less, error
               cmp     dl,'9'          ; is it a nine
               ja      error           ; if greater,error
               sub     dl,'0'          ; make hex
               mul     bl              ; mul old number by 10
               add     ax,dx           ; add next digit
               inc     di              ; point to next char
               loop    get_key         ; do next digit
ck_key:        cmp     ax,0            ; key must be between 1 and 40
               jle     error           ; if less than 1, error
               cmp     ax,10           ; was it a 10
               jle     adj_main        ; if so, adjust for main fkeys
               cmp     ax,40           ; greater than 40
               jg      error           ; if so, error
               add     ax,15           ;   adjust for extended keys
adj_main:      add     ax,58           ; adjust fo main fkeys
               lea     si,key+2        ; get key address
               push    cx              ; save remaining byte count
               mov     cx,3            ; will be at 3 digits in key
put_digit:     xor     dx,dx           ; zero in dx
               div     bx              ; divide by ten
               add     dl,'0'          ; convert to ascii
               mov     [si],dl         ; store it
               dec     si              ; next digit
               loop    put_digit       ; do next digit
               pop     cx              ; get remaining byte count back
               dec     cx              ; skip blank char
               cmp     cx,0            ; error if no more
               jle     error
               inc     di              ; adjust di
               print   first           ; print setup part
               print   key             ; print converted key number
               mov     si,di           ; address of string in si
               add     si,cx           ; point to end of string
               mov     byte ptr [si],'$' ; put end of string char
               print   [di]            ; print string starting at di
               print   last            ; print last part
               jmp     short done      ; we're done
error:         print   errmsg           ; print error message
done:          int     20h             ; terminate
code           ends
               end     setkey
