    JMP     INITIALIZE ;jmp over interrupt handlers
		       ;
		       ;
INT1C:
		       ;INT 1Ch HANDLER
    JMP     SHORT JMP_TO_START_CODE   ; *** IBM's sharing interrupt 
				      ; protocol block 
PREVHANDL:
    DD      1234h:1234h       ;previous handler pointer
    DW      0424Bh     ;signature
    DB      0          ;flag
    JMP     SHORT hwreset     ;jmp short hwreset
    DB      7 DUP(0)   ;db 7 dup(0)
JMP_TO_START_CODE:
    JMP     SHORT STARTINTCODE        ;jmp over data
    DB      'KBSTF'    ;MANCINELLI's signature
hwreset:
    RETF
BUFSEG:
    DW      1234h      ; segment of buffer
BUFSTART:
    DW      1234h      ;
BUFEND:
    DW      1234h      ;
BUFHEAD:
    DW      1234h      ;
BUFTAIL:
    DW      1234h      ;
ISACTIVE:
    DB      0          ;Flag
ISINERROR:
    DB      0          ;Flag
ISINPAUSE:
    DB      0          ;Flag
ISSTOPPED:
    DB      0          ;Flag     

STARTINTCODE:
    PUSHF
    INC     BYTE PTR CS:[OFFSET ISACTIVE]
    CMP     BYTE PTR CS:[OFFSET ISACTIVE],1
    JA      TO_OLD_INT
    CMP     BYTE PTR CS:[OFFSET ISSTOPPED],0
    JNZ     TO_OLD_INT
L0: PUSH    AX
    PUSH    BX
    PUSH    CX
    PUSH    DX
    PUSH    SI
    PUSH    DS
    PUSH    ES
    CALL    LOAD_REGISTERS
    MOV     SI,[OFFSET BUFHEAD]
    CMP     SI,DX
    JZ      POP_AND_TO_OLD
    MOV     ES,[OFFSET BUFSEG]
    STI
    MOV     AL,1
    INC     BX
    CMP     BX,CX
    JAE     ERROR_EXIT
    DEC     BX
    CMP     BX,SI
    JA      RESET_PNTRS
    CMP     BX,DX
    JA      RESET_PNTRS
    DEC     CX
    CMP     SI,CX
    JAE     RESET_PNTRS
    CMP     DX,CX
    JAE     RESET_PNTRS 
    INC     CX
    JMP     SHORT STORELOOP_NO_ADV
RESET_PNTRS:
    MOV     [OFFSET BUFHEAD],BX
    MOV     [OFFSET BUFTAIL],BX
    MOV     BYTE PTR [OFFSET ISINPAUSE],0     
    JMP     SHORT POP_AND_TO_OLD
ERROR_EXIT:
    MOV     [OFFSET ISINERROR],AL
POP_AND_TO_OLD:
    POP     ES
    POP     DS
    POP     SI
    POP     DX
    POP     CX
    POP     BX
    POP     AX
TO_OLD_INT:
    DEC     BYTE PTR CS:[OFFSET ISACTIVE]
    POPF
    JMP     FAR CS:[OFFSET PREVHANDL] ;jmp to old int 1C handler
STORELOOP:
    CALL    INC_BUFHEAD
STORELOOP_NO_ADV:
    CMP     SI,DX
    JZ      POP_AND_TO_OLD
    CMP     BYTE PTR [OFFSET ISINPAUSE],0
    JZ      NOT_INPAUSE                     ; ALTERNATIVELY (different choice)
    DEC     WORD PTR ES:[SI]                ; SUB WORD PTR ES:[SI],1
    JNZ     L6                              ; JNC
    MOV     BYTE PTR [OFFSET ISINPAUSE],0
    CALL    INC_BUFHEAD
L6: JMP     SHORT POP_AND_TO_OLD
NOT_INPAUSE:
    MOV     AX,ES:[SI]
    CMP     AH,0FFh
    JNZ     IS_LONG_PAUSE?
    NOT     BYTE PTR ES:[SI+1]
    MOV     BYTE PTR [OFFSET ISINPAUSE],1
    JMP     SHORT STORELOOP_NO_ADV
IS_LONG_PAUSE?:
    OR      AX,AX
    JNZ     NOT_PAUSE 
    MOV     BYTE PTR [OFFSET ISINPAUSE],1
    JMP     SHORT STORELOOP
NOT_PAUSE:
    MOV     BX,040h
    MOV     DS,BX
    CLI
    MOV     BX,[1Ch]
    LEA     CX,[BX+2]
    CMP     CX,[082h]
    JB      L7 
    MOV     CX,[080h] 
L7: CMP     CX,[1Ah]
    JZ      POP_AND_TO_OLD
    MOV     [BX],AX
    MOV     [1Ch],CX
    STI
    CALL    LOAD_REGISTERS  
    JMP     SHORT STORELOOP
LOAD_REGISTERS:
    MOV     BX,CS
    MOV     DS,BX
    MOV     BX,[OFFSET BUFSTART]
    MOV     CX,[OFFSET BUFEND]  
    MOV     DX,[OFFSET BUFTAIL]
    RET
INC_BUFHEAD:
    INC     SI
    INC     SI
    CMP     SI,CX
    JB      L8
    MOV     SI,BX
L8: MOV     [OFFSET BUFHEAD],SI
    RET
INITIALIZE:
    MOV     AX,351Ch   ;get old int 1Ch handler
    INT     21h
    MOV     SI,OFFSET PREVHANDL
    MOV     [SI],BX
    MOV     [SI+02],ES        
    MOV     DX,OFFSET INT1C   ;set new int 1Ch handler
    MOV     AX,251Ch
    INT     21h
    MOV     AX,[002Ch]  ;free environment segment
    MOV     ES,AX
    MOV     AX,4900h
    INT     21h
    MOV     [OFFSET BUFSEG],DS
    MOV     AX,0h
    MOV     [OFFSET BUFSTART],AX
    MOV     [OFFSET BUFHEAD],AX
    MOV     [OFFSET BUFTAIL],AX
    MOV     WORD PTR [OFFSET BUFEND],100h 
    
    MOV     DX,OFFSET INITIALIZE       ;terminate and stay resident
    INT     27h                        ;free memory from init code
