    JMP     INITIALIZE ;jmp over interrupt handlers
		       ;
		       ;
INT21h:
		       ;INT 21h HANDLER
    JMP     SHORT JMP_TO_START_CODE   ; *** IBM's sharing interrupt 
				      ; protocol block 
PREVHANDL:
    DD      0h:0FFFFh  ;previous handler pointer
    DW      0424Bh     ;signature
    DB      0          ;flag
    JMP     SHORT hwreset     ;jmp short hwreset
    DB      7 DUP(0)   ;db 7 dup(0)
JMP_TO_START_CODE:
    JMP     SHORT STARTINTCODE        ;jmp over data
    DB      'KBRDS'    ;MANCINELLI's signature
hwreset:
    RETF
TRAP:
    DB      1 
STARTINTCODE:
    CMP     BYTE PTR CS:[OFFSET TRAP],0
    JZ      OLD_INT 
    CMP     AH,0Ch
    JNZ     OLD_INT 
    CMP     AL,1
    JZ      STRIP_KBBUFF_RES_REQUEST
    CMP     AL,6
    JZ      STRIP_KBBUFF_RES_REQUEST
    CMP     AL,7
    JZ      STRIP_KBBUFF_RES_REQUEST
    CMP     AL,8
    JZ      STRIP_KBBUFF_RES_REQUEST
    CMP     AL,0Ah
    JZ      STRIP_KBBUFF_RES_REQUEST
EXIT_INT:              ;do nothing
    IRET
STRIP_KBBUFF_RES_REQUEST:
    MOV     AH,AL
    XOR     AL,AL    
OLD_INT:
    JMP     FAR CS:[OFFSET PREVHANDL] ;jmp to old int 1C handler
INITIALIZE:
    MOV     AX,3521h   ;get old int 1Ch handler
    INT     21h
    MOV     SI,OFFSET PREVHANDL
    MOV     [SI],BX
    MOV     [SI+02],ES        
    MOV     AX,[002Ch]  ;free environment segment
    MOV     ES,AX
    MOV     AX,4900h
    INT     21h
    MOV     DX,OFFSET INT21h  ;set new int 1Ch handler
    MOV     AX,2521h
    INT     21h
    MOV     DX,OFFSET INITIALIZE       ;terminate and stay resident
    INT     27h                        ;free memory from init code
