#ifndef __TINY__
#error Must be compiled in tiny model
#endif

#define NULL 0
#if __STDC__
#define _Cdecl
#else
#define _Cdecl cdecl
#endif

void _Cdecl __int__(int interruptnum);
/* extern unsigned _Cdecl _psp; */

/* *********************************************************************** */
/*   The little assembly TSR KBRESDIS.COM hooks INT 21h  (dos functions),  */
/*  complying with IBM's INTERRUPT-SHARING PROTOCOL,  and  traps the  dos  */
/*  function AH=0Ch,  function that resets  the keyboard and, eventually,  */
/*  call a keyboard function.  Many programs use this to prevent  charac-  */
/*  ters stored in the keyboard buffer are used and to force a wait for a  */
/*  user input.  For example dos format does it when asks user to confirm  */
/*  an hard disk format request.                                           */
/*   When you are creating complex  batch files  that use keyboard buffer  */
/*  stuffing this could be useful.                                         */
/*   The companion program KBDOSRES allows to toggle the state of the TSR  */
/*  between "trap" and "don't trap" and allows to uninstall the TSR too.   */
/*                                                                         */
/*   syntax:                                                               */
/*   KBSTUFFR /U  uninstalls the TSR.                                      */
/*   KBSTUFFR /P[0|1] disables trapping (0) or enables it (1 and default)  */
/*                                                                         */
/*   Thanks a lot to Chris Dunford  for  posting informations about IBM's  */
/*  INTERRUPT-SHARING PROTOCOL                                             */
/*                                                                         */
/*                                                                         */
/*   (c) 1996 by Luigi Mancinelli                                          */
/*   manci@alpha.science.unitn.it                                          */
/*                                                                         */
/*   Note: If the program has to be recompiled, the tiny model has  to be  */
/*  used and the resulting .exe has to be converted in .com (with the DOS  */
/*  utility EXE2BIN for example) or the program doesn't work.              */
/*                                                                         */
/* *********************************************************************** */

#define MK_FP(seg,ofs)  ((void far *) \
                           (((unsigned long)(seg) << 16) | (unsigned)(ofs)))

#define _toupper(c)     ((c)&0xDF)

#define putchar(c) (_DL=c,_AH=02,__int__(0x21))

#define putbackslash() (_DL='\\',_AH=02,__int__(0x21))

void putstring(char *p)
{   unsigned int i=0;
    if (p!=NULL)
       while (p[i]!=0) putchar(p[i++]);
}

  char *HexDig="0123456789ABCDEF";

void puthexbyte(unsigned char ch)
{
   putchar(HexDig[ch>>4]);
   putchar(HexDig[ch&0xF]);
}

void puthexword(unsigned int w)
{
   puthexbyte( ((unsigned char *) &w)[1] );
   puthexbyte( *((unsigned char *) &w) );
}

void putpntr(void far *p)
{
   puthexword( ((unsigned int *) &p)[1] );
   putchar(':');
   puthexword( *((unsigned int *) &p) );
}

void newline(void)
{ putchar('\r'); putchar('\n'); }

typedef struct TSRPROTSTRU {
    unsigned int ShortJmp;
    struct TSRPROTSTRU far * Old;
    unsigned int Signature;
    char flag;
    unsigned int ShortJmpHWreset;
    char bytes[7];
    unsigned int MyJump;
    char recognise[5];
    char retf;
    unsigned char trap;
    }  TsrProtStructure;

typedef TsrProtStructure far *TsrProt;


TsrProt GetVect(unsigned char i)
{
    _AX=0x3500 | i;
    __int__(0x21);
    return (TsrProt) MK_FP(_ES,_BX);
}

void SetVect(unsigned char i, TsrProt P)
{
    unsigned int SaveDS;
    SaveDS=_DS;
    _DX=*((unsigned int *)(&P));
    _DS=((unsigned int *)(&P))[1];
    _AL=i; _AH=0x25;   /* _AX=0x2500 | i; */
    __int__(0x21);
    _DS=SaveDS;
    return;
}

#define SEG_OF_FARP(FP) (((unsigned int *)(&(FP)))[1])
#define FreeDOSMem(SEG) (_ES=SEG,_AH=0x49,__int__(0x21))

int IsCorrectTsrProtStru(TsrProt P)
{

    if (P==NULL) return 0;
    else if (P->Signature!=0x424B) return 0;
    /* comment following line for a less strict control */
    else if (P->ShortJmp!=0x10EB) return 0;
    else return 1;
}

int IsDisKeybReset(TsrProt P)
{
    if (IsCorrectTsrProtStru(P)==0) return -1;
    else if ((P->recognise[0]=='K')&&(P->recognise[1]=='B')&&
             (P->recognise[2]=='R')&&(P->recognise[3]=='D')&&
             (P->recognise[4]=='S') ) return 1;
    else return 0;
}

TsrProt Pntr;
TsrProt OldPntr=NULL;

  char *ToNewPtr=" => ";
  char *CheckMess="Actual int 21h handler => ";
  char *ErrMess="Cannot inspect TSR chain - KBRESDIS not found\r\n";
  char *Mess="Now DOS keyboard buffer reset is ";
  char *DontTrap="ENABLED\r\n";
  char *Trap="DISABLED\r\n";
  char *TryUnInst="Attempting to uninstalling KBRESDIS\r\n";
  char *Uninstalled="KBRESDIS successfully uninstalled\r\n";
  char *Re_Chaining="Re-chaining to old interrupt ";
  char *Restoring="Restoring old interrupt ";
  char *InvalidSwitch="Invalid switch /";

/* *************************** */
unsigned char *CmdStr=(unsigned char *) 0x80;
int i=1;


void SkipBlanks(void) {
   while ((CmdStr[i]==' ')||(CmdStr[i]==9)) i++;
}


/* *************************** */
int IsBlankOrSwitch(unsigned int i)
{
   return ((CmdStr[i]==0x0D)||
           (CmdStr[i]==' ')||(CmdStr[i]==9)||(CmdStr[i]=='/'));
}

int SkipToNextBlankOrSwitch(void)
{
   while(!IsBlankOrSwitch(i)) i++;
}

unsigned int W;

int _Cdecl main() {
/*
unsigned int DS=((unsigned long)((char far *)(&CmdStr)))>>16;
if(DS==_psp) { */
   int Fnd;

   /* now try to find KBRESDIS as int 21h handler */
   Pntr=/* (TsrProt) getvect(0x21) */ GetVect(0x21);
   putstring(CheckMess);   putpntr(Pntr);   newline();
   while ((Fnd=IsDisKeybReset(Pntr))==0) {
      OldPntr=Pntr;  Pntr=Pntr->Old;
      putpntr(OldPntr); putstring(ToNewPtr); putpntr(Pntr); newline();
   }
   if(Fnd==-1) {
      putstring(ErrMess);
      return 1;
   }
   else {

      W=CmdStr[0];  if(CmdStr[W+1]!=0x0D) CmdStr[W+1]=0x0D;
      SkipBlanks();
      while (CmdStr[i]!=0x0D) {
         if(CmdStr[i]=='/') {
            switch(CmdStr[i+1]) {
            case 'p':
            case 'P':switch(CmdStr[i+=2]) {
                     case '0':if(!IsBlankOrSwitch(++i))
                                 SkipToNextBlankOrSwitch();
                              else Pntr->trap=0;
                              break;
                     case '1':if(!IsBlankOrSwitch(++i))
                                {  SkipToNextBlankOrSwitch(); break; }
                     case '/':
                     case ' ':
                     case 9:
                     case 0x0D:Pntr->trap=1;
                     }
                     break;
            case 'u':
            case 'U':
                     Pntr->trap=1;
                     /* now try to unhook int 21h */
                     putstring(TryUnInst);
                     if (OldPntr!=NULL) { /* adjust the after loaded TSR */
                        putstring(Re_Chaining);
                        OldPntr->Old=Pntr->Old;
                     }
                     else {
                        putstring(Restoring);
                        SetVect(0x21,Pntr->Old);
                     }
                     putpntr(Pntr->Old); newline();
                     FreeDOSMem(SEG_OF_FARP(Pntr));
                     putstring(Uninstalled);
                     return 0;
            default :
                     putstring(InvalidSwitch); putchar(CmdStr[i+1]);
                     newline();
                     i++;
                     SkipToNextBlankOrSwitch();
            }
         } else SkipToNextBlankOrSwitch();
         SkipBlanks();
      }
      putstring(Mess);
      if (Pntr->trap) putstring(Trap); else putstring(DontTrap);
   }
/* } */
}