#ifndef __TINY__
#error Must be compiled in tiny model
#endif

#define NULL 0
#if __STDC__
#define _Cdecl
#else
#define _Cdecl cdecl
#endif

void _Cdecl __cli__ (void);
void _Cdecl __sti__ (void);
void _Cdecl __int__(int interruptnum);

/* extern unsigned _Cdecl _psp; */


/* *********************************************************************** */
/*   The little assembly TSR DISKBD.COM hooks INT 09h  (keyb. interrupt),  */
/*  complying with IBM's INTERRUPT-SHARING PROTOCOL and disables the key-  */
/*  board accepting only the combination  <CTRL><ALT><LEFT SHIFT><SPACE>,  */
/*  which allows to toggle between keyboard enabled and disabled.          */
/*   Why one could use a similar program? For example to disable keyboard  */
/*  during execution of batch file, or when a keyboard  stuffer, like the  */
/*  combination of KBSTFRES.COM and KBSTUFFR, is used and  the user input  */
/*  is desired to be temporarily disabled.    In both cases disabling and  */
/*  enabling keyboard should be possible from a  batch file to  be really  */
/*  useful.                                                                */
/*   This is what this program does, allowing to change the state of  the  */
/*  previously loaded TSR and even to uninstalling it  (supposing that no  */
/*  not IBM's ISP compliant TSR are loaded after it).                      */
/*                                                                         */
/*   syntax:                                                               */
/*   UNINSTKL /U  uninstall DISKBD.COM TSR from interrupt chain of inter-  */
/*               rupt 09h and remove it from memory.                       */
/*   UNINSTKL /E  enable keyboard.                                         */
/*   UNINSTKL /D  disable keyboard.                                        */
/*                                                                         */
/*   Thanks a lot to Chris Dunford  for  posting informations about IBM's  */
/*  INTERRUPT-SHARING PROTOCOL                                             */
/*                                                                         */
/*                                                                         */
/*   (c) 1996 by Luigi Mancinelli                                          */
/*   manci@alpha.science.unitn.it                                          */
/*                                                                         */
/*   Note: If the program has to be recompiled, the tiny model has  to be  */
/*  used and the resulting .exe has to be converted in .com (with the DOS  */
/*  utility EXE2BIN for example) or the program doesn't work.              */
/*                                                                         */
/* *********************************************************************** */

#define MK_FP(seg,ofs)  ((void far *) \
                           (((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#define SET_FP_OFF(fp,ofs)  ((void far *) \
                      ((((unsigned long)(fp))&0xFFFF0000)|(unsigned)(ofs)))

#define _toupper(c)     ((c)&0xDF)

#define putchar(c) (_DL=c,_AH=02,__int__(0x21))

#define putbackslash() (_DL='\\',_AH=02,__int__(0x21))

void putstring(char *p)
{   unsigned int i=0;
    if (p!=NULL)
       while (p[i]!=0) putchar(p[i++]);
}

  char *HexDig="0123456789ABCDEF";

void puthexbyte(unsigned char ch)
{
   putchar(HexDig[ch>>4]);
   putchar(HexDig[ch&0xF]);
}

void puthexword(unsigned int w)
{
   puthexbyte( ((unsigned char *) &w)[1] );
   puthexbyte( *((unsigned char *) &w) );
}

void putpntr(void far *p)
{
   puthexword( ((unsigned int *) &p)[1] );
   putchar(':');
   puthexword( *((unsigned int *) &p) );
}

void newline(void)
{  putchar('\r'); putchar('\n'); }

int IsGoodSeparator(unsigned char Ch)
{ return (Ch==0x0D)||(Ch==' ')||(Ch==9)||(Ch=='/'); }

typedef struct TSRPROTSTRU {
    unsigned int ShortJmp;
    struct TSRPROTSTRU far * Old;
    unsigned int Signature;
    char flag;
    unsigned int ShortJmpHWreset;
    char bytes[7];
    unsigned int MyJump;
    char recognise[5];
    char retf;
    unsigned char Enabled;
    unsigned char Flags;
    }  TsrProtStructure;

typedef TsrProtStructure far *TsrProt;


TsrProt GetVect(unsigned char i)
{

    _AH=0x35; _AL=i; /* _AX=0x3500 | i; */
    __int__(0x21);
    return (TsrProt) MK_FP(_ES,_BX);
}

void SetVect(unsigned char i, TsrProt P)
{
    unsigned int SaveDS;
    SaveDS=_DS;
    _DX=*((unsigned int *)(&P));
    _DS=((unsigned int *)(&P))[1];
    _AL=i; _AH=0x25;   /* _AX=0x2500 | i; */
    __int__(0x21);
    _DS=SaveDS;
    return;
}

#define SEG_OF_FARP(FP) (((unsigned int *)(&(FP)))[1])
#define FreeDOSMem(SEG) (_ES=SEG,_AH=0x49,__int__(0x21))

int IsCorrectTsrProtStru(TsrProt P)
{

    if (P==NULL) return 0;
    else if (P->Signature!=0x424B) return 0;
    /* comment following line for a less strict control */
    else if (P->ShortJmp!=0x10EB) return 0;
    else return 1;
}

int IsDISKBD(TsrProt P)
{
    if (IsCorrectTsrProtStru(P)==0) return -1;
    else if ((P->recognise[0]=='K')&&(P->recognise[1]=='B')&&
             (P->recognise[2]=='D')&&(P->recognise[3]=='I')&&
             (P->recognise[4]=='S') ) return 1;
    else return 0;
}

TsrProt Pntr;
TsrProt OldPntr=NULL;
unsigned int p;
unsigned char Ch;

  char *ToNewPtr=" => ";
  char *CheckMess="Actual int 09h handler => ";
  char *ErrMess="Cannot inspect TSR chain - DISKBD not found\r\n";
  char *Disabled="KEYBOARD DISABLED";
  char *Enabled="KEYBOARD ENABLED";
  char *TryUnInst="Attempting to uninstalling DISKBD\r\n";
  char *Uninstalled="DISKBD successfully uninstalled\r\n";
  char *Re_Chaining="Re-chaining to old interrupt ";
  char *Restoring="Restoring old interrupt ";
  char *InvalidSwitch="Invalid switch /";

/* *************************** */
unsigned char *CmdStr=(unsigned char *) 0x80;
int i=1;

void SkipBlanks(void) {
   while ((CmdStr[i]==' ')||(CmdStr[i]==9)) i++;
}

main() {
/*
unsigned int DS=((unsigned long)((char far *)(&CmdStr)))>>16;
if(DS==_psp) { */
   int Fnd;

   /* now try to find DISKBD as int 09h handler */
   Pntr=/* (TsrProt) getvect(0x09) */ GetVect(0x09);
   putstring(CheckMess);   putpntr(Pntr);   newline();

   while ((Fnd=IsDISKBD(Pntr))==0) {
      OldPntr=Pntr;  Pntr=Pntr->Old;
      putpntr(OldPntr); putstring(ToNewPtr); putpntr(Pntr); newline();
   }
   if(Fnd==-1) {
      putstring(ErrMess);
      return 1;
   }
   else {
      p=CmdStr[0];  if(CmdStr[p+1]!=0x0D) CmdStr[p+1]=0x0D;
      SkipBlanks();
      while (CmdStr[i++]=='/') {
         Ch=_toupper(CmdStr[i++]);
         if (IsGoodSeparator(CmdStr[i]) ) {
            switch(Ch) {
            case 'U':
               Pntr->Enabled=1;
               /* now try to unhook int 09h */
               putstring(TryUnInst);
               if (OldPntr!=NULL) { /* adjust the after loaded TSR */
                  putstring(Re_Chaining);
                  __cli__();
                  OldPntr->Old=Pntr->Old;
                  __sti__();
               }
               else {
                  putstring(Restoring);
                  __cli__();
                  SetVect(0x09,Pntr->Old);
                  __sti__();
               }
               putpntr(Pntr->Old); newline();
               FreeDOSMem(SEG_OF_FARP(Pntr));
               putstring(Uninstalled);
               return 0;
            case 'E':   Pntr->Enabled=1;   break;
            case 'D':   Pntr->Enabled=0;   break;
            default:
               putstring(InvalidSwitch); putchar(Ch); newline();
            }
            SkipBlanks();
         }
         else {
            putstring(InvalidSwitch); putchar(Ch); putchar(CmdStr[i]);
            newline();
            i++;
            while (!IsGoodSeparator(CmdStr[i])) i++;
            SkipBlanks();
         }
      }
      if(Pntr->Enabled) putstring(Enabled); else putstring(Disabled);
      newline();
   }
/* } */
}