    JMP     INITIALIZE ;jmp over interrupt handlers
		       ;
		       ;
INT09:
		       ;INT 1Ch HANDLER
    JMP     SHORT JMP_TO_START_CODE   ; *** IBM's sharing interrupt 
				      ; protocol block 
PREVHANDL:
    DD      1234h:1234h       ;previous handler pointer
    DW      0424Bh     ;signature
    DB      0          ;flag
    JMP     SHORT hwreset     ;jmp short hwreset
    DB      7 DUP(0)   ;db 7 dup(0)
JMP_TO_START_CODE:
    JMP     SHORT STARTINTCODE        ;jmp over data
    DB      'KBDIS'    ;MANCINELLI's signature
hwreset:
    RETF
KBD_ENABLED:
    DB      0          ;Flag     
FLAGS:
    DB      0          ;Flag
STARTINTCODE:
    PUSHF
    PUSH    AX
    PUSH    DS
    MOV     AX,CS
    MOV     DS,AX
    IN      AL,60h
    MOV     AH,AL
    AND     AL,7Fh
    CMP     AL,38h
    JNZ     ISCTRL
    MOV     AL,1
    JMP     SHORT PROCESS_FLAG_KEY
ISCTRL: 
    CMP     AL,1Dh
    JNZ     ISLEFTSHIFT
    MOV     AL,2
    JMP     SHORT PROCESS_FLAG_KEY
ISLEFTSHIFT:
    CMP     AL,2Ah
    JNZ     ISRIGHTSHIFT
    MOV     AL,4
    JMP     SHORT PROCESS_FLAG_KEY
ISRIGHTSHIFT:
    CMP     AL,36h
    JNZ     ISSPACE
    MOV     AL,8
    JMP     SHORT PROCESS_FLAG_KEY
ISSPACE:
    CMP     AL,39h
    JNZ     END_PROCESS
    TEST    AH,80h
    JNZ     END_PROCESS
    MOV     AL,[OFFSET FLAGS]
    AND     AL,7
    CMP     AL,7
    JNZ     END_PROCESS
    XOR     BYTE PTR [OFFSET KBD_ENABLED], 1
    POP     DS
    JMP     SHORT RESET_RITUAL
;
PROCESS_FLAG_KEY:  
    TEST    AH,80h
    JZ      L1
    NOT     AL
    AND     [OFFSET FLAGS],AL
    JMP     END_PROCESS
L1: OR      [OFFSET FLAGS],AL
;
END_PROCESS:
    POP     DS
    CMP     BYTE PTR CS:[OFFSET KBD_ENABLED],0
    JZ      RESET_RITUAL
;
TO_OLD_INT:
    POP     AX
    POPF
    JMP     FAR CS:[OFFSET PREVHANDL] ;jmp to old int 1C handler
;
RESET_RITUAL:
    IN      AL,61h
    MOV     AH,AL
    OR      AL,80h
    OUT     61h,AL
    MOV     AL,AH
    OUT     61h,AL
    MOV     AL,20h
    OUT     20h,AL
    POP     AX
    POPF
    IRET 
;
;  
INITIALIZE:
    MOV     AX,3509h   ;get old int 1Ch handler
    INT     21h
    MOV     SI,OFFSET PREVHANDL
    MOV     [SI],BX
    MOV     [SI+02],ES        
    MOV     DX,OFFSET INT09   ;set new int 1Ch handler
    MOV     AX,2509h
    INT     21h
    MOV     AX,[002Ch]  ;free environment segment
    MOV     ES,AX
    MOV     AX,4900h
    INT     21h
;    
    MOV     DX,OFFSET INITIALIZE       ;terminate and stay resident
    INT     27h                        ;free memory from init code
