/* History:169,1 */
/* 03-19-88 23:16:17 use near buffer for history. */
/* 07-03-87 22:05:12 Use '\0' for the null character. */
/* 07-03-87 19:35:51 move argc, argv code from history_init() */
/* 07-03-87 16:48:53 move things around to get rid of forward prototypes */
/* 07-03-87 16:34:08 add line[], *cur, len */
/* 07-03-87 16:30:22 change (void *0) to ((void *) 0) */
/* 07-03-87 15:51:39 add argc, argv to history_init() */

#include <dos.h>
#include <alloc.h>

#define FALSE           0
#define TRUE            1
#define NULL ((void *)0)

/* imported from edit.c */
extern unsigned char line[], *cur;
extern int len;

static struct {
	unsigned char *histbufp;
	unsigned char *endbufp;
	unsigned char *firstp;
	unsigned char *nextp;
} buffers[2], *hist_switch;

#define histbuf		(hist_switch->histbufp)	/* beginning */
#define endhistbuf	(hist_switch->endbufp)	/* end */
#define first		(hist_switch->firstp)	/* logical first */
#define next		(hist_switch->nextp)	/* logical next */

static unsigned char *curhist;               /* current hist line */

int init_history(int hist_number, unsigned len)
{

  hist_switch = &buffers[hist_number];
  histbuf = sbrk(0);
  sbrk(len);
  endhistbuf = histbuf + len - 1;
  first = next = histbuf + 1;
  *first = *histbuf = '\0';
}


select_history(int whichone)
{
  hist_switch = &buffers[whichone];
}

reset_history()
{
  curhist = next;
}


/* go to previous history character */
static unsigned char *prv(unsigned char *p)
{
  return (p == histbuf) ? endhistbuf : --p;
}


/* go to next history character */
static unsigned char *nxt(unsigned char *p)
{
  return (p == endhistbuf) ? histbuf : ++p;
}


/* go to previous history line */
static unsigned char *backhist(unsigned char *p)
{
  if (p == first) return NULL;
  p = prv(p);
  while (*(p = prv(p)) != '\0')
    ;
  return nxt(p);
}


/* go to next history line */
static unsigned char *fwdhist(unsigned char *p)
{
  if (p == next) return NULL;
  while (*(p = nxt(p)) != '\0')
    ;
  return nxt(p);
}


prevhist(void)
{
	unsigned char *fp;
	if ((fp = backhist(curhist)) == NULL) bell();
	else gethist(fp);
}


nexthist(void)
{
	unsigned char *fp;
	if ((fp = fwdhist(curhist)) == NULL) bell();
	else gethist(fp);
}


/* make history line current and copy to line buffer */
gethist(unsigned char *p)
{
  int                   i;

  curhist = p;
  delln();
  cur = line;
  for (i = 0; *p != '\0' && i < len - 1; ++i)
  {
    *cur = *p;
    forward();
    p = nxt(p);
  }
  *cur = '\0';
}


/* save a history line */
puthist(void)
{
  int                   c;
  unsigned char         *q;

  q = line;
  do {
    c = *(next) = *(q++);
    next = nxt(next);
    if (next == first)
      first = fwdhist(nxt(first));
  } while (c != '\0');
  *next = '\0';
}


/* search for history line */
search(void)
{
  unsigned char *p, *q;
  unsigned char *r;

  for (p = backhist(curhist); p != NULL; p = backhist(p))
  {
    for (q = p, r = line;
         q != '\0' && r < cur && tolower(*q) == tolower(*r);
         q = nxt(q), ++r)
      ;
    if (r == cur)
    {
      gethist(p);
      home();
      while (cur < r)
        forward();
      return;
    }
    else {
      while (*cur != '\0') delchr();
    }
  }
}

