;     F11F12.ASM
;
;     This tiny TSR fixes the BIOS call to get characters from the
;     keyboard so that F11 and F12 are returned.  It does this by mapping
;     the "old" calls to the "new" calls, which are upwardly-compatible
;     with the old ones (after mapping the arrow keys back to the normal
;     zero-code).
;
;     Warning: this one MUST be loaded before any other TSR's that replace
;     the keyboard BIOS call!
;
code_seg     segment
     assume  CS:code_seg
     org     100H

old_int   label dword
begin:    jmp     short init
          dw 0

grab      proc   far
bint:     cmp    AH,1       ; old read or test keyboard ?
          jna    bint0
          jmp    [old_int]  ; all other calls

bint0:    or     AH,10H     ; make it extended
          pushf
          call   [old_int]
          pushf
          cmp    AL,0E0H    ; put extended keypad keys back
          jne    bint3
          xor    AL,AL
bint3:    popf
          ret    2
grab      endp

;--- end of TSR portion ---

     assume CS:code_seg,DS:code_seg
init:     mov    AX,12FFH   ; see if new shift-flag func works
          int    16H
          cmp    AL,0FFH    ; if unchanged, probably not...
          jne    init1
          int    20H        ; so exit w.o. doing anything
init1:    xor    AX,AX
          mov    ES,AX
          mov    AX,ES:[58H]; copy old int pointer
          mov    word ptr old_int,AX
          mov    AX,ES:[5AH]
          mov    word ptr old_int[2],AX
          cli
          mov    AX,offset bint
          mov    ES:[58H],AX
          mov    AX,CS
          mov    ES:[5AH],AX
          sti
          mov    DX,offset init
          int    27H

code_seg  ends

          end    begin
