           TITLE ENHANCED.ASM (24 March 1988 - Rufus S. Hendon)
;=============================================================================
; ENHANCED.ASM is adapted from the procedure called NewInt16 in ENHKBD.ASM
; Version 1.2 (2/23/88), written by Tim Kokkonen (with help from Brian Foley).
; ENHKBD is part of a Turbo Pascal 4.0 unit that makes it possible for Turbo
; Pascal programs to turn the enhanced keyboard on for the duration of the
; program, restoring the standard keyboard when the program terminates.
; ENHANCED, on the other hand, is independent of Turbo Pascal, and the .COM
; file produced from it is meant to be invoked from AUTOEXEC.BAT in order to
; make a permanent switch to the enhanced keyboard.  Like ENHKBD.ASM,
; ENHANCED.ASM is released to the public domain.
;=============================================================================
; This is a terminate-and-stay-resident replacement for the handler for type
; 16H interrupts.  It activates the enhanced keyboard as implemented by the
; Phoenix 80286 ROM BIOS Version 3.02 used in the AST Premium/286 computer.
;
; Among other reasons for activating the enhanced keyboard is the fact that
; the enhanced keyboard processes ALT-224 correctly, generating the code for
; the ordinary character alpha (code 224 = E0H).  The standard keyboard as
; implemented by the Phoenix BIOS incorrectly generates a null character
; (character code and scan code both = 00H) when ALT-224 is typed.
;
; The new handler for type 16H interrupts does two things:  (1) It changes
; functions 00H and 01H (in AH) to 10H and 11H respectively, which are the
; enhanced-keyboard functions.  It then calls the original handler.  (2) Upon
; return from the original handler, a check is made for cases in which an
; extended code (in AH) is paired with "character" code E0H (in AL) instead
; of 00H.  Such codes are generated for the keys that are specific to the
; enhanced keyboard, such as the cursor-movement keys that are separate from
; the numeric keypad.  To prevent these from being interpreted by application
; programs as the ordinary character with the code E0H (224), the E0H is
; replaced by 00H before return is made to the interrupter.
;=============================================================================
; The following table summarizes the keys which are affected by using this
; unit. The entries are the values of the scan word in hex.  The high byte of
; the scan word is the scan code, the low byte the ASCII character.  See
; Notes, following the table, for the key to special symbols.  [Kokkonen's
; table has been modified to reflect the operation of NewInt16 with the
; enhanced-keyboard implementation in the Phoenix 80286 ROM BIOS Version 3.02,
; without the replacement for interrupt 9H included in his ENHKBD.ASM.]
;
;               Plain     Shift     Control   Alt
;               -----     -----     -------   ----
; F11           8500%     8700%     8900%     8B00%
; F12           8600%     8800%     8A00%     8C00%
; Esc           011B      011B      011B      0100*
; Backquote     2960      297E       -        2900*
; Backspace     0E08      0E08      0E7F      0E00*
; Tab           0F09      0F00      9400*     A500*
; Left Brack    1A5B      1A7B      1A1B      1A00*
; Right Brack   1B5D      1B7D      1B1D      1B00*
; Backslash     2B5C      2B7C      2B1C      2B00*
; Semicolon     273B      273A       -        2700*
; Quote         2827      2822       -        2800*
; Enter         1C0D      1C0D      1C0A      1C00*
; Comma         332C      333C       -        3300*
; Period        342E      343E       -        3400*
; Slash         352F      353F       -        3500*
;-------------------------------------------------
; Numeric keypad keys:
; Insert        5200      5230      9200*      -
; Del           5300      532E      9300*      -
; Home          4700      4737      7700       -
; End           4F00      4F31      7500       -
; PgUp          4900      4939      8400       -
; PgDn          5100      5133      7600       -
; Up            4800      4838      8D00*      -
; Down          5000      5032      9100*      -
; Left          4B00      4B34      7300       -
; Right         4D00      4D36      7400       -
; Pad-Asterisk  372A       !         !        3700
; Pad-Minus     4A2D      4A2D      8E00*     4A00
; Pad-Plus      4E2B      4E2B      9000*     4E00
; Pad-5         4C00*     4C35      8F00*      -
;-------------------------------------------------
; Separate cursor-movement keys:
; Insert        5200      5200      9200*     A200*
; Del           5300      5300      9300*     A300*
; Home          4700      4700      7700      9700*
; End           4F00      4F00      7500      9F00*
; PgUp          4900      4900      8400      9900*
; PgDn          5100      5100      7600      A100*
; Up            4800      4800      8D00*     9800*
; Down          5000      5000      9100*     A000*
; Left          4B00      4B00      7300      9B00*
; Right         4D00      4D00      7400      9D00*
;
; Notes:
; - These keystrokes are ignored.
; * These keystrokes are not normally returned by the non-enhanced keyboard.
; ! These keystrokes control printscreen and print echoing. They cannot
;   simulate the effect of the enhanced keyboard, which has the Asterisk and
;   PrtSc keys separated.
; % The F11 and F12 keys are returned only if they actually exist on the
;   keyboard.
;
; With a few exceptions, NewInt16 returns results identical to those of the
; enhanced keyboard BIOS. One difference makes the enhanced keyboard simpler
; to use in a program: those scan words which normally contain E0 in the low
; byte to indicate that the key is specific to the enhanced keyboard (like the
; dedicated cursor keys) will have the low cleared to zero by NewInt16.
;*****************************************************************************
CODE       SEGMENT
;*****************************************************************************
           ORG 100H
           ASSUME  CS:CODE
ENHANCED:  JMP START
;*****************************************************************************
           ORG 104H
PrevInt16    LABEL DWORD
PrevInt16Ofs DW ?
PrevInt16Seg DW ?
;*****************************************************************************
;Handle software keyboard interrupts
NewInt16   PROC FAR
           PUSH    DX                   ;Save registers we use
           PUSH    DS
           PUSHF                        ;Save flags
           STI                          ;Allow interrupts
           OR      AH,AH                ;AH=0?
           JNZ     TryAH1               ;No, try AH=1
AH0:
           OR      AH,10h               ;Use enhanced BIOS call instead
           CALL    PrevInt16            ;Call previous int 16 (pops flags)
           OR      AH,AH                ;AH=0?
           JZ      AH0Done              ;Yes, done
           CMP     AL,0E0h              ;AL=E0h?
           JNZ     AH0Done              ;No, leave it alone
           XOR     AL,AL                ;Clear low byte of scan word
AH0Done:
           POP     DS                   ;Restore registers
           POP     DX
           IRET                         ;Return to caller

TryAH1:
           CMP     AH,1                 ;AH=1?
           JNZ     Int16Orig            ;No, let original int 16 do it
AH1:
           OR      AH,10h               ;Use enhanced BIOS call instead
           CALL    PrevInt16            ;Call previous int 16 (pops flags)
           PUSHF                        ;Save result flags
           JZ      AH1Done              ;Just return if no key available
           OR      AH,AH                ;AH=0?
           JZ      AH1Done              ;Yes, done
           CMP     AL,0E0h              ;AL=E0h?
           JNZ     AH1Done              ;Yes, clear it
           XOR     AL,AL                ;Clear low byte of scan word
AH1Done:
           POPF                         ;Restore result flags
           POP     DS                   ;Restore registers
           POP     DX
           RET     2                    ;Return with flags intact

Int16Orig:
           POPF                         ;Restore flags
           POP     DS
           POP     DX
           JMP     PrevInt16            ;Let old int16 handle the rest
NewInt16   ENDP
;=============================================================================
LIMIT      EQU $
;=============================================================================
START:     MOV     AX,3516h             ;Get current int 16
           INT     21h
           MOV     PrevInt16Ofs,BX      ;Save it in CS-relative variables
           MOV     PrevInt16Seg,ES
           PUSH    DS
           PUSH    CS
           POP     DS
           MOV     DX,offset NewInt16
           MOV     AX,2516h             ;Install new int 16
           INT     21h
           POP     DS
           MOV     DX,offset LIMIT      ;Terminate, keeping everything
           INT     27H                  ;  preceding LIMIT resident
;*****************************************************************************
CODE       ENDS
           END ENHANCED
