; DBLCAP v1.0  CapsLock Fixer
; Copyright (c) 1993 by Dale Nurden

; This program is a TSR which watches the keyboard for presses of the
; CapsLock key, and works like this:
;
;  One press of CapsLock has no effect.
;  Two presses within a certain time (0.3 seconds) of each other work just
;   like the normal CapsLock function.
;
; In addition, pressing Ctrl-Alt-Backspace at any time will empty the
; keyboard buffer. This is useful if you type commands in advance and then
; change your mind.

; This source is released as is. The author makes no guarantees about its
; reliability, assemble-ility, or anything else. You may use portions of
; this source for your own purposes in shareware/freeware products, but I
; would appreciate it if you tell me about it, just so I know. I don't
; want anything in return, just to know that my work is useful to someone.
; A small note of credit to me would also be nice.
;
; Assembly information:
; Assembler: Turbo Assembler v3.1  [TASM DBLCAP.ASM /ZN /ML]
;    Linker: Turbo Linker v3.01    [TLINK DBLCAP.OBJ /T]


;=============================================================================

              .model small
              .code

CAPSLOCKmake  equ  3Ah                  ;CapsLock key make code
CAPSLOCKbreak equ  0BAh                 ;CapsLock key break code
BACKSPACEmake equ  0Eh                  ;Backspace key make code
BACKSPACEmask equ  00001100b            ;Ctrl-Alt shift mask

TIMEHI        equ  0004h                ;TIMEHI:TIMELO = maximum time (in microseconds)
TIMELO        equ  93E0h                ;between presses of CapsLock for it to trigger
                                        ;0004:93E0 = 0.3 seconds (300 000 microseconds)

SET           macro  byte,bit           ;Sets the specified bit in 'byte' to 1
              or   byte,(bit)
              endm
CLR           macro  byte,bit           ;Clears the specified bit in 'byte' to 0
              and  byte,not (bit)
              endm


;=============================================================================
; RESIDENT SECTION

              org  2Ch                  ;Environment starts here
Environment:

              org  80h                  ;Command line parameters start here
CommandLine:

              org  100h                 ;Program data and code starts here
DCAP:

              jmp  Install              ;Go and install the TSR

;-----------------------------------------------------------------------------
; RESIDENT DATA

OldInt9       dd   ?                    ;Old Int 9 handler vector

flags         db   10000001b            ;This byte is used for keeping various flags
MAKE          equ  00000001b            ;CapsLock has been pressed once
TIMER         equ  10000000b            ;Timer timeout flag


;-----------------------------------------------------------------------------
; RESIDENT CODE

Int9:         push ax
              in   al,60h               ;Get the keypress scan code
              cmp  al,CAPSLOCKmake      ;Is it CapsLock make code?
              je   int9_2
              cmp  al,CAPSLOCKbreak     ;Is it CapsLock break code?
              je   int9_5
              cmp  al,BACKSPACEmake     ;Is it Backspace?
              je   int9_6

int9_1:       pop  ax
              jmp  cs:OldInt9           ;Pass keypress on to ISR chain

              ;CapsLock make code received
int9_2:       test cs:flags,TIMER       ;Check timer flag for timeout
              jnz  int9_3               ;Set, so this is a first press of CapsLock

              SET  cs:flags,TIMER       ;Otherwise reset the timer flag
              jmp  int9_1               ;And pass on the keystroke

int9_3:       SET  cs:flags,MAKE        ;Indicate the first keypress

int9_4:       mov  al,20h               ;Acknowledge keyboard interrupt
              out  20h,al               ; to kill the keypress
              pop  ax
              iret                      ;Then end the ISR

              ;CapsLock break code received
int9_5:       test cs:flags,MAKE        ;Has a make code been seen before?
              jz   int9_1               ;No, so pass it on

              CLR  cs:flags,<MAKE or TIMER>  ;Clear the flags

              push ax
              push bx
              push cx
              push dx
              push es

              push cs
              pop  es
              mov  bx,offset flags
              mov  cx,TIMEHI            ;Event wait will set the
              mov  dx,TIMELO            ; flag after a certain time
              mov  ax,8300h
              int  15h                  ;Start the event wait

              pop  es
              pop  dx
              pop  cx
              pop  bx
              pop  ax

              jmp  int9_4               ;Kill the keypress

              ;Backspace make code received
int9_6:       mov  ah,12h
              int  16h                  ;Get keyboard shift status
              and  al,00001111b         ;And only look at bits 0-3
              cmp  al,BACKSPACEmask     ;Is it our shift mask?
              jne  int9_1               ;No, so pass it on

              ;Ctrl-Alt-Backspace received
int9_7:       mov  ah,11h               ;Test keyboard buffer
              int  16h                  ;Is there a key waiting?
              jz   int9_4               ;No, so stop now and kill the hotkey
              mov  ah,10h               ;Otherwise, remove it from the buffer
              int  16h
              jmp  int9_7               ;Now check for another key



EndTSR:


;=============================================================================
; NON_RESIDENT SECTION
; RESIDENT DATA

msg_header    db   13,10,"DBLCAP v1.0  CapsLock Fixer",13,10
              db   "              Copyright (c) 1994 by Dale Nurden",13,10,10
              db   "Press CAPSLOCK twice for it to be effective.",13,10
              db   "Press CTRL-ALT-BACKSPACE at any time to clear the keyboard buffer.",13,10,'$'

;-----------------------------------------------------------------------------
; NON-RESIDENT CODE

Install:      mov  ax,3509h
              int  21h                  ;Get the old Int 9 handler vector
              mov  word ptr OldInt9[0],bx
              mov  word ptr OldInt9[2],es  ;And save it

              mov  ax,2509h
              mov  dx,offset Int9
              int  21h                  ;Now install the new handler

              mov  ah,9
              mov  dx,offset msg_header
              int  21h                  ;Print the header message

              mov  ax,word ptr [Environment]
              mov  es,ax
              mov  ah,49h
              int  21h                  ;Release the environment

              mov  dx,offset EndTSR
              int  27h                  ;Go TSR and exit

              end  DCAP
