{************************************************************************
 *									*
 *  Unit AM_API	  ALTMENU API access module				*
 *  Public Domain 1996 Pino Navato					*
 *									*
 ************************************************************************}

Unit AM_API;		{ ** BP 7+ required ** }
{$X+}

interface

function Search4AltMenu : word;
function GetKCptr : pointer;


implementation

uses Strings, DOS;


const AMIS_INSTCHECK	 = 0;  	       { installation check }
      ALTMENU_GET_KC_PTR = $10;	       { get pointer to key code }

      AMIS_SUCCESSFUL	 = $FF;

      AM_SIG : PChar = 'Pino NavALTMENU ';   { ALTMENU's AMIS signature }


var mpx        : byte;
    regs       : registers;
    sig        : PChar;		  { generic AMIS signature }


{ +-----  Search4AltMenu  ----------------------------------------------+
  |  Purpose:	Search for the presence of ALTMENU in memory.		|
  |  Note:	This function sets the global variable mpx used		|
  |		by GetKCptr.						|
  |  Return:	Version number if found, 0 if not found.		|
  +---------------------------------------------------------------------+ }

function Search4AltMenu: word;
   { loop through all 256 multiplex numbers, checking signatures we find }
   begin
      for mpx := 0 to 255 do
	 begin
	    regs.ah := mpx;
	    regs.al := AMIS_INSTCHECK;		{ installation check }
	    intr($2D, regs);
	    if regs.al = AMIS_SUCCESSFUL then	{ installed? }
	       begin
		  sig := ptr(regs.dx, regs.di);
		  if StrComp(sig, AM_SIG) = 0 then   { ALTMENU? }
		     begin
			Search4AltMenu := regs.cx; { YES! Return version num. }
			exit
		     end
	       end
	 end;
      Search4AltMenu := 0
   end;



{ +-----  GetKCptr  ----------------------------------------------------+
  |  Purpose:	Get a far pointer to ALTMENU key code.			|
  |  Return:	Far pointer to ALTMENU key code or NIL if ALTMENU not	|
  |		installed.						|
  +---------------------------------------------------------------------+ }

function GetKCptr: pointer;
   begin
      if Search4AltMenu = 0 then
	 GetKCptr := nil
      else
	 begin
	    regs.ah := mpx;
	    regs.al := ALTMENU_GET_KC_PTR;
	    intr($2D, regs);
	    GetKCptr := ptr(regs.dx, regs.bx)
	 end
   end;


end.
