/************************************************************************
 *									*
 *  AM_API.C   ALTMENU API access module				*
 *  Public Domain 1996 Pino Navato					*
 *									*
 ************************************************************************/

#include <dos.h>
#include <string.h>

#define AMIS_INSTCHECK	    0  	       /* installation check */
#define ALTMENU_GET_KC_PTR  0x10       /* get pointer to key code */

#define AMIS_SUCCESSFUL     0xFF


static int mpx;
static union REGS regs;


/*
  +-----  search4altmenu()  --------------------------------------------+
  |  Purpose:	Search for the presence of ALTMENU in memory.		|
  |  Note:	This function sets the global variable mpx used		|
  |		by get_kc_ptr().					|
  |  Return:	Version number if found, 0 if not found.		|
  +---------------------------------------------------------------------+
*/
unsigned search4altmenu(void)
   {
   char far *sig;				/* generic AMIS signature */
   const char far *AM_SIG = "Pino NavALTMENU "; /* ALTMENU's AMIS signature */

   for (mpx = 0 ; mpx <= 255 ; mpx++)
      {
      regs.h.ah = mpx;
      regs.h.al = AMIS_INSTCHECK;		/* installation check */
      int86(0x2D, &regs, &regs);
      if (regs.h.al == AMIS_SUCCESSFUL)		/* installed? */
	 {
	 sig = (char far *) MK_FP(regs.x.dx, regs.x.di);
	 if (_fstrcmp(sig, AM_SIG) == 0)  /* ALTMENU? */
	    return regs.x.cx;	  /* YES! Return version number */
	 }
      }
   return 0;
   }


/*
  +-----  get_kc_ptr()  ------------------------------------------------+
  |  Purpose:	Get a far pointer to ALTMENU key code.			|
  |  Return:	Far pointer to ALTMENU key code or NULL if ALTMENU not	|
  |		installed.						|
  +---------------------------------------------------------------------+
*/
unsigned int far *get_kc_ptr(void)
   {
   if (search4altmenu() == 0)
      return NULL;

   regs.h.ah = mpx;
   regs.h.al = ALTMENU_GET_KC_PTR;
   int86(0x2D, &regs, &regs);
   return (unsigned int far *) MK_FP(regs.x.dx, regs.x.bx);
   }
