;************************************************************************
;*									*
;*  ALTMENU	Activate the menu bar of any program by pressing	*
;*		the Alt key alone.					*
;*									*
;*  Copyright 1995, 1996 Pino Navato					*
;*									*
;*  You can freely use and distribute this program.			*
;*  It's cardware: if you find it useful, send me a postcard.		*
;*									*
;*									*
;*  My Fidonet address is 2:335/225.18 (The Bits BBS)			*
;*									*
;*  Send your postcard to:						*
;*									*
;*	Pino Navato							*
;*	Via Pittore, 164						*
;*	80046 S.Giorgio a Cremano (NA)					*
;*	ITALY								*
;*									*
;************************************************************************


.286					;Usa codice 286.

__TINY__	=	1		;Usa il modello TINY.


		INCLUDE	AMIS.MAC	;Include la libreria di Ralf.

		@Startup		;Macro che fornisce codice di startup.


VERSION_NUM	=	0100h		;Versione 2
VERSION_STR	equ	"2"

ALT_PRESSED	=	38h			;Scan code di Alt (pressione).
ALT_RELEASED	=	ALT_PRESSED or 128	;Scan code di Alt (rilascio).
PAUSE_FLAG	=	8


bios_data_seg	segment at 40h
		org	18h

ext_shift_st	db	?		;Contiene il flag del tasto Pausa.

bios_data_seg	ends


;------------------------------ Codice residente -------------------------------

TSRcode@

		HOOKED_INTS  09h
		ALTMPX	     'Pino Nav','ALTMENU',VERSION_NUM,,,Y
		ISP_HEADER   09h,hw_reset_2Dh


entry_point:	pusha
		push	ds

		push	bios_data_seg
		pop	ds
		assume	ds:bios_data_seg

		test	ext_shift_st,PAUSE_FLAG	;Se  in pausa...
		jnz	exit			;...ignora il tasto.

		push	cs
		pop	ds
		assume	ds:TGROUP
		
		in	al,60h			;Legge scan code.

check1:		cmp	al,ALT_PRESSED
		jne	check2
		mov	al,ENABLED
		jmp	store_and_exit
		
check2:		cmp	alt_checking,ENABLED
		jne	exit
		cmp	al,ALT_RELEASED
		je	simulate
		cmp	al,0E0h
		je	exit
		mov	al,DISABLED

store_and_exit: mov	alt_checking,al		
exit:		pop	ds
		popa
		jmp	cs:ORIG_INT09h
		
simulate:	mov	cx,key_code
		jcxz	exit
		mov	ah,5
		int	16h
		jmp	exit


;----------------------------- Area dati residenti -----------------------------

ENABLED		=	1
DISABLED	=	0

key_code	dw	?		;high = scan code, low = ASCII code.
alt_checking	db	DISABLED


TSRcodeEnd@


;-------------------------- Fine del codice residente --------------------------
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
;-------------------------- Inizio codice transiente ---------------------------

_TEXT		segment 'CODE'
		assume	cs:_TEXT,ds:NOTHING,es:NOTHING,ss:NOTHING

inst_mode	db	USE_TOPMEM	;Modo d'installazione di default.


;-------------------------- Messaggi da visualizzare ---------------------------

banner_msg	db	13,10, 'ALTMENU v.', VERSION_STR, '  '
		db	 'Copyright 1995, 1996 Pino Navato'
		db	13,10, '$'

sintax_msg	db	13,10, 'Usage:  ALTMENU <key_code> [/L|/NT]   '
		db	   'install in memory'
		db	13,10, 9, 'ALTMENU /R', 9,9, '      remove from memory'
		db	13,10, 13,10
		db	   'Read ALTMENU.ENG or ALTMENU.ITA for further infos.'
		db	13,10, '$'

unknown_param_msg db	13,10, 'Unknown parameter.'
		  db	13,10, '$'

bad_hex_msg:	db	13,10, 'Parameter key_code not valid.'
		db	13,10, '$'

no_key_code_msg	db	13,10, 'Parameter key_code not supplied.'
		db	13,10, '$'

uninstalled_msg db	13,10, 'ALTMENU removed from memory.'
		db	13,10, '$'

cant_remove_msg db	13,10, "Can't remove ALTMENU.  Now disabled."
		db	13,10, '$'

not_installed_msg db	13,10, 'ALTMENU not installed.'
		  db	13,10, '$'


;-------------------------- Gestione riga di comando ---------------------------

		@Startup2  Y
		
		push	ds
		pop	es
		assume	es:_INIT

		push	cs
		pop	ds
		assume	ds:_TEXT

		mov	bx,1000h
		mov	ah,4Ah
		int	21h

		mov	si,81h			;SI -> command line.
		call	search_param

		cmp	al,13			;Nessun parametro?
		jne	analyse_param
show_sintax:	DISPLAY_STRING banner_msg
		DISPLAY_STRING sintax_msg
		mov	ax,4C00h
		int	21h

analyse_param:	call	get_hex_word
		jc	hex_failed

		IF_INSTALLED already_installed
		push	ds
		mov	ds,TGROUP@
		assume	ds:TGROUP
		mov	key_code,bx
		pop	ds
		assume	ds:_TEXT

		call	search_param
		cmp	al,13
		je	install
		db	26h,0ACh		;lodsb es:
		and	al,0DFh 		;Converte in maiuscola.
		cmp	al,'L'
		jne	cmp_with_N
		mov	inst_mode,LOW_ONLY	;Installazione tradizionale.
		jmp	install
cmp_with_N:	cmp	al,'N'
		je	get_next_char
		jmp	unknown_param
get_next_char:	db	26h,0ACh		;lodsb es:
		and	al,0DFh			;Converte in maiuscola.
		cmp	al,'T'
		je	inst_mode_NT
		jmp	unknown_param
inst_mode_NT:	mov	inst_mode,NO_TOPMEM	;Installazione "No Top".
		jmp	install
		
hex_failed:	cmp	bx,4
		je	check_R_and_U

bad_hex:	mov	dx,offset bad_hex_msg
		jmp	exit_with_error

check_R_and_U:	db	26h,0ACh		;lodsb es:
		and	al,0DFh 		;Converte in maiuscola.
		cmp	al,'R'
		je	remove
		cmp	al,'U'			;Accetta anche U ("Uninstall").
		je	remove
		mov	dx,offset no_key_code_msg
		jmp	exit_with_error


;-------------------------- Installa/disintalla ecc. ---------------------------

install:	INSTALL_TSR ,BEST,,inst_notify,,,inst_mode

inst_notify:	DISPLAY_STRING banner_msg
		ret

unknown_param:	mov	dx,offset unknown_param_msg
		jmp short exit_with_error

remove: 	UNINSTALL cant_uninstall
		push	cs
		pop	ds
		DISPLAY_STRING uninstalled_msg
exit_no_error:	mov	ax,4C00h
		int	21h

cant_uninstall: IF_INSTALLED disable_altmenu
		mov	dx,offset not_installed_msg
		jmp short exit_with_error

disable_altmenu:
		mov	al,10h
		int	2Dh
		push	ds
		mov	ds,dx
		mov	word ptr ds:[bx],0000h	;Disabilita ALTMENU.
		pop	ds
		mov	dx,offset cant_remove_msg

exit_with_error:
		mov	ah,9
		int	21h
		mov	ax,4C01h
		int	21h

already_installed:
		mov	cx,bx
		mov	al,10h
		int	2Dh
		push	ds
		mov	ds,dx
		mov	ds:[bx],cx	;Aggiorna key_code.
		pop	ds
		call	inst_notify
		jmp	exit_no_error


;-------------------------------- Subroutines ----------------------------------

;Subroutine SEARCH_PARAM: ricerca il prossimo parametro sulla riga di comando.
;
; -- input:	ES:SI -> carattere dal quale iniziare la ricerca.
; -- return:	ES:SI -> primo carattere del parametro.
;		AL    =  primo carattere del parametro.

search_param:	cld
cmdline_loop:	db	26h,0ACh		;lodsb es:
		cmp	al,' '			;Scarta spazi e TABs.
		je	cmdline_loop
		cmp	al,9
		je	cmdline_loop
		cmp	al,'/'			;C' uno slash?
		jne	end_search_par
		db	26h,0ACh		;Scarta lo slash (lodsb es:).
end_search_par: dec	si
		ret


;Subroutine GET_HEX_WORD: converte una stringa di 4 caratteri hex in una word.
;
; -- input:	ES:SI -> primo carattere della stringa.
; -- return:	CF = 0 successo
;		   BX = word
;		   ES:SI -> carattere dopo la word.
;		CF = 1 carattere non valido nella stringa.
;		   ES:SI -> carattere non valido.
;		   BX = 4 se  il primo carattere.

get_hex_word:	push	ax cx
		mov	cx,4
		cld

ghw_loop:	db	26h,0ACh		;lodsb es:
		cmp	al,'0'
		jb	bad_digit
		cmp	al,'9'
		ja	try_letter
		sub	al,'0'
		jmp	add_digit

try_letter:	and	al,0DFh 		;Converte in maiuscola.
		cmp	al,'A'
		jb	bad_digit
		cmp	al,'F'
		ja	bad_digit
		sub	al,'A'-10

add_digit:	shl	bx,4
		or	bl,al
		loop	ghw_loop
;		clc
		pop	cx ax
		ret

bad_digit:	dec	si
		stc
		mov	bx,cx
		pop	cx ax
		ret
		

_TEXT		ENDS

		end	INIT
