/*****************************************************************************
*   Routines to set and handle the scaling of the drawing:                   *
*                                                                            *
* Written by:  Gershon Elber                           Ver 0.2, Apr. 1989    *
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <graphics.h>
#include "Expr2TrG.h"
#include "Program.h"
#include "GraphGnG.h"

static void UpdateScaleFlags(MenuItem *SetScaleMenu,
	double Xmin, double Xmax, double Ymax, int NumOfSamples,
	int AutoScaleFlag, double DomainMin, double DomainMax);

/*****************************************************************************
*   Main routine of the SetScale module - set the Menu and call the          *
* requested routines.                                                        *
*****************************************************************************/
void DoSetScale(double *Xmin, double *Xmax, double *Ymax, int *NumOfSamples,
	int *AutoScaleFlag, double *DomainMin, double *DomainMax)
{
    static struct MenuItem SetScaleMenu[] = {		   /* Load Data Menu */
        YELLOW,	"Set Scale",
	MAGENTA, "                ",	   /* Used as Auto/Fixed scale modes */
	MAGENTA, "Set Xmin=         ",	       /* Updated to real values ... */
	MAGENTA, "Set Xmax=         ",	          /* In UpdateFlags routine. */
        MAGENTA, "Set Ymax=         ",
	GREEN,	"Set Samples=      ",	  /* Set number of samples per func. */
	MAGENTA, "Set Tmin=         ",
	MAGENTA, "Set Tmax=         ",
        CYAN,	"Help",
        BLUE,	"Exit"
    };
    int select;
    char s[LINE_LEN];
    double Rtemp;

    while (TRUE) {
	UpdateScaleFlags(SetScaleMenu, *Xmin, *Xmax, *Ymax, *NumOfSamples,
				*AutoScaleFlag, *DomainMin, *DomainMax);
	GGMenuDraw(9, SetScaleMenu, TRUE);			/* Draw Menu */
	select = GGMenuPick();

        switch (select) {
	    case 1:			  /* Toggle Auto/Fixed scaling modes */
                *AutoScaleFlag = !*AutoScaleFlag;
                break;
	    case 2:						 /* Set Xmin */
		sprintf(s, "%lf", *Xmin);
		GetLine("Enter New Xmin:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp < *Xmax))
                    *Xmin = Rtemp;
		else GGPutErrorMsg("Wrong Format/Range");
                break;
	    case 3:						 /* Set Xmax */
		sprintf(s, "%lf", *Xmax);
		GetLine("Enter New Xmax:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp > *Xmin))
                    *Xmax = Rtemp;
		else GGPutErrorMsg("Wrong Format/Range");
                break;
	    case 4:						 /* Set Ymax */
		sprintf(s, "%lf", *Ymax);
		GetLine("Enter New Ymax:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp > 0))
                    *Ymax = Rtemp;
		else GGPutErrorMsg("Wrong Format/Range");
                break;
	    case 5:		       /* Set number of samples per function */
		sprintf(s, "%d", *NumOfSamples);
		GetLine("New NumOfSamples:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp >= 2) &&
                         (Rtemp <= 1000)) *NumOfSamples = (int) Rtemp;
		else GGPutErrorMsg("Wrong Format/Range");
                break;
	    case 6:			/* Set Minimum of function(s) domain */
		sprintf(s, "%lf", *DomainMin);
		GetLine("Enter Domain Min.:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp < *DomainMax))
                    *DomainMin = Rtemp;
		else GGPutErrorMsg("Wrong Format/Range");
                break;
	    case 7:			/* Set Maximum of function(s) domain */
		sprintf(s, "%lf", *DomainMax);
		GetLine("Enter Domain Max.:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp > *DomainMin))
                    *DomainMax = Rtemp;
		else GGPutErrorMsg("Wrong Format/Range");
                break;
	    case 8:						     /* Help */
		GGPrintHelpMenu("DrawFunc.hlp", "SETSCALE");
                break;
	    case 9:						     /* Exit */
                return;
        }
    }
}

/*****************************************************************************
*   Routine to update the EditMenu status according to flags :               *
*****************************************************************************/
static void UpdateScaleFlags(MenuItem *SetScaleMenu,
	double Xmin, double Xmax, double Ymax, int NumOfSamples,
	int AutoScaleFlag, double DomainMin, double DomainMax)
{
    static char *AutoScaleMode   = "Auto Scale Mode";
    static char *FixedScaleMode  = "Fixed Scale Mode";

    if (AutoScaleFlag) strcpy(SetScaleMenu[1].string, AutoScaleMode);
    else               strcpy(SetScaleMenu[1].string, FixedScaleMode);

    sprintf(SetScaleMenu[2].string, "Set Xmin=%7lg", Xmin);
    sprintf(SetScaleMenu[3].string, "Set Xmax=%7lg", Xmax);
    sprintf(SetScaleMenu[4].string, "Set Ymax=%7lg", Ymax);

    sprintf(SetScaleMenu[5].string, "Set Samples=%4d", NumOfSamples);

    sprintf(SetScaleMenu[6].string, "Set Dmin=%7lg", DomainMin);
    sprintf(SetScaleMenu[7].string, "Set Dmax=%7lg", DomainMax);
}
