
/*****************************************************************************
* The local constants -	should be available only to expr2tree.c	module.	     *
*****************************************************************************/

#ifndef EXPR_2_TREE_LH
#define EXPR_2_TREE_LH

#define MAX_PARSER_STACK	100	      /* Depth of expression nesting */

/*****************************************************************************
* General definitions goes here:					     *
*****************************************************************************/

#define	TAB		9

#ifndef LINE_LEN
#define	LINE_LEN	255
#endif	LINE_LEN

#ifndef TRUE
#define TRUE		-1
#define FALSE		0
#endif

#ifndef INFINITY
#define INFINITY  1e10
#endif  INFINITY

#ifndef MIN
#define MIN(x, y)		((x) > (y) ? (y) : (x))
#define MAX(x, y)		((x) > (y) ? (x) : (y))
#endif  MIN

/*****************************************************************************
* Tokens used in the expression	to tree	conversion and tree definition.	     *
*****************************************************************************/

#define	ABS	    10 /* Functions */
#define	ARCCOS	    11
#define	ARCSIN	    12
#define	ARCTAN	    13
#define	COS	    14
#define	EXP	    15
#define	LN	    16
#define	LOG	    17
#define	SIN	    18
#define	SQR	    19
#define	SQRT	    20
#define	TAN	    21

#define	PLUS	    30 /* Operators */
#define	MINUS	    31
#define	MULT	    32
#define	DIV	    33
#define MODULU	    34
#define	POWER	    35
#define	UNARMINUS   36
#define MINIMUM	    37
#define MAXIMUM	    38

#define	OPENPARA    40 /* Paranthesis */
#define	CLOSPARA    41

#define	NUMBER	    50 /* Numbers (or parameter) */
#define	PARAMETER   51

#define	TOKENERROR  -1
#define TOKENSTART  60
#define TOKENEND    61

/*****************************************************************************
* The local function (static) prototypes:				     *
*****************************************************************************/

/*****************************************************************************
* The local constants -	should be available only to expr2tree.c	module.	     *
*****************************************************************************/

#ifndef EXPR_2_TREE_LH
#define EXPR_2_TREE_LH

#define MAX_PARSER_STACK	100	      /* Depth of expression nesting */

/*****************************************************************************
* General definitions goes here:					     *
*****************************************************************************/

#define	TAB		9

#ifndef LINE_LEN
#define	LINE_LEN	255
#endif	LINE_LEN

#ifndef TRUE
#define TRUE		-1
#define FALSE		0
#endif

#ifndef INFINITY
#define INFINITY  1e10
#endif  INFINITY

#ifndef MIN
#define MIN(x, y)		((x) > (y) ? (y) : (x))
#define MAX(x, y)		((x) > (y) ? (x) : (y))
#endif  MIN

/*****************************************************************************
* Tokens used in the expression	to tree	conversion and tree definition.	     *
*****************************************************************************/

#define	ABS	    10 /* Functions */
#define	ARCCOS	    11
#define	ARCSIN	    12
#define	ARCTAN	    13
#define	COS	    14
#define	EXP	    15
#define	LN	    16
#define	LOG	    17
#define	SIN	    18
#define	SQR	    19
#define	SQRT	    20
#define	TAN	    21

#define	PLUS	    30 /* Operators */
#define	MINUS	    31
#define	MULT	    32
#define	DIV	    33
#define MODULU	    34
#define	POWER	    35
#define	UNARMINUS   36
#define MINIMUM	    37
#define MAXIMUM	    38

#define	OPENPARA    40 /* Paranthesis */
#define	CLOSPARA    41

#define	NUMBER	    50 /* Numbers (or parameter) */
#define	PARAMETER   51

#define	TOKENERROR  -1
#define TOKENSTART  60
#define TOKENEND    61

/*****************************************************************************
* The local function (static) prototypes:				     *
*****************************************************************************/
static ExprNode *MyExprMalloc(void);
static void MyExprFree(ExprNode *Ptr);
static void MakeUpper(char *s);
static ExprNode *OperatorPrecedence(char *s, int *i);
static int TestPreceeding(int Token1, int Token2);
static int GetToken(char *s, int *i, double *Data);
static void LocalPrintTree(ExprNode *Root, int Level, char *Str);

#ifdef DERIVATIVE
static ExprNode *DerivTree1(ExprNode *Root, int Param);
static ExprNode *Gen1u2Tree(int Sign1, int Sign2, double Exponent,
							ExprNode *Expr);
static ExprNode *Optimize(ExprNode *Root, int *Flag);
#endif DERIVATIVE

#endif EXPR_2_TREE_LH
static ExprNode *MyExprMalloc(void);
static void MakeUpper(char *s);
static ExprNode *OperatorPrecedence(char *s, int *i);
static int TestPreceeding(int Token1, int Token2);
static int GetToken(char *s, int *i, double *Data);
static void LocalPrintTree(ExprNode *Root, int Level, char *Str);

#ifdef DERIVATIVE
static ExprNode *DerivTree1(ExprNode *Root, int Param);
static ExprNode *Gen1u2Tree(int Sign1, int Sign2, double Exponent,
							ExprNode *Expr);
static ExprNode *Optimize(ExprNode *Root, int *Flag);
#endif DERIVATIVE

#endif EXPR_2_TREE_LH
