/* Copyright (C) 1981,1982, 1983 by Manx Software Systems */
/* modified by Kent Williams to support file name wild card expansion */
#include <errno.h>
#include <fcntl.h>
#ifndef NULL
#define NULL ((void *)0)
#endif

char *sbrk();
void abort();
#define ARGMAX 32
static char *Argv[ARGMAX];
static int argvsize;
static int Argc;

noper()
{
	return 0;
}

int (*cls_)() = noper;
extern char _ioflg[];

Croot(cp, first)
register char *cp;
{
	register char *cp2;

	_ioflg[0] = isatty(0);	/* set flag for i/o routines */
	_ioflg[1] = isatty(1);	/* set flag for i/o routines */
	_ioflg[2] = isatty(2);	/* set flag for i/o routines */


	/* Null out first argument */
	Argv[0] = "";
	Argc = first;

	/* loop through arguments */
	for (;;) 
	{
		/* skip blanks */
		while (*cp == ' ' || *cp == '\t')
			++cp;

		/* if you're at the end of command line, you're done */
		if (*cp == 0)
			break;
		/* if you hit a quote, next arg starts after matching close quote */
		if (*cp == '"' || *cp == '\'')
		{
			char quotechar = *cp;
			cp2 = ++cp; /* save ptr to the string after quote */
			while(*++cp2)
			{
				if (*cp2 == quotechar)
				{
					*cp2++ = 0;
					goto noexpand;	/* don't want to trip on wildcards */
				}
			}
		} else /* assume args terminated by white space */
		{
			/* find beginning of next argument */
			cp2 = cp;	/* save original pointer to the string */
			*cp2 = (*cp2 == '/' ? '\\' : *cp2);
			while (*++cp2)
			{
				/* if you hit a space char - stick a null in to terminate last
				   argument
				 */
				if (*cp2 == ' ' || *cp2 == '\t') 
				{
					*cp2++ = 0;
					break;
				}
			}
		}
noexpand:
		/* update the next argv pointer */
		Argv[Argc] = cp;
		/* bump the argument count */
		if (++Argc == ARGMAX)
			abort();
		cp = cp2;	/* point to beginning of next argument */
	}
	Argv[Argc] = NULL;	
	main(Argc,Argv);
	exit(0);
}

static void abort()
{
	write(2, "Too many args.", 14);
	_exit(200);
}

exit(code)
{
	(*cls_)();
	_exit(code);
}

