PROGRAM X_Plot;
{
Demonstration of how to plot a graph in a "canvas" in XView-PC.
By Antonio Carlos Moreirao de Queiroz - acmq@coe.ufrj.br
Compile with Turbo Pascal 7.0, using the units XVIEW.TPU e MICKEY.TPU.
}

USES Graph,Crt,XView;

{Interface objects}
VAR
  MenuPrincipal,MenuGrafico:Xv_opaque;
  fmensagens,tmsg:Xv_opaque;
  fescalas,bplotar,tymax,tymin,txmax,txmin,tpontos:Xv_opaque;
  fEscreverArquivo,tEscreverArquivo:Xv_opaque;
  fLerArquivo,tLerArquivo:Xv_opaque;
  fprincipal,cgrafico:Xv_opaque;

CONST
  versao='1.1 - 20/04/94';
  pontos0=400;                   {Maximum number of points in the graph}
  xmin0=0;                       {Initial limits}
  xmax0=50;
  ymin0=-1;
  ymax0=1;
  grafico_valido:BOOLEAN=FALSE;  {If the graph is valid}
  ultimo:INTEGER=0;              {Last computed point}

VAR
  xmin,xmax,ymin,ymax:INTEGER;    {Limits in pixels of the graph}
  cursor:INTEGER;                 {Cursor position in pixels}
  ax,bx,ay,by,delta:REAL;         {Mapping constants}
  gx,gy:ARRAY[1..pontos0] OF REAL;{X and Y values}
  {It is not necessary to save X, but is simpler}

FUNCTION Sre(x:REAL; cm,dc:INTEGER):STRING;
VAR
  txt:STRING;
BEGIN
  Str(x:cm:dc,txt);
  Sre:=txt
END;

{$F+}

{Callbacks}

PROCEDURE EscreverArquivo(obj:Xv_opaque);
BEGIN
  {Notify handler for tEscreverArquivo}
  ttysw_output(tmsg,'Would be written the file '+tEscreverArquivo^.panel_value+^M^J);
END;

PROCEDURE LerArquivo(obj:Xv_opaque);
BEGIN
  {Notify handler for tLerArquivo}
  ttysw_output(tmsg,'Would be read the file '+tLerArquivo^.panel_value+^M^J);
END;

PROCEDURE DesenharGrafico(obj:Xv_opaque);
VAR
  i,xg,yg:INTEGER;
  x,y:REAL;
BEGIN
  {Notify handler for cgrafico}
  IF obj<>cgrafico THEN BEGIN
    SetFillStyle(SolidFill,cgrafico^.back_color);
    Bar(0,0,cgrafico^.dx,cgrafico^.dy);
  END;
  IF not grafico_valido THEN ultimo:=0;
  {Eixos}
  SetColor(cgrafico^.fore_color);
  Line(60,10,60,cgrafico^.dy-12);
  Line(60,cgrafico^.dy-12,cgrafico^.dx-10,cgrafico^.dy-12);
  SetTextJustify(RightText,TopText);
  OutTextXY(60,10,Sre(tymax^.panel_real,5,2));
  SetTextJustify(RightText,BottomText);
  OutTextXY(60,cgrafico^.dy-10,Sre(tymin^.panel_real,5,2));
  SetTextJustify(RightText,TopText);
  OutTextXY(cgrafico^.dx-10,cgrafico^.dy-10,Sre(txmax^.panel_real,5,2));
  SetTextJustify(LeftText,TopText);
  OutTextXY(60,cgrafico^.dy-10,Sre(txmin^.panel_real,5,2));
  {Mapping}
  xmin:=60;
  xmax:=cgrafico^.dx-10;
  ymin:=10;
  ymax:=cgrafico^.dy-12;
  ay:=(ymax-ymin)/(tymin^.panel_real-tymax^.panel_real);
  by:=ymax-ay*tymin^.panel_real;
  ax:=(xmax-xmin)/(txmax^.panel_real-txmin^.panel_real);
  bx:=xmax-ax*txmax^.panel_real;
  {Calculation and plotting}
  cursor:=-10;
  grafico_valido:=TRUE;
  delta:=(txmax^.panel_real-txmin^.panel_real)/(tpontos^.panel_int-1);
  x:=txmin^.panel_real;
  FOR i:=1 TO tpontos^.panel_int DO BEGIN
    IF i>ultimo THEN BEGIN {Only calculates if necessary}

      {----------------}

      {The plotted function is here}

      y:=exp(-x/10)*Sin(x);

      {----------------}

      gy[i]:=y;
      gx[i]:=x;
    END;
    xg:=Round(ax*gx[i]+bx);
    yg:=Round(ay*gy[i]+by);
    IF i>1 THEN LineTo(xg,yg) ELSE MoveTo(xg,yg);
    x:=x+delta;
    IF KeyPressed THEN BEGIN
      ultimo:=i;
      Exit;
    END;
  END;
  ultimo:=tpontos^.panel_int;
END;

PROCEDURE TratarEventos(obj:Xv_opaque);
VAR
  i:INTEGER;
BEGIN
  {Event handler for cgrafico}
  IF grafico_valido and (ie_shiftcode=1) THEN
    {Finds the closest point}
    i:=Round(1.0*(tpontos^.panel_int-1)*(ie_locx-xmin)/(xmax-xmin))+1;
    IF (i>=1) and (i<=ultimo) THEN BEGIN
      {Draws the cursor}
      SetWriteMode(XorPut);
      SetColor(c_white);
      Line(cursor,ymin,cursor,ymax);
      cursor:=Round(ax*gx[i]+bx);
      Line(cursor,ymin,cursor,ymax);
      SetWriteMode(NormalPut);
      SetFillStyle(SolidFill,cgrafico^.back_color);
      SetColor(cgrafico^.fore_color);
      Bar3d(cgrafico^.dx-76,7,cgrafico^.dx-10,25,0,FALSE);
      OutTextXY(cgrafico^.dx-74,9,'X:'+Sre(gx[i],5,2));
      OutTextXY(cgrafico^.dx-74,17,'Y:'+Sre(gy[i],5,2));
    END;
END;

PROCEDURE TratarMenuPrincipal(obj:Xv_opaque);
BEGIN
  {Notify handler for MenuPrincipal}
  CASE obj^.sel_menu OF
    1:{Read data}
      open_window(fLerArquivo);
    2:{Write data}
      open_window(fEscreverArquivo);
    3:{Set scales}
      open_window(fescalas);
    4:{Messages}
      open_window(fMensagens);
    5:{Informations}
      BEGIN
        ttysw_output(tmsg,'Demostration: How to plot a graph in'+
        ' linear scale using the XView-PC interface'^M^J);
        ttysw_output(tmsg,'By Antonio Carlos Moreirao de Queiroz'^M^J);
        ttysw_output(tmsg,'COPPE/EE/UFRJ - Version '+versao+^M^J);
      END;
    6:{Quit}
      xv_end:=TRUE;
  END;
END;

PROCEDURE TratarMenuGrafico(obj:Xv_opaque);
BEGIN
  {Notify handler for MenuGrafico}
  CASE obj^.sel_menu OF
    1:{Set Scales}
      open_window(fescalas);
    2:{Main menu}
      ttysw_output(tmsg,'Press the right button to access the submenu'^M^J);
  END;
END;

PROCEDURE Plotar(obj:Xv_opaque);
BEGIN
  {Notify handler for bplotar}
  WHILE active_w<>fprincipal DO close_window(active_w);
  DesenharGrafico(nil);
END;

PROCEDURE InvalidarGrafico(obj:Xv_opaque);
BEGIN
  {Notify handler for txmax and txmin}
  grafico_valido:=FALSE;
END;

{$F-}

BEGIN
  {Inicialization}
  xv_init(0,0);
  {Menus}
  {Menu for fmensagens, fEscreverArquivo, fLerArquivo, and fprincipal}
  MenuPrincipal:=xv_create(menu);
  WITH MenuPrincipal^ DO BEGIN
    xv_label:='Menu:';
    item_create('read data');
    item_create('write data');
    item_create('set scales');
    item_create('messages');
    item_create('informations');
    item_create('quit');
    notify_handler:=TratarMenuPrincipal;
  END;
  {Menu for cgrafico}
  MenuGrafico:=xv_create(menu);
  WITH MenuGrafico^ DO BEGIN
    xv_label:='Options:';
    item_create('set scales');
    item_create('main menu');
    notify_handler:=TratarMenuGrafico;
    item_submenu[2]:=MenuPrincipal;
  END;
  {Creation of the interface objects}
  fescalas:=xv_create(frame);
  WITH fescalas^ DO BEGIN
    xv_label:='Scales';
    x:=320;
    y:=23;
    dx:=250;
    dy:=114;
  END;
  bplotar:=xv_create(button);
  WITH bplotar^ DO BEGIN
    xv_label:='Plot';
    y:=75;
    notify_handler:=Plotar;
  END;
  tpontos:=xv_create(textfield);
  WITH tpontos^ DO BEGIN
    xv_label:='points';
    field_type:=int_field;
    panel_int:=pontos0;
    max_value:=pontos0;
    min_value:=2;
    y:=60;
    notify_handler:=InvalidarGrafico;
  END;
  tymax:=xv_create(textfield);
  WITH tymax^ DO BEGIN
    xv_label:='y maximum';
    y:=45;
    field_type:=real_field;
    panel_real:=ymax0;
  END;
  tymin:=xv_create(textfield);
  WITH tymin^ DO BEGIN
    xv_label:='y minimum';
    y:=30;
    field_type:=real_field;
    panel_real:=ymin0;
  END;
  txmax:=xv_create(textfield);
  WITH txmax^ DO BEGIN
    xv_label:='x maximum';
    y:=15;
    field_type:=real_field;
    panel_real:=xmax0;
    notify_handler:=InvalidarGrafico;
  END;
  txmin:=xv_create(textfield);
  WITH txmin^ DO BEGIN
    xv_label:='x minimum';
    field_type:=real_field;
    panel_real:=xmin0;
    notify_handler:=InvalidarGrafico;
  END;
  fmensagens:=xv_create(frame);
  WITH fmensagens^ DO BEGIN
    xv_label:='Messages';
    x:=6;
    y:=111;
    dx:=319;
    dy:=159;
    menu_name:=MenuPrincipal;
  END;
  tmsg:=xv_create(tty);
  fEscreverArquivo:=xv_create(frame);
  WITH fEscreverArquivo^ DO BEGIN
    xv_label:='Write File';
    x:=6;
    y:=67;
    dx:=319;
    dy:=43;
    dymin:=27;
    menu_name:=MenuPrincipal;
  END;
  tEscreverArquivo:=xv_create(textfield);
  WITH tEscreverArquivo^ DO BEGIN
    xv_label:='File';
    value_length:=30;
    notify_handler:=EscreverArquivo;
    owner^.mouse_obj:=tEscreverArquivo;
  END;
  fLerArquivo:=xv_create(frame);
  WITH fLerArquivo^ DO BEGIN
    xv_label:='Read File';
    x:=6;
    y:=23;
    dx:=319;
    dy:=43;
    dymin:=27;
    menu_name:=MenuPrincipal;
  END;
  tLerArquivo:=xv_create(textfield);
  WITH tLerArquivo^ DO BEGIN
    xv_label:='File';
    value_length:=30;
    notify_handler:=LerArquivo;
    owner^.mouse_obj:=tLerArquivo;
  END;
  fprincipal:=xv_create(frame);
  WITH fprincipal^ DO BEGIN
    xv_label:='X_Plot Demonstration Program';
    dx:=GetMaxX;
    dy:=GetMaxY;
    menu_name:=MenuPrincipal;
    adjust_exit:=FALSE;
    mouse_obj:=fprincipal;
  END;
  cgrafico:=xv_create(canvas);
  WITH cgrafico^ DO BEGIN
    notify_handler:=DesenharGrafico;
    event_handler:=TratarEventos;
    menu_name:=MenuGrafico;
    fore_color:=c_white;
    back_color:=c_black;
  END;
  xv_main_loop(fprincipal);
  {Fim}
  TextMode(80);
END.
