/*............................... VSA_FONT.H .............. 12-14-94 .......*/
/*    This is the font file for the VSA256 Graphics Library.  The basic     */
/*  font size is set by the XCharBase and YCharBase values defined at the   */
/*  top of this file.  This include file gives you the ability to fully     */
/*  customize your fonts! Feel free to edit the font vertex lists to be as  */
/*  personalized as possible.  Read on to see how it works.                 */
/*                                                                          */
/*   ASC[M][N] is a 2 dimensional array.  The M index selects one of 96     */
/* possible characters and corresponds to the printable ASCII character     */
/* codes from 32 to 127. (M = 0 selects ASCII character code 32 ... a space,*/
/* M = 95 selects ASCII character code 127 ... DEL)                         */
/*   For any given value of M, the N index steps through the vertex list    */
/* for that character.  Each vertex takes up 3 locations.  The first of     */
/* the 3 values is the blank code. A blank code of 0 means start a new line */
/* segment (equivalent to "move_to").  A blank code of 1 means continue     */
/* drawing (equivalent to "line_to").  A blank code of 255 means END of     */
/* vertex list. You MUST end each vertex list this way!                     */
/*   The next two values are x and y coordinates relative to the top left   */
/* corner of the character cell.  The x and y values should never be more   */
/* than XCharBase-1 and YCharBase-1 respectively.  When the blank code is   */
/* 255, the x and y values are ignored.  A maximum of 23 verticies plus an  */
/* END vertex are allowed per character.  Overrunning this limit will       */
/* probably cause your PC to go woopie.                                     */
/*..........................................................................*/

/*.....            Added 'far' to declarations on 12-14-94             .....*/

unsigned far XCharBase = 8, far YCharBase = 16;
unsigned char far ASC[96][72]={
{                                                   /* ASCII 32   " "*/
255,  0,  0 },
{                                                   /* ASCII 33   "!"*/
	0,  3,  2,
	1,  3,  7,
	0,  3, 10,
	1,  3, 11,
255,  0,  0 },
{                                                   /* ASCII 34   """*/
	0,  2,  2,
	1,  2,  4,
	0,  4,  2,
	1,  4,  4,
255,  0,  0 },
{                                                   /* ASCII 35   "#"*/
	0,  2,  2,
	1,  2, 11,
	0,  4,  2,
	1,  4, 11,
	0,  0,  5,
	1,  6,  5,
	0,  0,  8,
	1,  6,  8,
255,  0,  0 },
{                                                   /* ASCII 36   "$"*/
	0,  6,  4,
	1,  5,  3,
	1,  1,  3,
	1,  0,  4,
	1,  0,  5,
	1,  1,  6,
	1,  5,  6,
	1,  6,  7,
	1,  6,  9,
	1,  5, 10,
	1,  1, 10,
	1,  0,  9,
	0,  3,  2,
	1,  3, 11,
255,  0,  0 },
{                                                   /* ASCII 37   "%"*/
	0,  6,  2,
	1,  0, 11,
	0,  1,  2,
	1,  2,  2,
	1,  3,  3,
	1,  3,  4,
	1,  2,  5,
	1,  1,  5,
	1,  0,  4,
	1,  0,  3,
	1,  1,  2,
	0,  4,  8,
	1,  5,  8,
	1,  6,  9,
	1,  6, 10,
	1,  5, 11,
	1,  4, 11,
	1,  3, 10,
	1,  3,  9,
	1,  4,  8,
255,  0,  0 },
{                                                   /* ASCII 38   "&"*/
	0,  6, 10,
	1,  1,  5,
	1,  1,  3,
	1,  2,  2,
	1,  4,  2,
	1,  5,  3,
	1,  5,  5,
	1,  0,  8,
	1,  0, 10,
	1,  1, 11,
	1,  4, 11,
	1,  5, 10,
	1,  5,  8,
255,  0,  0 },
{                                                   /* ASCII 39   "'"*/
	0,  3,  2,
	1,  3,  3,
	1,  2,  4,
255,  0,  0 },
{                                                   /* ASCII 40   "("*/
	0,  4,  2,
	1,  2,  4,
	1,  2,  9,
	1,  4, 11,
255,  0,  0 },
{                                                   /* ASCII 41   ")"*/
	0,  2,  2,
	1,  4,  4,
	1,  4,  9,
	1,  2, 11,
255,  0,  0 },
{                                                   /* ASCII 42   "*"*/
	0,  3,  3,
	1,  3,  9,
	0,  0,  6,
	1,  6,  6,
	0,  1,  4,
	1,  5,  8,
	0,  5,  4,
	1,  1,  8,
255,  0,  0 },
{                                                   /* ASCII 43   "+"*/
	0,  3,  3,
	1,  3,  9,
	0,  0,  6,
	1,  6,  6,
255,  0,  0 },
{                                                   /* ASCII 44   ","*/
	0,  3, 11,
	1,  3, 12,
	1,  2, 13,
255,  0,  0 },
{                                                   /* ASCII 45   "-"*/
	0,  0,  6,
	1,  6,  6,
255,  0,  0 },
{                                                   /* ASCII 46   "."*/
	0,  3, 11,
	1,  3, 11,
255,  0,  0 },
{                                                   /* ASCII 47   "/"*/
	0,  6,  2,
	1,  0, 11,
255,  0,  0 },
{                                                   /* ASCII 48   "0"*/
	0,  1,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6, 10,
	1,  5, 11,
	1,  1, 11,
	1,  0, 10,
	1,  0,  3,
	1,  1,  2,
	0,  6,  3,
	1,  0,  9,
255,  0,  0 },
{                                                   /* ASCII 49   "1"*/
	0,  1,  4,
	1,  3,  2,
	1,  3, 11,
	0,  1, 11,
	1,  5, 11,
255,  0,  0 },
{                                                   /* ASCII 50   "2"*/
	0,  0,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6,  5,
	1,  5,  6,
	1,  1,  6,
	1,  0,  7,
	1,  0, 11,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 51   "3"*/
	0,  0,  3,
	1,  1,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6,  5,
	1,  5,  6,
	1,  6,  7,
	1,  6, 10,
	1,  5, 11,
	1,  1, 11,
	1,  0, 10,
	0,  2,  6,
	1,  5,  6,
255,  0,  0 },
{                                                   /* ASCII 52   "4"*/
	0,  4, 11,
	1,  4,  2,
	1,  0,  6,
	1,  0,  7,
	1,  6,  7,
255,  0,  0 },
{                                                   /* ASCII 53   "5"*/
	0,  6,  2,
	1,  0,  2,
	1,  0,  5,
	1,  1,  6,
	1,  5,  6,
	1,  6,  7,
	1,  6, 10,
	1,  5, 11,
	1,  0, 11,
255,  0,  0 },
{                                                   /* ASCII 54   "6"*/
	0,  5,  2,
	1,  2,  2,
	1,  0,  4,
	1,  0, 10,
	1,  1, 11,
	1,  5, 11,
	1,  6, 10,
	1,  6,  7,
	1,  5,  6,
	1,  0,  6,
255,  0,  0 },
{                                                   /* ASCII 55   "7"*/
	0,  0,  3,
	1,  0,  2,
	1,  6,  2,
	1,  6,  4,
	1,  2,  8,
	1,  2, 11,
255,  0,  0 },
{                                                   /* ASCII 56   "8"*/
	0,  1,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6,  5,
	1,  5,  6,
	1,  6,  7,
	1,  6, 10,
	1,  5, 11,
	1,  1, 11,
	1,  0, 10,
	1,  0,  7,
	1,  1,  6,
	1,  0,  5,
	1,  0,  3,
	1,  1,  2,
	0,  1,  6,
	1,  5,  6,
255,  0,  0 },
{                                                   /* ASCII 57   "9"*/
	0,  1, 11,
	1,  3, 11,
	1,  6,  8,
	1,  6,  3,
	1,  5,  2,
	1,  1,  2,
	1,  0,  3,
	1,  0,  5,
	1,  1,  6,
	1,  6,  6,
255,  0,  0 },
{                                                   /* ASCII 58   ":"*/
	0,  3,  6,
	1,  3,  6,
	0,  3, 11,
	1,  3, 11,
255,  0,  0 },
{                                                   /* ASCII 59   ";"*/
	0,  3,  6,
	1,  3,  6,
	0,  3, 11,
	1,  3, 12,
	1,  2, 13,
255,  0,  0 },
{                                                   /* ASCII 60   "<"*/
	0,  6,  2,
	1,  0,  6,
	1,  6, 10,
255,  0,  0 },
{                                                   /* ASCII 61   "="*/
	0,  0,  5,
	1,  6,  5,
	0,  0,  7,
	1,  6,  7,
255,  0,  0 },
{                                                   /* ASCII 62   ">"*/
	0,  0,  2,
	1,  6,  6,
	1,  0, 10,
255,  0,  0 },
{                                                   /* ASCII 63   "?"*/
	0,  0,  3,
	1,  1,  2,
	1,  4,  2,
	1,  5,  3,
	1,  5,  5,
	1,  4,  6,
	1,  2,  6,
	1,  2,  9,
	0,  2, 11,
	1,  2, 11,
255,  0,  0 },
{                                                   /* ASCII 64   "@"*/
	0,  5, 11,
	1,  1, 11,
	1,  0, 10,
	1,  0,  3,
	1,  1,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6,  9,
	1,  5,  8,
	1,  4,  9,
	1,  3,  9,
	1,  2,  8,
	1,  2,  6,
	1,  3,  5,
	1,  4,  5,
	1,  5,  6,
	1,  5,  8,
	0,  5,  5,
	1,  5,  6,
255,  0,  0 },
{                                                   /* ASCII 65   "A"*/
	0,  0, 11,
	1,  0,  5,
	1,  3,  2,
	1,  6,  5,
	1,  6, 11,
	0,  0,  6,
	1,  6,  6,
255,  0,  0 },
{                                                   /* ASCII 66   "B"*/
	0,  0,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6,  5,
	1,  5,  6,
	1,  6,  7,
	1,  6, 10,
	1,  5, 11,
	1,  0, 11,
	0,  1,  2,
	1,  1, 11,
	0,  1,  6,
	1,  5,  6,
255,  0,  0 },
{                                                   /* ASCII 67   "C"*/
	0,  6,  3,
	1,  5,  2,
	1,  1,  2,
	1,  0,  3,
	1,  0, 10,
	1,  1, 11,
	1,  5, 11,
	1,  6, 10,
255,  0,  0 },
{                                                   /* ASCII 68   "D"*/
	0,  0,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6, 10,
	1,  5, 11,
	1,  0, 11,
	0,  1,  2,
	1,  1, 11,
255,  0,  0 },
{                                                   /* ASCII 69   "E"*/
	0,  6,  2,
	1,  0,  2,
	1,  0, 11,
	1,  6, 11,
	0,  0,  6,
	1,  4,  6,
255,  0,  0 },
{                                                   /* ASCII 70   "F"*/
	0,  6,  2,
	1,  0,  2,
	1,  0, 11,
	0,  0,  6,
	1,  4,  6,
255,  0,  0 },
{                                                   /* ASCII 71   "G"*/
	0,  6,  3,
	1,  5,  2,
	1,  1,  2,
	1,  0,  3,
	1,  0, 10,
	1,  1, 11,
	1,  5, 11,
	1,  6, 10,
	1,  6,  7,
	1,  4,  7,
255,  0,  0 },
{                                                   /* ASCII 72   "H"*/
	0,  0,  2,
	1,  0, 11,
	0,  6,  2,
	1,  6, 11,
	0,  0,  6,
	1,  6,  6,
255,  0,  0 },
{                                                   /* ASCII 73   "I"*/
	0,  1,  2,
	1,  5,  2,
	0,  3,  2,
	1,  3, 11,
	0,  1, 11,
	1,  5, 11,
255,  0,  0 },
{                                                   /* ASCII 74   "J"*/
	0,  0, 10,
	1,  1, 11,
	1,  4, 11,
	1,  5, 10,
	1,  5,  2,
	0,  4,  2,
	1,  6,  2,
255,  0,  0 },
{                                                   /* ASCII 75   "K"*/
	0,  0,  2,
	1,  0, 11,
	0,  6,  2,
	1,  0,  8,
	0,  2,  6,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 76   "L"*/
	0,  0,  2,
	1,  0, 11,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 77   "M"*/
	0,  0, 11,
	1,  0,  2,
	1,  3,  5,
	1,  6,  2,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 78   "N"*/
	0,  0, 11,
	1,  0,  2,
	1,  6, 11,
	1,  6,  2,
255,  0,  0 },
{                                                   /* ASCII 79   "O"*/
	0,  1,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6, 10,
	1,  5, 11,
	1,  1, 11,
	1,  0, 10,
	1,  0,  3,
	1,  1,  2,
255,  0,  0 },
{                                                   /* ASCII 80   "P"*/
	0,  0, 11,
	1,  0,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6,  5,
	1,  5,  6,
	1,  0,  6,
255,  0,  0 },
{                                                   /* ASCII 81   "Q"*/
	0,  1,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6, 10,
	1,  5, 11,
	1,  1, 11,
	1,  0, 10,
	1,  0,  3,
	1,  1,  2,
	0,  3,  9,
	1,  6, 13,
255,  0,  0 },
{                                                   /* ASCII 82   "R"*/
	0,  0, 11,
	1,  0,  2,
	1,  5,  2,
	1,  6,  3,
	1,  6,  5,
	1,  5,  6,
	1,  0,  6,
	0,  3,  6,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 83   "S"*/
	0,  6,  3,
	1,  5,  2,
	1,  1,  2,
	1,  0,  3,
	1,  0,  5,
	1,  1,  6,
	1,  5,  6,
	1,  6,  7,
	1,  6, 10,
	1,  5, 11,
	1,  1, 11,
	1,  0, 10,
255,  0,  0 },
{                                                   /* ASCII 84   "T"*/
	0,  0,  2,
	1,  6,  2,
	0,  3,  2,
	1,  3, 11,
255,  0,  0 },
{                                                   /* ASCII 85   "U"*/
	0,  0,  2,
	1,  0, 10,
	1,  1, 11,
	1,  5, 11,
	1,  6, 10,
	1,  6,  2,
255,  0,  0 },
{                                                   /* ASCII 86   "V"*/
	0,  0,  2,
	1,  0,  8,
	1,  3, 11,
	1,  6,  8,
	1,  6,  2,
255,  0,  0 },
{                                                   /* ASCII 87   "W"*/
	0,  0,  2,
	1,  0, 11,
	1,  3,  8,
	1,  6, 11,
	1,  6,  2,
255,  0,  0 },
{                                                   /* ASCII 88   "X"*/
	0,  0,  2,
	1,  0,  3,
	1,  3,  6,
	1,  6,  3,
	1,  6,  2,
	0,  0, 11,
	1,  0, 10,
	1,  3,  7,
	1,  6, 10,
	1,  6, 11,
	0,  3,  6,
	1,  3,  7,
255,  0,  0 },
{                                                   /* ASCII 89   "Y"*/
	0,  0,  2,
	1,  0,  3,
	1,  3,  6,
	1,  6,  3,
	1,  6,  2,
	0,  3,  6,
	1,  3, 11,
255,  0,  0 },
{                                                   /* ASCII 90   "Z"*/
	0,  0,  2,
	1,  6,  2,
	1,  0, 11,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 91   "["*/
	0,  4,  2,
	1,  2,  2,
	1,  2, 11,
	1,  4, 11,
255,  0,  0 },
{                                                   /* ASCII 92   "\"*/
	0,  0,  2,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 93   "]"*/
	0,  2,  2,
	1,  4,  2,
	1,  4, 11,
	1,  2, 11,
255,  0,  0 },
{                                                   /* ASCII 94   "^"*/
	0,  1,  2,
	1,  3,  0,
	1,  5,  2,
255,  0,  0 },
{                                                   /* ASCII 95   "_"*/
	0,  1, 11,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 96   "`"*/
	0,  3,  0,
	1,  3,  2,
255,  0,  0 },
{                                                   /* ASCII 97   "a"*/
	0,  2,  6,
	1,  4,  6,
	1,  5,  7,
	1,  5, 10,
	1,  4, 11,
	1,  2, 11,
	1,  1, 10,
	1,  1,  9,
	1,  2,  8,
	1,  4,  8,
	1,  5,  9,
	0,  5, 10,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 98   "b"*/
	0,  2,  2,
	1,  2, 10,
	1,  1, 11,
	0,  2,  7,
	1,  3,  6,
	1,  5,  6,
	1,  6,  7,
	1,  6, 10,
	1,  5, 11,
	1,  3, 11,
	1,  2, 10,
255,  0,  0 },
{                                                   /* ASCII 99   "c"*/
	0,  6,  7,
	1,  5,  6,
	1,  2,  6,
	1,  1,  7,
	1,  1, 10,
	1,  2, 11,
	1,  5, 11,
	1,  6, 10,
255,  0,  0 },
{                                                  /* ASCII 100  "d"*/
	0,  5,  2,
	1,  5, 10,
	1,  6, 11,
	0,  5,  7,
	1,  4,  6,
	1,  2,  6,
	1,  1,  7,
	1,  1, 10,
	1,  2, 11,
	1,  4, 11,
	1,  5, 10,
255,  0,  0 },
{                                                   /* ASCII 101  "e"*/
	0,  6, 11,
	1,  2, 11,
	1,  1, 10,
	1,  1,  7,
	1,  2,  6,
	1,  5,  6,
	1,  6,  7,
	1,  6,  8,
	1,  1,  8,
255,  0,  0 },
{                                                   /* ASCII 102  "f"*/
	0,  6,  3,
	1,  5,  2,
	1,  4,  2,
	1,  3,  3,
	1,  3, 11,
	0,  1,  6,
	1,  5,  6,
255,  0,  0 },
{                                                   /* ASCII 103  "g"*/
	0,  6,  6,
	1,  5,  7,
	1,  5, 13,
	1,  4, 14,
	1,  1, 14,
	0,  5,  7,
	1,  4,  6,
	1,  2,  6,
	1,  1,  7,
	1,  1, 10,
	1,  2, 11,
	1,  4, 11,
	1,  5, 10,
255,  0,  0 },
{                                                   /* ASCII 104  "h"*/
	0,  2,  2,
	1,  2, 11,
	0,  2,  7,
	1,  3,  6,
	1,  5,  6,
	1,  6,  7,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 105  "i"*/
	0,  4,  2,
	1,  4,  3,
	0,  4,  6,
	1,  4,  11,
255,  0,  0 },
{                                                   /* ASCII 106  "j"*/
	0,  5,  2,
	1,  5,  3,
	0,  4,  7,
	1,  5,  6,
	1,  5, 13,
	1,  4, 14,
	1,  2, 14,
	1,  1, 13,
255,  0,  0 },
{                                                   /* ASCII 107  "k"*/
	0,  2,  2,
	1,  2, 11,
	0,  2,  9,
	1,  5,  6,
	0,  3,  8,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 108  "l"*/
	0,  4,  2,
	1,  4, 11,
255,  0,  0 },
{                                                   /* ASCII 109  "m"*/
	0,  1, 11,
	1,  1,  6,
	1,  3,  8,
	1,  4,  8,
	1,  6,  6,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 110  "n"*/
	0,  1,  6,
	1,  2,  7,
	1,  2, 11,
	0,  2,  7,
	1,  3,  6,
	1,  5,  6,
	1,  6,  7,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 111  "o"*/
	0,  2,  6,
	1,  5,  6,
	1,  6,  7,
	1,  6, 10,
	1,  5, 11,
	1,  2, 11,
	1,  1, 10,
	1,  1,  7,
	1,  2,  6,
255,  0,  0 },
{                                                   /* ASCII 112  "p"*/
	0,  1,  6,
	1,  2,  7,
	1,  2, 14,
	0,  2,  7,
	1,  3,  6,
	1,  5,  6,
	1,  6,  7,
	1,  6, 10,
	1,  5, 11,
	1,  3, 11,
	1,  2, 10,
255,  0,  0 },
{                                                   /* ASCII 113  "q"*/
	0,  6,  6,
	1,  5,  7,
	1,  5, 14,
	0,  5,  7,
	1,  4,  6,
	1,  2,  6,
	1,  1,  7,
	1,  1, 10,
	1,  2, 11,
	1,  4, 11,
	1,  5, 10,
255,  0,  0 },
{                                                   /* ASCII 114  "r"*/
	0,  1,  6,
	1,  2,  7,
	1,  2, 11,
	0,  2,  7,
	1,  3,  6,
	1,  5,  6,
	1,  6,  7,
255,  0,  0 },
{                                                   /* ASCII 115  "s"*/
	0,  1, 11,
	1,  5, 11,
	1,  6, 10,
	1,  6,  9,
	1,  5,  8,
	1,  1,  8,
	1,  1,  7,
	1,  2,  6,
	1,  6,  6,
255,  0,  0 },
{                                                   /* ASCII 116  "t"*/
	0,  1,  6,
	1,  5,  6,
	0,  3,  2,
	1,  3, 10,
	1,  4, 11,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 117  "u"*/
	0,  1,  6,
	1,  1, 10,
	1,  2, 11,
	1,  4, 11,
	1,  5, 10,
	1,  5,  6,
	0,  5, 10,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 118  "v"*/
	0,  1,  6,
	1,  1,  9,
	1,  3, 11,
	1,  4, 11,
	1,  6,  9,
	1,  6,  6,
255,  0,  0 },
{                                                   /* ASCII 119  "w"*/
	0,  1,  6,
	1,  1, 11,
	1,  3,  9,
	1,  4,  9,
	1,  6, 11,
	1,  6,  6,
255,  0,  0 },
{                                                   /* ASCII 120  "x"*/
	0,  1,  6,
	1,  6, 11,
	0,  6,  6,
	1,  1, 11,
255,  0,  0 },
{                                                   /* ASCII 121  "y"*/
	0,  1,  6,
	1,  1, 10,
	1,  2, 11,
	1,  5, 11,
	1,  6, 10,
	1,  6,  6,
	0,  6, 10,
	1,  6, 13,
	1,  5, 14,
	1,  1, 14,
255,  0,  0 },
{                                                   /* ASCII 122  "z"*/
	0,  1,  6,
	1,  6,  6,
	1,  1, 11,
	1,  6, 11,
255,  0,  0 },
{                                                   /* ASCII 123  "{"*/
	0,  5,  2,
	1,  4,  2,
	1,  3,  3,
	1,  3,  5,
	1,  2,  6,
	1,  3,  7,
	1,  3, 10,
	1,  4, 11,
	1,  5, 11,
255,  0,  0 },
{                                                   /* ASCII 124  "|"*/
	0,  3,  2,
	1,  3,  5,
	0,  3,  7,
	1,  3, 11,
255,  0,  0 },
{                                                   /* ASCII 125  "}"*/
	0,  1,  2,
	1,  2,  2,
	1,  3,  3,
	1,  3,  5,
	1,  4,  6,
	1,  3,  7,
	1,  3, 10,
	1,  2, 11,
	1,  1, 11,
255,  0,  0 },
{                                                   /* ASCII 126  "~"*/
	0,  0,  3,
	1,  1,  2,
	1,  2,  2,
	1,  3,  3,
	1,  5,  3,
	1,  6,  2,
255,  0,  0 },
{                                                   /* ASCII 127  "del"*/
	0,  0,  5,
	1,  3,  2,
	1,  6,  5,
	1,  3,  8,
	1,  0,  5,
255,  0,  0 },
};

