/***************************************************************************
  Scene fille for rendering Terrain Maker example heightfield

  Created by Eric Jorgensen (1994)
****************************************************************************/


#include "colors.inc"    // The include files contain
#include "shapes.inc"    // pre-defined scene elements
#include "textures.inc"  //  This file has the blue_sky3 texture

camera {
   location <210, 38, 40>
   sky       <0, 1, 0> 
   up        <0, 1, 0>
   right     <1, 0, 0>
   look_at   < 553, -10, 698> 
}
                                    // FOG gives a natural looking haze
                                    // effect.
fog {color White distance 1550 }

#declare Mysky = sphere { 
  <0,0,0>,0.98
  texture {
    Blue_Sky3
    finish {reflection 0.0 diffuse 0.0 ambient 1.0}
  }  
}
                                      //  The sky object is just shell
                                      //  with sky texture on the inside.
                                      //  Note that the shell has the
                                      //  no_shadow modifier.  This is
                                      // so I can put the light source
                                      // on the outside.
difference {
     sphere { <0,0,0>,1}
     object {Mysky}

     scale <3000,500,3000>
     texture {
          Blue_Sky3
          finish {reflection 0.0 diffuse 0.0 ambient 1.0} 
     }  
     no_shadow
}
                                          //  This is the water.  I tried
                                          //  using waves innstead of bumps,
                                          //  but they looked awful.
plane {   
     <0,1,0>, 32
     texture {
       pigment {color rgb<0.0,0.1,0.2>}
       normal {bumps 0.5 scale .8}
       finish {phong 1 reflection .5 ambient 0.1 diffuse 0.2}
     }

}

                                       //  Here is the heightfield!
height_field {
     gif "example.ghf"
     scale <1000,200,1000>
     texture {
       pigment { 
         image_map {
           gif "example.ghf"
         }
         rotate x*90
         scale <1000,200,1000>
       }
     finish {crand 0.05 reflection 0.1 diffuse 0.7 ambient 0.2}
     }
     smooth                            // comment out this line to speed rendering
}

                                       // When simulating sinshine, it is
                                       // good to keep the light source far 
                                       // away.
light_source { <-1500, 9000, 500> color White }

