/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: validvw.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Implementation for the validView function.
*
* $Id: validvw.cpp 1.2 1994/03/09 11:50:49 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tprogram.hpp"

/*----------------------------- Implementation ----------------------------*/

TView *validView(TView *view)
/****************************************************************************
*
* Function:		validView
* Parameters:	view	- View to check for validity
* Returns:		Pointer to the view if valid, NULL if not.
*
* Description:	Checks to see if the safety pool has been hit during
*				memory allocation, or the view was not validly constructed.
*				If either is the case, the view is destroyed and the
*				appropriate action is taken (returning NULL for the
*				view pointer).
*
****************************************************************************/
{
	if (view) {
		if (lowMemory()) {
			delete view;

			// Only call the outOfMemory() routine _iff_ the application
			// instance has been successfully initialised. This will
			// be true only if the application pointer is not NULL.

			if (TProgram::application)
				TProgram::application->outOfMemory();
			return NULL;
			}
		if (!view->valid(cmValid)) {
			delete view;
			return NULL;
			}
		}
	return view;
}
