/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: ttitleb.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TTitleBar class. This class is used
*				to represent the title bar for the window class.
*
* $Id: ttitleb.hpp 1.2 1994/03/09 11:50:25 kjb Exp $
*
****************************************************************************/

#ifndef	__TTITLEB_HPP
#define	__TTITLEB_HPP

#ifndef	__TVIEW_HPP
#include "tview.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TTitleBar class is used to represent the title bar drawn at the top
// of the window.
//
// TTitleBar's use the owning TWindow palette.
//---------------------------------------------------------------------------

class TTitleBar : public TView {
	char			*title;				// Title text
	TPoint			start;				// Place to start drawing title
	TextJust		tjust;				// Text justification

public:
			// Constructor
			TTitleBar(const TRect& bounds,const char *title,ushort flags);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase);

			// Method to set the bounds of the view
	virtual	void setBounds(const TRect& bounds);

			// Method to draw the title bar
	virtual	void draw(const TRect& clip);
	};

#endif	// __TTITLEBAR_HPP
