/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tsttext.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TStaticText class. This class is used
*				to represent text items in a view that are static and
*				do not respond to events.
*
* $Id: tsttext.hpp 1.2 1994/03/09 11:50:25 kjb Exp $
*
****************************************************************************/

#ifndef	__TSTTEXT_HPP
#define	__TSTTEXT_HPP

#ifndef	__TVIEW_HPP
#include "tview.hpp"
#endif

/*------------------------------ Constants --------------------------------*/

ushort const

// Static text creation flags

	sfLeftJust		= 0x0001,		// Text is left justified
	sfRightJust		= 0x0002,		// Text is right justified
	sfTopJust		= 0x0004,		// Text is top justified
	sfBottomJust	= 0x0008,		// Text is bottom justified
	sfWrap			= 0x0010,		// Text wraps at right edge
	sfNormal		= sfLeftJust | sfTopJust | sfWrap;

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TStaticText class is used to represent text items in a view that
// are static and do not respond to any events. TStaticText views cannot
// be focused.
//
// Note that the text will be clipped to the bounds of the text item.
//---------------------------------------------------------------------------

class TStaticText : public TView {
protected:
	const char 		*text;			// Text to display
	TPoint			start;			// Position to begin drawing title at
	TextJust		tjust;			// Text justification
	ushort			flags;			// Creation flags

public:
			// Constructor
			TStaticText(const TRect& bounds,const char *text,
				ushort flags = sfNormal);

			// Method to set the bounds for the static text item
	virtual	void setBounds(const TRect& bounds);

			// Method to draw the static text item
	virtual	void draw(const TRect& clip);

			// Method to set the text for the text item - returns old value
	virtual	const char *setText(const char *t);
	};

//---------------------------------------------------------------------------
// The TLabel class is a special static text class that can be used to
// automatically select another view when it is clicked.
//---------------------------------------------------------------------------

class TLabel : public TStaticText {
protected:
	TView	*attached;			// View attached to the label

public:
			// Constructor
			TLabel(const TRect& bounds,const char *text,
				TView *attached,ushort flags = sfNormal)
				: TStaticText(bounds,text,flags), attached(attached) {};

			// Method to set/get the attached view
			void setAttached(TView *a)	{ attached = a; };
			TView *getAttached()		{ return attached; };

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);
	};

//---------------------------------------------------------------------------
// The TMultiLineText class is used to represent static text items in a
// view that contain multiple lines of text.
//---------------------------------------------------------------------------

class TMultiLineText : public TStaticText {
protected:
	short	lines;				// Number of lines of text

public:
			// Constructor
			TMultiLineText(const TRect& bounds,const char *text,
				ushort flags = sfNormal);

			// Method to draw the static text item
	virtual	void draw(const TRect& clip);

			// Method to set the text for the text item - returns old value
	virtual	const char *setText(const char *t);

			// Method to obtain the number of lines
			short numberOfLines()	{ return lines; };
	};

#endif	// __TSTTEXT_HPP
