/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tscrollb.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TScrollBar classes. These classes
*				are used to represent the horizontal and vertical
*				scroll bar objects.
*
*				You may make the scroll bar's as wide as you wish, but the
*				standard scroll bar width is 14 pixels.
*
* $Id: tscrollb.hpp 1.2 1994/03/09 11:50:25 kjb Exp $
*
****************************************************************************/

#ifndef	__TSCROLLB_HPP
#define	__TSCROLLB_HPP

#ifndef	__TVIEW_HPP
#include "tview.hpp"
#endif

/*------------------------------ Constants --------------------------------*/

ushort const

// Scroll bar part codes

	sbLeftArrow		= 0,
	sbRightArrow	= 1,
	sbPageLeft		= 2,
	sbPageRight		= 3,
	sbThumb			= 4,

// Scroll bar flags

	sbInteracting	= 0x0001,		// The scroll bar is interacting
	sbDirtyLeft		= 0x0002,		// The left arrow is dirty
	sbDirtyRight	= 0x0004,		// The right arrow is dirty
	sbDirtyThumb	= 0x0008,		// The thumb is dirty
	sbDirty			= sbDirtyLeft | sbDirtyRight | sbDirtyThumb;

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The following is the class used to represent both horiztontal and
// vertical scroll bars.
//
// Palette layout:
//		1 = Light border
//		2 = Dark border
//		3 = Scroll bar interior
//		4 = Active arrow
//		5 = Inactive arrow
//		6 = Unselected interior
//		7 = Selected interior
//
// TScrollBar's are intended to be inserted into TWindow and descendant
// classes.
//---------------------------------------------------------------------------

class TScrollBar : public TView {
protected:
	short	value;				// Current value for scroll bar
	short	minVal,maxVal;		// Minimum/maximum scroll bar values
	short	pageStep;			// Amount to move if page area activated
	short	arrowStep;			// Amount to move if arrow area activated
	TRect	leftArrow;			// Bounds for left arrow
	TRect	rightArrow;			// Bounds for right arrow
	TRect	thumb;				// Bounds for thumb
	bool	vertical;			// True if scroll bar is vertical
	ushort	flags;				// Flags for the scroll bar

			// Methods to draw the scroll bar parts
			void drawLeftArrow(bool down);
			void drawRightArrow(bool down);
			void drawThumb(int which);

			// Method to determine which part of scroll bar was clicked
			int getPartHit(const TPoint& p);

			// Method to draw the specified part
			void drawPart(int part,bool down);

			// Method to compute the location of the thumb
			void moveThumb();

			// Methods to change the scroll bar value, and redraw it
			void changeValue(int part);
			void changeValue(const TPoint& where);
public:
			// Constructor
			TScrollBar(const TRect& bounds);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase);

			// Method to move the group to another location
	virtual	void moveTo(int x,int y);

			// Method to set the bounds for the scroll bar
	virtual	void setBounds(const TRect& bounds);

			// Method to draw the scrollbar in current state
	virtual	void draw(const TRect& clip);

			// Method to update the state of the scroll bar (thumb posn)
			void update();

			// Methods to get/set the values for the scroll bar
			void setValue(short v);
			void setMinVal(short v);
			void setMaxVal(short v);
			void setPageStep(short s)	{ pageStep = s; };
			void setArrowStep(short s)	{ arrowStep = s; };
			short getValue() const		{ return value; };
			short getMinVal() const		{ return minVal; };
			short getMaxVal() const		{ return maxVal; };
			short getPageStep() const	{ return pageStep; };
			short getArrowStep() const	{ return arrowStep; };
			void setRange(short min,short max);

			// Method to return a reference to the view's current palette
	virtual	TPalette& getPalette() const;
	};

#endif	// __TSCROLLB_HPP
