/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: trendera.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TRenderArea class.
*
* $Id: trendera.cpp 1.2 1994/03/09 11:50:43 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

//#pragma	hdrstop

#include "trendera.hpp"
#include "techlib.hpp"

/*----------------------------- Implementation ----------------------------*/

TRenderArea::TRenderArea(const TRect& bounds)
	: TView(bounds)
/****************************************************************************
*
* Function:		TRenderArea::TRenderArea
* Parameters:	bounds	- Bounding box for the render area
*
* Description:	Constructor for the TRenderArea class.
*
****************************************************************************/
{
	PRECONDITION(MGL_getActivePage() == 0 && MGL_getVisualPage() == 0);
	doubleBuffered = false;
}

void TRenderArea::draw(const TRect& clip)
/****************************************************************************
*
* Function:		TRenderArea::draw
* Parameters:	clip	- Clipping rectangle to use when drawing
*
* Description:	Draws the representation of the TRenderArea.
*
****************************************************************************/
{
	mouse.obscure();
	setupViewport();
	TRect c(clip);
	c.offset(-bounds.topLeft.x,-bounds.topLeft.y);
	MGL_setClipRect(c);
	render();
	resetViewport();
	mouse.unobscure();
}

void TRenderArea::doubleBufferOn()
/****************************************************************************
*
* Function:		TRenderArea::doubleBufferOn
*
* Description:	Turns on double buffering for the render area. This member
*				function should be called just before peforming any
*				animation in the render area.
*
****************************************************************************/
{
	if (MGL_doubleBuffer()) {
		// Force a repaint onto the hidden display page

		doubleBuffered = true;
		TProgram::application->repaint();
		getEvent(TEvent(),evRepaint);
		}
}

void TRenderArea::doubleBufferOff()
/****************************************************************************
*
* Function:		TRenderArea::doubleBufferOff
*
* Description:	Turns off double buffering. The visual display page will
*				not necessarily be zero after this.
*
****************************************************************************/
{
	MGL_singleBuffer();
}
