/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tprogram.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TProgram class. This class is the base
*				class for all program instances. You must subclass from
*				this to have a useable class.
*
* $Id: tprogram.hpp 1.2 1994/03/09 11:50:21 kjb Exp $
*
****************************************************************************/

#ifndef	__TPROGRAM_HPP
#define	__TPROGRAM_HPP

#ifndef	__TFONTMGR_HPP
#include "tfontmgr.hpp"
#endif

#ifndef	__TGROUP_HPP
#include "tgroup.hpp"
#endif

#ifndef	__TMENUBAR_HPP
#include "tmenubar.hpp"
#endif

#ifndef	__TDESKTOP_HPP
#include "tdesktop.hpp"
#endif

class TStatusLine;

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TProgInit class is used to initialise the pointers to create the
// menu bar, status line and desktop. It is required to get around the
// problem of calling virtual functions from within superclass constuctors.
//---------------------------------------------------------------------------

class TProgInit {
protected:
	TStatusLine	*(*createStatusLine)(const TRect& bounds);
	TMenuBar	*(*createMenuBar)(const TRect& bounds);
	TDeskTop	*(*createDeskTop)(const TRect& bounds);
	void 		(*adjustVideoMode)(int& driver,int& mode);

public:
			TProgInit(TStatusLine *(*createStatusLine)(const TRect& bounds),
					  TMenuBar *(*createMenuBar)(const TRect& bounds),
					  TDeskTop *(*createDeskTop)(const TRect& bounds),
					  void (*adjustVideoMode)(int& driver,int& mode))
				: createStatusLine(createStatusLine),
				  createMenuBar(createMenuBar),
				  createDeskTop(createDeskTop),
				  adjustVideoMode(adjustVideoMode) {};
	};

//---------------------------------------------------------------------------
// The TProgram class is the base class for all application programs
// written with the class library. It provides almost everything that you
// need to put together the pieces of a standard application.
//
// Palette layout:
//	   1- 2	= TBackground
//	   3- 9 = TMenu and TStatusLine
//	  10-25 = TWindow
//	  26-50 = TDialog
//---------------------------------------------------------------------------

class TProgram : public TGroup, public virtual TProgInit {
protected:
	TEvent		pending;		// Next pending message event (if any)
	int			graphDriver;	// Graphics device driver number
	int			graphMode;		// Graphics mode number
	char		*pathToDriver;	// Path to graphics driver
	palette		*systemPal;		// System palette
	TRect		invalid;		// Current invalid rectangle
	bool		globalRepaint;	// Repaint event is global

			// Method to intialise the system palette
			void initSystemPalette();

			// Method to initialise the graphics subsystem
			void initGraphics();

			// Method to restore text/graphics mode
			void restoreCRTMode()	{ MGL_restoreCRTMode(); };
			void restoreGraphMode();

			// Method to perform a repaint operation
			void doRepaint();

			// Virtual function called to exit the program
	virtual	bool exitProgram();

public:
			// Constructor
			TProgram(char *pathToDriver = "");

			// Destructor
			~TProgram();

			// Virtual to determine if the program was constructed correctly
	virtual	bool valid(ushort command);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);

			// Methods to retrieve and post events
	virtual	void putEvent(TEvent& event);
	virtual	bool getEvent(TEvent& event,ushort mask = evAll);
	virtual	bool peekEvent(TEvent& event,ushort mask = evAll);

			// Method to invalidate the specified rectangle
	virtual	void invalidRect(TRect& rect,bool global);

			// Methods to draw the program
	virtual	void draw(const TRect& clip);
	virtual	void redraw();

			// Member function to begin processing events for program
			ushort run();

			// Members to suspend/resume program
	virtual	void suspend();
	virtual	void resume();

			// Virtual function called during idle moments
	virtual	void idle();

			// Member function called when memory is exhausted
	virtual	void outOfMemory();

			// Method to handle unhandled events
	virtual	void eventError(TEvent& event);

			// Method to return a reference to the programs current palette
	virtual	TPalette& getPalette() const;

			// Method to set the system palette
			void setSystemPalette()
				{ MGL_setPalette(systemPal,MGL_getPaletteSize(),0); };

			// Default methods to create the menubar
	static	TStatusLine *initStatusLine(const TRect& bounds);
	static	TMenuBar *initMenuBar(const TRect& bounds);
	static	TDeskTop *initDeskTop(const TRect& bounds);

			// Default method to adjust the starting video mode
	static	void initVideoMode(int& driver,int& mode);

	// Publicly accessible global variables

	static TProgram		*application;	// Pointer to application instance
	static TStatusLine	*statusLine;	// Program's status line
	static TMenuBar		*menuBar;		// Program's menu bar
	static TDeskTop		*deskTop;		// Program's desktop
	};

#endif	// __TPROGRAM_HPP
