/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tpalette.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TPalette class. This class is used
*				to map color index entries to real colors used by the
*				current video mode.
*
* $Id: tpalette.hpp 1.2 1994/03/09 11:50:21 kjb Exp $
*
****************************************************************************/

#ifndef	__TPALETTE_HPP
#define	__TPALETTE_HPP

#ifndef	__DEBUG_H
#include "debug.h"
#endif

#ifndef	__MGRAPH_H
#include "mgraph.h"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The following class is used to represent the color mapping of simple
// color indices to actual color values. Mapping is done hierarchically
// through the current group hierarchy.
//---------------------------------------------------------------------------

class TPalette {
protected:
	char	*data;					// Pointer to palette data

public:
			// Constructors
			TPalette(const char *data,int len);
			TPalette(const TPalette& pal);

			// Destructor
			~TPalette()	{ delete data; };

			// Assignment operator
			const TPalette& operator = (const TPalette& pal);

			// Method to lookup a palette index entry
			char operator [] (int index) const	{ return data[index]; };
	};

#endif	// __TPALETTE_HPP
