/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tmodesel.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TOpenDialog class.
*
* $Id: tmodesel.cpp 1.2 1994/03/09 11:50:43 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tmodesel.hpp"
#include "tfontmgr.hpp"
#include "tsttext.hpp"
#include "tbutton.hpp"
#include "tkeys.hpp"
#include <stdio.h>

/*----------------------------- Implementation ----------------------------*/

#define	LINESPERLIST	6

TModeSelector::TModeSelector(const char *title,int driver,int mode,
    int *validModes)
	: TDialog(TRect(0,0,100,100),title), modenames(5,5),
	  driver(driver), mode(mode),
	  TWindowInit(TWindow::initFrame,TWindow::initTitleBar)
/****************************************************************************
*
* Function:		TModeSelector::TModeSelector
* Parameters:	title		- Title for the dialog box
*				driver		- Video device driver number
*				mode		- Video mode number
*				validModes	- List of valid video modes (terminate with -1)
*
* Description:	Constructor for the TModeSelector dialog box. We build the
*				list of all names to be loaded into the dialog box.
*
****************************************************************************/
{
	TLabel	*label;

	options |= ofCentered;

	// Find the height of the system font, and compute the location of
	// all the elements of the input dialog.

	fontManager.useFont(fmSystemFont);
	metrics m;
	MGL_getFontMetrics(&m);
	int height = MGL_textHeight();
	int cellHeight = m.ascent - m.descent + 1 + 4;
	int buttonHeight = height + 12;
	int dialogWidth = (MGL_sizex()*2)/3;

	TRect r(inner);
	int	adjustBottom = bounds.bottom() - r.bottom();

	// Create the label and list box for video mode names

	r.top() += height;
	r.bottom() = r.top() + height;
	r.left() = 15;
	r.right() = 15 + MGL_textWidth(modeListText);
	insert(label = new TLabel(r,modeListText,NULL));

	r.top() = r.bottom();
	r.bottom() = r.top() + cellHeight*LINESPERLIST + 2*_MVIS_sysLineWidth;
	r.right() = dialogWidth - 15 - _MVIS_sysScrollBarWidth;
	modeList = new TList(r,TPoint(r.right()-r.left()-2*_MVIS_sysLineWidth,cellHeight));
	label->setAttached(modeList);

	// Now create the scroll bars for the list and attach them.

	TRect	r2(r);
	r2.left() = r2.right()-1;
	r2.right() += _MVIS_sysScrollBarWidth;
	TScrollBar *vScroll = new TScrollBar(r2);

	r.top() = r.bottom()-1;
	r.bottom() = r.top() + _MVIS_sysScrollBarWidth;
	r.right() -= 1;
	TScrollBar *hScroll = new TScrollBar(r);

	modeList->setHScroll(hScroll);
	modeList->setVScroll(vScroll);

	// Adjust the bounds of the box to fit, including the buttons

	bounds.right() = dialogWidth;
	bounds.bottom() = r.bottom() + adjustBottom + buttonHeight + 20;
	setBounds(bounds);

	// Now add the buttons to the dialog box

	int width = MGL_textWidth(setText) + 16;
	int sizex = width + 15;
	r.top() = bounds.bottom() - buttonHeight - 10;
	r.bottom() = r.top() + buttonHeight;
	r.right() =  r.left() + width;
	TButton *setBut = new TButton(r,setText,cmOk,bfDefault);

	r.left() += sizex;	r.right() +=  sizex;
	TButton *cancelBut = new TButton(r,cancelText,cmCancel,bfNormal);

	// Now insert all of the items into the dialog box in the correct
	// tab-ing order

	insert(cancelBut);
	insert(setBut);
	insert(modeList);

	// Now insert the scroll bars on top of everything else
	insert(vScroll);
	insert(hScroll);

	// Build the list of valid video mode names, and put the highlight on
	// the current video mode.

	int		i = 0,selection;
    int     *modes = MGL_availableModes(driver);
	char	buf[40];

	for (i = 0; *modes != -1; modes++) {
		for (int *p = validModes; *p != -1; p++)
			if (*p == *modes) {
				if (*modes == mode)
					selection = i;
				DynStr	*s = new DynStr(MGL_modeName(*modes));
				sprintf(buf," (%d page)",
                    MGL_availablePages(driver,*modes));
				*s += buf;
				modenames.add(s);
				i++;
				break;
				}
		}

	modeList->setDataBounds(TRect(0,0,1,modenames.numberOfItems()));
	for (i = 0; i < modenames.numberOfItems(); i++)
		modeList->setCell(0,i,*modenames[i]);
	modeList->setHRange(0,0);
	modeList->setVRange(0,modenames.numberOfItems()-1);
	modeList->clearSelection();
	modeList->selectCell(0,selection);
	modeList->setCurrentCell(0,selection);

	modeList->select();
}

void TModeSelector::handleEvent(TEvent& event,phaseType phase)
/****************************************************************************
*
* Function:		TModeSelector::handleEvent
* Parameters:	event	- Event to handle
*				phase	- Current phase for the event (pre,focus,post)
*
* Description:	Event handling routine for the TModeSelector class.
*
****************************************************************************/
{
	TDialog::handleEvent(event,phase);

	switch (event.what) {
		case evBroadcast:
			switch (event.message.command) {
				case cmListItemSelected:
					if (event.message.infoPtr == modeList) {
						endModal(cmOk);
						clearEvent(event);
						}
					break;
				}
			break;
		}
}

int TModeSelector::getMode()
/****************************************************************************
*
* Function:		TModeSelector::getMode
* Returns:		Selected video mode number.
*
****************************************************************************/
{
	TPoint		cursor;
	const char	*name;

	modeList->getCurrentCell(cursor);
	modeList->getCell(cursor.x,cursor.y,name);

	for (int i = 0; i <= grMAXMODE; i++) {
		if (strncmp(MGL_modeName(i),name,strlen(MGL_modeName(i))) == 0)
			return i;
		}
	return -1;
}
