/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tmenuite.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TMenuItem class.
*
* $Id: tmenuite.cpp 1.2 1994/03/09 11:50:43 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tmenu.hpp"

/*----------------------------- Implementation ----------------------------*/

TMenuItem::TMenuItem(const char *name,ushort command,const HotKey& hotKey,
	ushort helpCtx,const char *hotKeyText)
	: command(command), hotKey(hotKey), helpCtx(helpCtx)
/****************************************************************************
*
* Function:		TMenuItem::TMenuItem
* Parameters:	name		- Name to display for the menu item
*				command		- Command to post when activated
*				hotKey		- Altenate hot key value for menu item
*				helpCtx		- Help context number for the item
*               hotKeyText	- Text to display for HotKey value
*
* Description:	Constructor for a TMenuItem.
*
****************************************************************************/
{
	TMenuItem::name = newHotStr(name,hotChar,hotIndex);
	TMenuItem::hotKeyText = hotKeyText;
	disabled = false;		// Needs to be set on globally disabled commands!
}

void TMenuItem::TMenuItem(const char *name,TMenu *subMenu,ushort helpCtx)
	: subMenu(subMenu), helpCtx(helpCtx), hotKey(kbNoKey,0)
/****************************************************************************
*
* Function:		TMenuItem::TMenuItem
* Parameters:	name	- Name to display for menu item
*				subMenu	- Pointer to the submenu definition for the menu
*               helpCtx	- Help context number for the item
*
* Description:	Constructor for a TMenuItem. Create a submenu definition.
*
****************************************************************************/
{
	TMenuItem::name = newHotStr(name,hotChar,hotIndex);
	command = 0;
	disabled = false;
}

TMenuItem::~TMenuItem()
/****************************************************************************
*
* Function:		TMenuItem::~TMenuItem
*
* Description:	Destructor for the TMenuItem class.
*
****************************************************************************/
{
	delete name;
	if (isSubMenu())
		delete subMenu;
}
