/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tgroup.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TGroup class. This class is used
*				to group together a number of views together into a
*				single view.
*
* $Id: tgroup.hpp 1.2 1994/03/09 11:50:15 kjb Exp $
*
****************************************************************************/

#ifndef	__TGROUP_HPP
#define	__TGROUP_HPP

#ifndef	__TVIEW_HPP
#include "tview.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TGroup class is used to collect a number of views together into
// a single view.
//---------------------------------------------------------------------------

class TGroup : public TView {
protected:
	DList<TView>	children;		// List of all child views for group
	TView			*selected;		// Pointer to currently selected view
	TRect			clip;			// Clip rectangle for the group
	TRect			inner;			// Bounds for inner part of view
	ushort			endState;		// State ending the modal group
	ushort			modalState;		// State of the modal view (0 = active)

			// Internal method to process events
			void doEvent(TView& view,TEvent& event,phaseType phase);

			// Called when an event is unhandled
	virtual	void eventError(TEvent& event);

			// Get the next/prev view in the group in tab order
			TView *getNext(TView *view);
			TView *getPrev(TView *view);

			// Method to complete an insert operation
			void doInsert(TView *view);

			// Method to draw the background
	virtual	void drawBackground(const TRect& clip);

			// Method to change the current cursor
			void changeCursor();

public:
			// Constructor
			TGroup(const TRect& bounds);

			// Virtual destructor
	virtual	~TGroup();

			// Virtual to determine if the group was constructed correctly
	virtual	bool valid(ushort command);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);

			// Method to execute a specific group
			ushort execView(TGroup *view);

			// Virtual to execute the modal group
	virtual	ushort execute();

			// Method to end the modal execution of the group
			void endModal(ushort command)	{ endState = command; };

			// Methods to insert views into the group
			void insert(TView *view);
			void insertAfter(TView *view,TView *after);

			// Method to remove a view from the group
			void remove(TView *view);

			// Return a pointer to the first/last view in the group
			TView *firstView()	{ return children.peekHead(); };
			TView *lastView()	{ return children.peekTail(); };

			// Selects the specified view in the group
			void select(TView *v);

			// Selects the next/previous view in the group
			void selectNext();
			void selectPrev();

			// Method to set a state flag
	virtual	void setState(ushort state,bool set);

			// Methods to draw the group
	virtual	void draw(const TRect& clip);
	virtual	void redraw();

			// Method to set the bounds of the group
	virtual	void setBounds(const TRect& bounds);

			// Method to move the group to another location
	virtual	void moveTo(int x,int y);
			void moveTo(const TPoint& p)	{ moveTo(p.x,p.y); };

			// Method to set/get the clip rectangle
			void setClip(const TRect& c)	{ clip = c; };
			void resetClip()				{ getExtent(clip); };
			bool getClipRect(TRect& c) const;

			// Method to return the inner bounds for a window
			const TRect& innerBounds()		{ return inner; };

			// Method to find the currently active modal view
	virtual	TView *findModalView();

			// Method called when idle
	virtual	void idle();

			// Method called to obtain the cursor definition
	virtual	cursor *getCursor(const TPoint& p);

			// Method to obtain the help context number for the view
	virtual	ushort getHelpCtx() const;
	};

#endif	// __TGROUP_HPP
